/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import java.util.Collection;

import lombok.Data;

/**
 * A {@link UserAttribute} holding a generic collection of values.
 * 
 * @param <T>
 *            The type of the collection.
 */
@Data
public class CollectionUserAttribute<T> implements UserAttribute
{
    private final String name;
    private final Collection<T> values;
}
