/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import lombok.Data;

/**
 * A {@link UserAttribute} holding a simple generic value.
 *
 * @param <T>
 *            The type of the attribute.
 */
@Data
public class SimpleUserAttribute<T> implements UserAttribute
{
    private final String name;
    private final T value;
}
