/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

/**
 * A simple attribute of a {@link User}.
 * <p>
 * An attribute of a user is identified by its name. By this name it can be identified in the
 * {@link User#getAttribute(String)} method.
 */
public interface UserAttribute
{
    /**
     * The name that identifies this attribute.
     * 
     * @return The identifying attribute name.
     */
    String getName();
}
