/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user.exception;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.servlet.response.AccessDeniedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating that accessing users is denied.
 */
@NoArgsConstructor
public class UserAccessDeniedException extends RuntimeException implements WithErrorResponse
{
    private static final long serialVersionUID = 7976611643084031474L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     * 
     * @param message
     *            The exception message.
     */
    public UserAccessDeniedException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     * 
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserAccessDeniedException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserAccessDeniedException( final String message, final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new AccessDeniedResponse(null, null, "Not authorized to access users.");
    }
}
