/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user.exception;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating an issue while accessing a user.
 */
@NoArgsConstructor
public class UserAccessException extends RuntimeException
{
    private static final long serialVersionUID = -8448686405785791157L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     * 
     * @param message
     *            The exception message.
     */
    public UserAccessException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     * 
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserAccessException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserAccessException( final String message, final Throwable cause )
    {
        super(message, cause);
    }
}
