/*
 * Copyright (c) 2019 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user.exception;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.servlet.response.NotAuthenticatedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating that the user is not authenticated.
 */
@NoArgsConstructor
public class UserNotAuthenticatedException extends RuntimeException implements WithErrorResponse
{
    private static final long serialVersionUID = 278515650324336128L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     * 
     * @param message
     *            The exception message.
     */
    public UserNotAuthenticatedException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     * 
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserNotAuthenticatedException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public UserNotAuthenticatedException( final String message, final Throwable cause )
    {
        super(message, cause);
    }

    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new NotAuthenticatedResponse("User not authenticated.");
    }
}
