/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import java.util.Set;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.security.Authorization;

/**
 * This represents the information available an authenticated entity.
 * <p>
 * In case of basic authentication this will directly represent a user, in case of client credentials this is the
 * client.
 */
public interface Principal
{
    /**
     * The identifier for this Principal.
     *
     * @return The identifier.
     */
    @Nonnull
    String getId();

    /**
     * The authorizations this Principal has.
     *
     * @return A {@code Set} with the authentications.
     */
    @Nonnull
    Set<Authorization> getAuthorizations();

    /**
     * Checks whether this Principal entity has the given Authorization.
     *
     * @param authorization
     *            The Authorization to check.
     * @return {@code true} if the Principal has the given Authorization; <br>
     *         {@code false} else.
     */
    default boolean hasAuthorization( @Nonnull final Authorization authorization )
    {
        return getAuthorizations().contains(authorization);
    }
}
