/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.principal;

import javax.annotation.Nonnull;

/**
 * Facade interface encapsulating the logic to access {@link Principal} information.
 */
public interface PrincipalFacade
{
    /**
     * Gets the currently authenticated Principal.
     *
     * @return The current {@code Principal}.
     * @throws PrincipalAccessException
     *             if an error occurred while retrieving resources necessary to construct a {@code Principal}.
     */
    @Nonnull
    Principal getCurrentPrincipal()
        throws PrincipalAccessException;
}
