/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.secret.exception;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating that a key store cannot be found.
 */
@NoArgsConstructor
public class KeyStoreNotFoundException extends RuntimeException
{
    private static final long serialVersionUID = -1562194411353553362L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     * 
     * @param message
     *            The exception message.
     */
    public KeyStoreNotFoundException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     * 
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public KeyStoreNotFoundException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public KeyStoreNotFoundException( final String message, final Throwable cause )
    {
        super(message, cause);
    }
}
