/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.HttpStatus;

/**
 * Rejects a {@link HttpServletRequest}/{@link HttpServletResponse} pair, if the request was not send by a user of a
 * specified role.
 */
public class RoleFilter implements Filter
{
    private String role;

    @Override
    public void doFilter( final ServletRequest request, final ServletResponse response, final FilterChain chain )
        throws IOException,
            ServletException
    {
        if( !(response instanceof HttpServletResponse) ) {
            return;
        }

        if( !(request instanceof HttpServletRequest) ) {
            return;
        }

        final HttpServletRequest req = (HttpServletRequest) request;
        final HttpServletResponse resp = (HttpServletResponse) response;

        if( !req.isUserInRole(role) ) {
            resp.setStatus(HttpStatus.SC_UNAUTHORIZED);
        } else {
            chain.doFilter(req, resp);
        }
    }

    @Override
    public void destroy()
    {

    }

    @Override
    public void init( FilterConfig config )
        throws ServletException
    {
        role = config.getInitParameter("role");
    }
}
