/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

/**
 * A {@link SimpleUserAttribute} holding a String value.
 */
public class StringUserAttribute extends SimpleUserAttribute<String>
{
    /**
     * Creates an {@link UserAttribute} containing a String value.
     * 
     * @param name
     *            The name of this UserAttribute.
     * @param value
     *            The value of this attribute.
     */
    public StringUserAttribute( final String name, final String value )
    {
        super(name, value);
    }
}
