/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;

/**
 * Implementation of {@link AbstractRequestContextListener} that ensures the correct initialization of {@link User}s
 * when working with non-container managed threads on all supported Cloud platforms.
 */
public class UserRequestContextListener extends AbstractRequestContextListener
{
    public static final String PROPERTY_USER = UserRequestContextListener.class.getName() + ":user";

    @Override
    public int getPriority()
    {
        return DefaultPriorities.USER_LISTENER;
    }

    @Nonnull
    @Override
    protected Map<String, Property<?>> getProperties( @Nonnull final RequestContext requestContext )
    {
        final Map<String, Property<?>> properties = new HashMap<>();

        Property<User> property;
        try {
            property = Property.ofValue(UserAccessor.facade().resolveCurrentUser().orElse(null));
        }
        catch( final UserAccessException e ) {
            property = Property.ofException(e);
        }

        properties.put(PROPERTY_USER, property);
        return properties;
    }
}
