/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.secret.exception;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating that a secret store cannot be found.
 */
@NoArgsConstructor
public class SecretStoreNotFoundException extends RuntimeException
{
    private static final long serialVersionUID = -6143038000179303999L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     * 
     * @param message
     *            The exception message.
     */
    public SecretStoreNotFoundException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     * 
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public SecretStoreNotFoundException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public SecretStoreNotFoundException( final String message, final Throwable cause )
    {
        super(message, cause);
    }
}
