/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import java.util.Collection;

/**
 * A {@link CollectionUserAttribute} holding String values.
 */
public class StringCollectionUserAttribute extends CollectionUserAttribute<String>
{
    /**
     * Creates an {@link CollectionUserAttribute} containing String values.
     *
     * @param name
     *            The name of this CollectionUserAttribute.
     * @param values
     *            The values of this attribute.
     */
    public StringCollectionUserAttribute( final String name, final Collection<String> values )
    {
        super(name, values);
    }
}
