/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.security.user;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.security.Authorization;

/**
 * Represents a user of the system, containing information about his authorizations as well as his Locale and further,
 * arbitrary attributes.
 */
public interface User
{
    /**
     * @return The name of the user.
     */
    @Nonnull
    String getName();

    /**
     * @return The locale configured by the user.
     */
    @Nonnull
    Optional<Locale> getLocale();

    /**
     * Checks whether the user has the given authorization.
     *
     * @param authorization
     *            The authorization the user should have.
     *
     * @return true, if the user has the autorization, false else.
     */
    boolean hasAuthorization( final Authorization authorization );

    /**
     * A set containing all authorizations the user has.
     *
     * @return The authorizations of the user.
     */
    @Nonnull
    Set<Authorization> getAuthorizations();

    /**
     * Returns the attribute specified by the given name, wrapped in an {@code Optional}.
     *
     * @param name
     *            The name of the attribute to get.
     *
     * @return The attribute of a user by the attribute name.
     */
    @Nonnull
    Optional<UserAttribute> getAttribute( final String name );
}
