/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngDocumentCheckFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngDocumentCheckFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultAcctngDocumentCheckFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AddContractAccountsRecAndPayableDocumentLineItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AddContractAccountsRecievableAndPayableHeaderLine;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ContainerForCustomerExitParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CurrencyItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CustomerItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.GlAccountItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.Header;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PaymentCardInformation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingCoPaAcctAssignmentValueField;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingPartnerBillingDoc;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RealEstateAccountAssignmentData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.TaxItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.VendorItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.WithholdingTaxInformation;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultAcctngDocumentCheckFunction
implements AcctngDocumentCheckFunction {
    private final Header documentHeader;
    private PostingInAccountingPartnerBillingDoc customerCpd = null;
    private AddContractAccountsRecievableAndPayableHeaderLine contractHeader = null;
    @Nonnull
    private Iterable<GlAccountItem> accountGl = Lists.newArrayList();
    @Nonnull
    private Iterable<CustomerItem> accountReceivable = Lists.newArrayList();
    @Nonnull
    private Iterable<VendorItem> accountPayable = Lists.newArrayList();
    @Nonnull
    private Iterable<TaxItem> accountTax = Lists.newArrayList();
    @Nonnull
    private Iterable<CurrencyItem> currencyAmount = Lists.newArrayList();
    @Nonnull
    private Iterable<AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic> criteria = Lists.newArrayList();
    @Nonnull
    private Iterable<PostingInAccountingCoPaAcctAssignmentValueField> valuefield = Lists.newArrayList();
    @Nonnull
    private Iterable<RealEstateAccountAssignmentData> realEstate = Lists.newArrayList();
    @Nonnull
    private Iterable<ContainerForCustomerExitParameter> extension1 = Lists.newArrayList();
    @Nonnull
    private Iterable<RefStructureForParameterExtensioninExtensionout> extension2 = Lists.newArrayList();
    @Nonnull
    private Iterable<PaymentCardInformation> paymentCard = Lists.newArrayList();
    @Nonnull
    private Iterable<AddContractAccountsRecAndPayableDocumentLineItem> contractItem = Lists.newArrayList();
    @Nonnull
    private Iterable<WithholdingTaxInformation> withholdingTax = Lists.newArrayList();

    @Override
    @Nonnull
    public AcctngDocumentCheckFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultAcctngDocumentCheckFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        this.documentHeader.validate();
        if (this.customerCpd != null) {
            this.customerCpd.validate();
        }
        if (this.contractHeader != null) {
            this.contractHeader.validate();
        }
        if (this.accountGl != null) {
            for (GlAccountItem glAccountItem : this.accountGl) {
                glAccountItem.validate();
            }
        }
        if (this.accountReceivable != null) {
            for (CustomerItem customerItem : this.accountReceivable) {
                customerItem.validate();
            }
        }
        if (this.accountPayable != null) {
            for (VendorItem vendorItem : this.accountPayable) {
                vendorItem.validate();
            }
        }
        if (this.accountTax != null) {
            for (TaxItem taxItem : this.accountTax) {
                taxItem.validate();
            }
        }
        if (this.currencyAmount != null) {
            for (CurrencyItem currencyItem : this.currencyAmount) {
                currencyItem.validate();
            }
        }
        if (this.criteria != null) {
            for (AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.validate();
            }
        }
        if (this.valuefield != null) {
            for (PostingInAccountingCoPaAcctAssignmentValueField postingInAccountingCoPaAcctAssignmentValueField : this.valuefield) {
                postingInAccountingCoPaAcctAssignmentValueField.validate();
            }
        }
        if (this.realEstate != null) {
            for (RealEstateAccountAssignmentData realEstateAccountAssignmentData : this.realEstate) {
                realEstateAccountAssignmentData.validate();
            }
        }
        if (this.extension1 != null) {
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.extension1) {
                containerForCustomerExitParameter.validate();
            }
        }
        if (this.extension2 != null) {
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extension2) {
                refStructureForParameterExtensioninExtensionout.validate();
            }
        }
        if (this.paymentCard != null) {
            for (PaymentCardInformation paymentCardInformation : this.paymentCard) {
                paymentCardInformation.validate();
            }
        }
        if (this.contractItem != null) {
            for (AddContractAccountsRecAndPayableDocumentLineItem addContractAccountsRecAndPayableDocumentLineItem : this.contractItem) {
                addContractAccountsRecAndPayableDocumentLineItem.validate();
            }
        }
        if (this.withholdingTax != null) {
            for (WithholdingTaxInformation withholdingTaxInformation : this.withholdingTax) {
                withholdingTaxInformation.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_ACC_DOCUMENT_CHECK");
        ParameterFields parameterFields = query.withExportingFields("DOCUMENTHEADER", "BAPIACHE09");
        if (this.documentHeader.getAccPrinciple() != null) {
            parameterFields.field("ACC_PRINCIPLE", "ACCOUNTING_PRINCIPLE", (ErpType)this.documentHeader.getAccPrinciple());
        }
        if (this.documentHeader.getAcDocNo() != null) {
            parameterFields.field("AC_DOC_NO", "BELNR_D", (ErpType)this.documentHeader.getAcDocNo());
        }
        if (this.documentHeader.getBillCategory() != null) {
            parameterFields.field("BILL_CATEGORY", "FKTYP", (ErpType)this.documentHeader.getBillCategory());
        }
        if (this.documentHeader.getBusAct() != null) {
            parameterFields.field("BUS_ACT", "GLVOR", this.documentHeader.getBusAct());
        }
        if (this.documentHeader.getCompoAcc() != null) {
            parameterFields.field("COMPO_ACC", "COMPO", (ErpType)this.documentHeader.getCompoAcc());
        }
        if (this.documentHeader.getCompCode() != null) {
            parameterFields.field("COMP_CODE", "BUKRS", (ErpType)this.documentHeader.getCompCode());
        }
        if (this.documentHeader.getDocDate() != null) {
            parameterFields.field("DOC_DATE", "BLDAT", this.documentHeader.getDocDate());
        }
        if (this.documentHeader.getDocStatus() != null) {
            parameterFields.field("DOC_STATUS", "BAPI_ACC_DOC_STATUS", (ErpType)this.documentHeader.getDocStatus());
        }
        if (this.documentHeader.getDocType() != null) {
            parameterFields.field("DOC_TYPE", "BLART", (ErpType)this.documentHeader.getDocType());
        }
        if (this.documentHeader.getEcsEnv() != null) {
            parameterFields.field("ECS_ENV", "ACC_DTE_ECS_IF_TYPE", (ErpType)this.documentHeader.getEcsEnv());
        }
        if (this.documentHeader.getFiscYear() != null) {
            parameterFields.field("FISC_YEAR", "GJAHR", this.documentHeader.getFiscYear());
        }
        if (this.documentHeader.getFisPeriod() != null) {
            parameterFields.field("FIS_PERIOD", "MONAT", (ErpType)this.documentHeader.getFisPeriod());
        }
        if (this.documentHeader.getHeaderTxt() != null) {
            parameterFields.field("HEADER_TXT", "BKTXT", this.documentHeader.getHeaderTxt());
        }
        if (this.documentHeader.getInvoiceRecDate() != null) {
            parameterFields.field("INVOICE_REC_DATE", "REINDAT", this.documentHeader.getInvoiceRecDate());
        }
        if (this.documentHeader.getNegPostng() != null) {
            parameterFields.field("NEG_POSTNG", "XNEGP", (ErpType)this.documentHeader.getNegPostng());
        }
        if (this.documentHeader.getObjKey() != null) {
            parameterFields.field("OBJ_KEY", "AWKEY", (ErpType)this.documentHeader.getObjKey());
        }
        if (this.documentHeader.getObjKeyInv() != null) {
            parameterFields.field("OBJ_KEY_INV", "AWKEY_REB", (ErpType)this.documentHeader.getObjKeyInv());
        }
        if (this.documentHeader.getObjKeyR() != null) {
            parameterFields.field("OBJ_KEY_R", "AWKEY_REV", (ErpType)this.documentHeader.getObjKeyR());
        }
        if (this.documentHeader.getObjSys() != null) {
            parameterFields.field("OBJ_SYS", "AWSYS", (ErpType)this.documentHeader.getObjSys());
        }
        if (this.documentHeader.getObjType() != null) {
            parameterFields.field("OBJ_TYPE", "AWTYP", (ErpType)this.documentHeader.getObjType());
        }
        if (this.documentHeader.getPartialRev() != null) {
            parameterFields.field("PARTIAL_REV", "BAPI_PART_REV", (ErpType)this.documentHeader.getPartialRev());
        }
        if (this.documentHeader.getPstngDate() != null) {
            parameterFields.field("PSTNG_DATE", "BUDAT", this.documentHeader.getPstngDate());
        }
        if (this.documentHeader.getReasonRev() != null) {
            parameterFields.field("REASON_REV", "ACPI_STGRD", this.documentHeader.getReasonRev());
        }
        if (this.documentHeader.getRefDocNo() != null) {
            parameterFields.field("REF_DOC_NO", "XBLNR", (ErpType)this.documentHeader.getRefDocNo());
        }
        if (this.documentHeader.getRefDocNoLong() != null) {
            parameterFields.field("REF_DOC_NO_LONG", "XBLNR_LONG", (ErpType)this.documentHeader.getRefDocNoLong());
        }
        if (this.documentHeader.getTaxCalcDate() != null) {
            parameterFields.field("TAX_CALC_DATE", "TXDAT", this.documentHeader.getTaxCalcDate());
        }
        if (this.documentHeader.getTransDate() != null) {
            parameterFields.field("TRANS_DATE", "WWERT_D", this.documentHeader.getTransDate());
        }
        if (this.documentHeader.getUsername() != null) {
            parameterFields.field("USERNAME", "USNAM", (ErpType)this.documentHeader.getUsername());
        }
        if (this.documentHeader.getVatdate() != null) {
            parameterFields.field("VATDATE", "VATDATE", this.documentHeader.getVatdate());
        }
        parameterFields.end();
        if (this.customerCpd != null) {
            ParameterFields parameterFields2 = query.withExportingFields("CUSTOMERCPD", "BAPIACPA09");
            if (this.customerCpd.getBankAcct() != null) {
                parameterFields2.field("BANK_ACCT", "BANKN", (ErpType)this.customerCpd.getBankAcct());
            }
            if (this.customerCpd.getBankCtry() != null) {
                parameterFields2.field("BANK_CTRY", "BANKS", (ErpType)this.customerCpd.getBankCtry());
            }
            if (this.customerCpd.getBankCtryIso() != null) {
                parameterFields2.field("BANK_CTRY_ISO", "BANKS_ISO", (ErpType)this.customerCpd.getBankCtryIso());
            }
            if (this.customerCpd.getBankNo() != null) {
                parameterFields2.field("BANK_NO", "BANKL", (ErpType)this.customerCpd.getBankNo());
            }
            if (this.customerCpd.getCity() != null) {
                parameterFields2.field("CITY", "ORT01_GP", this.customerCpd.getCity());
            }
            if (this.customerCpd.getCountry() != null) {
                parameterFields2.field("COUNTRY", "LAND1_GP", (ErpType)this.customerCpd.getCountry());
            }
            if (this.customerCpd.getCountryIso() != null) {
                parameterFields2.field("COUNTRY_ISO", "LAND1_ISO", (ErpType)this.customerCpd.getCountryIso());
            }
            if (this.customerCpd.getCtrlKey() != null) {
                parameterFields2.field("CTRL_KEY", "BKONT", (ErpType)this.customerCpd.getCtrlKey());
            }
            if (this.customerCpd.getDmeInd() != null) {
                parameterFields2.field("DME_IND", "DTAMS", (ErpType)this.customerCpd.getDmeInd());
            }
            if (this.customerCpd.getEqualTax() != null) {
                parameterFields2.field("EQUAL_TAX", "ACPI_STKZA", this.customerCpd.getEqualTax());
            }
            if (this.customerCpd.getIban() != null) {
                parameterFields2.field("IBAN", "IBAN", (ErpType)this.customerCpd.getIban());
            }
            if (this.customerCpd.getInstrKey() != null) {
                parameterFields2.field("INSTR_KEY", "DTAWS", (ErpType)this.customerCpd.getInstrKey());
            }
            if (this.customerCpd.getLanguIso() != null) {
                parameterFields2.field("LANGU_ISO", "LAISO", (ErpType)this.customerCpd.getLanguIso());
            }
            if (this.customerCpd.getName() != null) {
                parameterFields2.field("NAME", "NAME1_GP", (ErpType)this.customerCpd.getName());
            }
            if (this.customerCpd.getName2() != null) {
                parameterFields2.field("NAME_2", "NAME2_GP", (ErpType)this.customerCpd.getName2());
            }
            if (this.customerCpd.getName3() != null) {
                parameterFields2.field("NAME_3", "NAME3_GP", (ErpType)this.customerCpd.getName3());
            }
            if (this.customerCpd.getName4() != null) {
                parameterFields2.field("NAME_4", "NAME4_GP", (ErpType)this.customerCpd.getName4());
            }
            if (this.customerCpd.getPobkCurac() != null) {
                parameterFields2.field("POBK_CURAC", "PSKTO", (ErpType)this.customerCpd.getPobkCurac());
            }
            if (this.customerCpd.getPobxPcd() != null) {
                parameterFields2.field("POBX_PCD", "PSTL2", (ErpType)this.customerCpd.getPobxPcd());
            }
            if (this.customerCpd.getPostlCode() != null) {
                parameterFields2.field("POSTL_CODE", "PSTLZ", (ErpType)this.customerCpd.getPostlCode());
            }
            if (this.customerCpd.getPoBox() != null) {
                parameterFields2.field("PO_BOX", "PFACH", (ErpType)this.customerCpd.getPoBox());
            }
            if (this.customerCpd.getRegion() != null) {
                parameterFields2.field("REGION", "REGIO", (ErpType)this.customerCpd.getRegion());
            }
            if (this.customerCpd.getStreet() != null) {
                parameterFields2.field("STREET", "STRAS_GP", this.customerCpd.getStreet());
            }
            if (this.customerCpd.getSwiftCode() != null) {
                parameterFields2.field("SWIFT_CODE", "SWIFT", (ErpType)this.customerCpd.getSwiftCode());
            }
            if (this.customerCpd.getTax() != null) {
                parameterFields2.field("TAX", "STKZU", (ErpType)this.customerCpd.getTax());
            }
            if (this.customerCpd.getTaxNo1() != null) {
                parameterFields2.field("TAX_NO_1", "STCD1", (ErpType)this.customerCpd.getTaxNo1());
            }
            if (this.customerCpd.getTaxNo2() != null) {
                parameterFields2.field("TAX_NO_2", "STCD2", (ErpType)this.customerCpd.getTaxNo2());
            }
            if (this.customerCpd.getTaxNo3() != null) {
                parameterFields2.field("TAX_NO_3", "STCD3", this.customerCpd.getTaxNo3());
            }
            if (this.customerCpd.getTaxNo4() != null) {
                parameterFields2.field("TAX_NO_4", "STCD4", this.customerCpd.getTaxNo4());
            }
            if (this.customerCpd.getTaxNo5() != null) {
                parameterFields2.field("TAX_NO_5", "STCD5", this.customerCpd.getTaxNo5());
            }
            if (this.customerCpd.getTitle() != null) {
                parameterFields2.field("TITLE", "ANRED", this.customerCpd.getTitle());
            }
            parameterFields2.end();
        }
        if (this.contractHeader != null) {
            ParameterFields parameterFields3 = query.withExportingFields("CONTRACTHEADER", "BAPIACCAHD");
            if (this.contractHeader.getDocNo() != null) {
                parameterFields3.field("DOC_NO", "ACPI_DOC_NO", this.contractHeader.getDocNo());
            }
            if (this.contractHeader.getDocTypeCa() != null) {
                parameterFields3.field("DOC_TYPE_CA", "ACPI_DOC_TYPE_CA", this.contractHeader.getDocTypeCa());
            }
            if (this.contractHeader.getFikey() != null) {
                parameterFields3.field("FIKEY", "ACPI_FIKEY", this.contractHeader.getFikey());
            }
            if (this.contractHeader.getPaymentFormRef() != null) {
                parameterFields3.field("PAYMENT_FORM_REF", "ACPI_PMNT_FORM_REF", this.contractHeader.getPaymentFormRef());
            }
            if (this.contractHeader.getResKey() != null) {
                parameterFields3.field("RES_KEY", "ACPI_RES_KEY", this.contractHeader.getResKey());
            }
            parameterFields3.end();
        }
        if (this.accountGl != null && this.accountGl.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTGL", "BAPIACGL09");
            for (GlAccountItem glAccountItem : this.accountGl) {
                row = table.row();
                if (glAccountItem.getAcctKey() != null) {
                    row.field("ACCT_KEY", "KTOSL", glAccountItem.getAcctKey());
                }
                if (glAccountItem.getAcctType() != null) {
                    row.field("ACCT_TYPE", "KOART", (ErpType)glAccountItem.getAcctType());
                }
                if (glAccountItem.getAcritemType() != null) {
                    row.field("ACRITEM_TYPE", "ACR_ITEM_TYPE", (ErpType)glAccountItem.getAcritemType());
                }
                if (glAccountItem.getAcrobjId() != null) {
                    row.field("ACROBJ_ID", "ACR_OBJ_ID", (ErpType)glAccountItem.getAcrobjId());
                }
                if (glAccountItem.getAcrobjType() != null) {
                    row.field("ACROBJ_TYPE", "ACR_OBJ_TYPE", (ErpType)glAccountItem.getAcrobjType());
                }
                if (glAccountItem.getAcrsubobjId() != null) {
                    row.field("ACRSUBOBJ_ID", "ACR_SUBOBJ_ID", (ErpType)glAccountItem.getAcrsubobjId());
                }
                if (glAccountItem.getActivity() != null) {
                    row.field("ACTIVITY", "VORNR", (ErpType)glAccountItem.getActivity());
                }
                if (glAccountItem.getActtype() != null) {
                    row.field("ACTTYPE", "LSTAR", (ErpType)glAccountItem.getActtype());
                }
                if (glAccountItem.getAcDocNo() != null) {
                    row.field("AC_DOC_NO", "BELNR_D", (ErpType)glAccountItem.getAcDocNo());
                }
                if (glAccountItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)glAccountItem.getAllocNmbr());
                }
                if (glAccountItem.getAssetNo() != null) {
                    row.field("ASSET_NO", "ANLN1", (ErpType)glAccountItem.getAssetNo());
                }
                if (glAccountItem.getAsvalDate() != null) {
                    row.field("ASVAL_DATE", "BF_BZDAT", glAccountItem.getAsvalDate());
                }
                if (glAccountItem.getBaseUom() != null) {
                    row.field("BASE_UOM", "MEINS", (ErpType)glAccountItem.getBaseUom());
                }
                if (glAccountItem.getBaseUomIso() != null) {
                    row.field("BASE_UOM_ISO", "MEINS_ISO", (ErpType)glAccountItem.getBaseUomIso());
                }
                if (glAccountItem.getBillingPeriodEndDate() != null) {
                    row.field("BILLING_PERIOD_END_DATE", "FM_PEROP_FI_HIGH", glAccountItem.getBillingPeriodEndDate());
                }
                if (glAccountItem.getBillingPeriodStartDate() != null) {
                    row.field("BILLING_PERIOD_START_DATE", "FM_PEROP_FI_LOW", glAccountItem.getBillingPeriodStartDate());
                }
                if (glAccountItem.getBillType() != null) {
                    row.field("BILL_TYPE", "FKART", (ErpType)glAccountItem.getBillType());
                }
                if (glAccountItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)glAccountItem.getBudgetPeriod());
                }
                if (glAccountItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)glAccountItem.getBusArea());
                }
                if (glAccountItem.getBusScenario() != null) {
                    row.field("BUS_SCENARIO", "ACPI_IAOM_BS_ID", glAccountItem.getBusScenario());
                }
                if (glAccountItem.getCmmtItem() != null) {
                    row.field("CMMT_ITEM", "FIPOS", (ErpType)glAccountItem.getCmmtItem());
                }
                if (glAccountItem.getCmmtItemLong() != null) {
                    row.field("CMMT_ITEM_LONG", "FM_FIPEX", (ErpType)glAccountItem.getCmmtItemLong());
                }
                if (glAccountItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)glAccountItem.getCompCode());
                }
                if (glAccountItem.getCondCategory() != null) {
                    row.field("COND_CATEGORY", "ACPI_KNTYP", (ErpType)glAccountItem.getCondCategory());
                }
                if (glAccountItem.getCondCount() != null) {
                    row.field("COND_COUNT", "ACPI_DZAEHK", (ErpType)glAccountItem.getCondCount());
                }
                if (glAccountItem.getCondStNo() != null) {
                    row.field("COND_ST_NO", "ACPI_STUNR", (ErpType)glAccountItem.getCondStNo());
                }
                if (glAccountItem.getCondType() != null) {
                    row.field("COND_TYPE", "KSCHA", (ErpType)glAccountItem.getCondType());
                }
                if (glAccountItem.getCostcenter() != null) {
                    row.field("COSTCENTER", "KOSTL", (ErpType)glAccountItem.getCostcenter());
                }
                if (glAccountItem.getCostobject() != null) {
                    row.field("COSTOBJECT", "KSTRG", (ErpType)glAccountItem.getCostobject());
                }
                if (glAccountItem.getCoBusproc() != null) {
                    row.field("CO_BUSPROC", "CO_PRZNR", (ErpType)glAccountItem.getCoBusproc());
                }
                if (glAccountItem.getCshdisInd() != null) {
                    row.field("CSHDIS_IND", "XSKRL", (ErpType)glAccountItem.getCshdisInd());
                }
                if (glAccountItem.getCsTransT() != null) {
                    row.field("CS_TRANS_T", "RMVCT", (ErpType)glAccountItem.getCsTransT());
                }
                if (glAccountItem.getCustomer() != null) {
                    row.field("CUSTOMER", "KUNNR", (ErpType)glAccountItem.getCustomer());
                }
                if (glAccountItem.getDeCreInd() != null) {
                    row.field("DE_CRE_IND", "ACPI_TBTKZ", glAccountItem.getDeCreInd());
                }
                if (glAccountItem.getDistrChan() != null) {
                    row.field("DISTR_CHAN", "VTWEG", (ErpType)glAccountItem.getDistrChan());
                }
                if (glAccountItem.getDivision() != null) {
                    row.field("DIVISION", "SPART", (ErpType)glAccountItem.getDivision());
                }
                if (glAccountItem.getDocType() != null) {
                    row.field("DOC_TYPE", "BLART", (ErpType)glAccountItem.getDocType());
                }
                if (glAccountItem.getEntryQnt() != null) {
                    row.field("ENTRY_QNT", "ERFMG", (ErpType)glAccountItem.getEntryQnt());
                }
                if (glAccountItem.getEntryUom() != null) {
                    row.field("ENTRY_UOM", "ERFME", (ErpType)glAccountItem.getEntryUom());
                }
                if (glAccountItem.getEntryUomIso() != null) {
                    row.field("ENTRY_UOM_ISO", "ERFME_ISO", (ErpType)glAccountItem.getEntryUomIso());
                }
                if (glAccountItem.getExpenseType() != null) {
                    row.field("EXPENSE_TYPE", "GTR_CRM_EXPENSE_CAT", (ErpType)glAccountItem.getExpenseType());
                }
                if (glAccountItem.getExtObjectId() != null) {
                    row.field("EXT_OBJECT_ID", "ACPI_IAOM_EO_ID", glAccountItem.getExtObjectId());
                }
                if (glAccountItem.getFastpay() != null) {
                    row.field("FASTPAY", "FMFG_FASTPAY_FLG", (ErpType)glAccountItem.getFastpay());
                }
                if (glAccountItem.getFiscYear() != null) {
                    row.field("FISC_YEAR", "GJAHR", glAccountItem.getFiscYear());
                }
                if (glAccountItem.getFisPeriod() != null) {
                    row.field("FIS_PERIOD", "MONAT", (ErpType)glAccountItem.getFisPeriod());
                }
                if (glAccountItem.getFmArea() != null) {
                    row.field("FM_AREA", "FIKRS", (ErpType)glAccountItem.getFmArea());
                }
                if (glAccountItem.getFuncArea() != null) {
                    row.field("FUNC_AREA", "FKBER_SHORT", (ErpType)glAccountItem.getFuncArea());
                }
                if (glAccountItem.getFuncAreaLong() != null) {
                    row.field("FUNC_AREA_LONG", "FKBER", (ErpType)glAccountItem.getFuncAreaLong());
                }
                if (glAccountItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)glAccountItem.getFund());
                }
                if (glAccountItem.getFundsCtr() != null) {
                    row.field("FUNDS_CTR", "FISTL", (ErpType)glAccountItem.getFundsCtr());
                }
                if (glAccountItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)glAccountItem.getGlAccount());
                }
                if (glAccountItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)glAccountItem.getGrantNbr());
                }
                if (glAccountItem.getGrossWt() != null) {
                    row.field("GROSS_WT", "ACPI_BRGEW_15", (ErpType)glAccountItem.getGrossWt());
                }
                if (glAccountItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)glAccountItem.getHousebankacctid());
                }
                if (glAccountItem.getHousebankid() != null) {
                    row.field("HOUSEBANKID", "HBKID", (ErpType)glAccountItem.getHousebankid());
                }
                if (glAccountItem.getInvQty() != null) {
                    row.field("INV_QTY", "ACPI_FKIMG", (ErpType)glAccountItem.getInvQty());
                }
                if (glAccountItem.getInvQtySu() != null) {
                    row.field("INV_QTY_SU", "ACPI_FKLMG", (ErpType)glAccountItem.getInvQtySu());
                }
                if (glAccountItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)glAccountItem.getItemnoAcc());
                }
                if (glAccountItem.getItemnoTax() != null) {
                    row.field("ITEMNO_TAX", "TAXPS", (ErpType)glAccountItem.getItemnoTax());
                }
                if (glAccountItem.getItemCat() != null) {
                    row.field("ITEM_CAT", "ACPI_PSTYP", glAccountItem.getItemCat());
                }
                if (glAccountItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", glAccountItem.getItemText());
                }
                if (glAccountItem.getItmNumber() != null) {
                    row.field("ITM_NUMBER", "POSNR", (ErpType)glAccountItem.getItmNumber());
                }
                if (glAccountItem.getLogProc() != null) {
                    row.field("LOG_PROC", "LOGVO", (ErpType)glAccountItem.getLogProc());
                }
                if (glAccountItem.getMaterial() != null) {
                    row.field("MATERIAL", "MATNR18", (ErpType)glAccountItem.getMaterial());
                }
                if (glAccountItem.getMaterialLong() != null) {
                    row.field("MATERIAL_LONG", "MATNR40", (ErpType)glAccountItem.getMaterialLong());
                }
                if (glAccountItem.getMatlType() != null) {
                    row.field("MATL_TYPE", "ACPI_MTART", glAccountItem.getMatlType());
                }
                if (glAccountItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)glAccountItem.getMeasure());
                }
                if (glAccountItem.getMvtInd() != null) {
                    row.field("MVT_IND", "KZBEW", (ErpType)glAccountItem.getMvtInd());
                }
                if (glAccountItem.getNetwork() != null) {
                    row.field("NETWORK", "NPLNR", (ErpType)glAccountItem.getNetwork());
                }
                if (glAccountItem.getNetWeight() != null) {
                    row.field("NET_WEIGHT", "ACPI_NTGEW_15", (ErpType)glAccountItem.getNetWeight());
                }
                if (glAccountItem.getOrderid() != null) {
                    row.field("ORDERID", "AUFNR", (ErpType)glAccountItem.getOrderid());
                }
                if (glAccountItem.getOrderItno() != null) {
                    row.field("ORDER_ITNO", "CO_POSNR", (ErpType)glAccountItem.getOrderItno());
                }
                if (glAccountItem.getOrigGroup() != null) {
                    row.field("ORIG_GROUP", "HRKFT", (ErpType)glAccountItem.getOrigGroup());
                }
                if (glAccountItem.getOrigMat() != null) {
                    row.field("ORIG_MAT", "HKMAT", (ErpType)glAccountItem.getOrigMat());
                }
                if (glAccountItem.getPartnerBudgetPeriod() != null) {
                    row.field("PARTNER_BUDGET_PERIOD", "FM_PBUDGET_PERIOD", (ErpType)glAccountItem.getPartnerBudgetPeriod());
                }
                if (glAccountItem.getPartnerFund() != null) {
                    row.field("PARTNER_FUND", "FM_PFUND", (ErpType)glAccountItem.getPartnerFund());
                }
                if (glAccountItem.getPartnerGrantNbr() != null) {
                    row.field("PARTNER_GRANT_NBR", "GM_PGRANT_NBR", (ErpType)glAccountItem.getPartnerGrantNbr());
                }
                if (glAccountItem.getPartnerSegment() != null) {
                    row.field("PARTNER_SEGMENT", "FB_PSEGMENT", (ErpType)glAccountItem.getPartnerSegment());
                }
                if (glAccountItem.getPartAcct() != null) {
                    row.field("PART_ACCT", "JV_PART", (ErpType)glAccountItem.getPartAcct());
                }
                if (glAccountItem.getPartPrctr() != null) {
                    row.field("PART_PRCTR", "PPRCTR", (ErpType)glAccountItem.getPartPrctr());
                }
                if (glAccountItem.getPaymentType() != null) {
                    row.field("PAYMENT_TYPE", "GTR_CRM_PAYMENT_TYPE", (ErpType)glAccountItem.getPaymentType());
                }
                if (glAccountItem.getPersonNo() != null) {
                    row.field("PERSON_NO", "PERNR_D", (ErpType)glAccountItem.getPersonNo());
                }
                if (glAccountItem.getPlant() != null) {
                    row.field("PLANT", "WERKS_D", (ErpType)glAccountItem.getPlant());
                }
                if (glAccountItem.getPoItem() != null) {
                    row.field("PO_ITEM", "EBELP", (ErpType)glAccountItem.getPoItem());
                }
                if (glAccountItem.getPoNumber() != null) {
                    row.field("PO_NUMBER", "EBELN", (ErpType)glAccountItem.getPoNumber());
                }
                if (glAccountItem.getPoPrQnt() != null) {
                    row.field("PO_PR_QNT", "ACPI_BPMNG", (ErpType)glAccountItem.getPoPrQnt());
                }
                if (glAccountItem.getPoPrUom() != null) {
                    row.field("PO_PR_UOM", "ACPI_BPRME", (ErpType)glAccountItem.getPoPrUom());
                }
                if (glAccountItem.getPoPrUomIso() != null) {
                    row.field("PO_PR_UOM_ISO", "BPRME_ISO", (ErpType)glAccountItem.getPoPrUomIso());
                }
                if (glAccountItem.getPpaExInd() != null) {
                    row.field("PPA_EX_IND", "EXCLUDE_FLG", (ErpType)glAccountItem.getPpaExInd());
                }
                if (glAccountItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)glAccountItem.getProfitCtr());
                }
                if (glAccountItem.getProgramProfile() != null) {
                    row.field("PROGRAM_PROFILE", "GTR_CRM_PROG_PROFILE", (ErpType)glAccountItem.getProgramProfile());
                }
                if (glAccountItem.getPstngDate() != null) {
                    row.field("PSTNG_DATE", "BUDAT", glAccountItem.getPstngDate());
                }
                if (glAccountItem.getPElPrctr() != null) {
                    row.field("P_EL_PRCTR", "ACPI_EPRCTR", (ErpType)glAccountItem.getPElPrctr());
                }
                if (glAccountItem.getQuantity() != null) {
                    row.field("QUANTITY", "MENGE_D", (ErpType)glAccountItem.getQuantity());
                }
                if (glAccountItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", glAccountItem.getRefKey1());
                }
                if (glAccountItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", glAccountItem.getRefKey2());
                }
                if (glAccountItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", glAccountItem.getRefKey3());
                }
                if (glAccountItem.getResDoc() != null) {
                    row.field("RES_DOC", "KBLNR", (ErpType)glAccountItem.getResDoc());
                }
                if (glAccountItem.getResItem() != null) {
                    row.field("RES_ITEM", "KBLPOS", (ErpType)glAccountItem.getResItem());
                }
                if (glAccountItem.getRevalInd() != null) {
                    row.field("REVAL_IND", "ACPI_XUMBW", (ErpType)glAccountItem.getRevalInd());
                }
                if (glAccountItem.getRoutingNo() != null) {
                    row.field("ROUTING_NO", "CO_AUFPL", (ErpType)glAccountItem.getRoutingNo());
                }
                if (glAccountItem.getSalesorg() != null) {
                    row.field("SALESORG", "VKORG", (ErpType)glAccountItem.getSalesorg());
                }
                if (glAccountItem.getSalesGrp() != null) {
                    row.field("SALES_GRP", "VKGRP", (ErpType)glAccountItem.getSalesGrp());
                }
                if (glAccountItem.getSalesOff() != null) {
                    row.field("SALES_OFF", "VKBUR", (ErpType)glAccountItem.getSalesOff());
                }
                if (glAccountItem.getSalesOrd() != null) {
                    row.field("SALES_ORD", "KDAUF", (ErpType)glAccountItem.getSalesOrd());
                }
                if (glAccountItem.getSalesUnit() != null) {
                    row.field("SALES_UNIT", "VRKME", (ErpType)glAccountItem.getSalesUnit());
                }
                if (glAccountItem.getSalesUnitIso() != null) {
                    row.field("SALES_UNIT_ISO", "ACPI_VRKME_ISO", (ErpType)glAccountItem.getSalesUnitIso());
                }
                if (glAccountItem.getSegment() != null) {
                    row.field("SEGMENT", "FB_SEGMENT", (ErpType)glAccountItem.getSegment());
                }
                if (glAccountItem.getSerialNo() != null) {
                    row.field("SERIAL_NO", "ACPI_DZEKKN", (ErpType)glAccountItem.getSerialNo());
                }
                if (glAccountItem.getSoldTo() != null) {
                    row.field("SOLD_TO", "KUNAG", (ErpType)glAccountItem.getSoldTo());
                }
                if (glAccountItem.getStatCon() != null) {
                    row.field("STAT_CON", "ACPI_KSTAZ", glAccountItem.getStatCon());
                }
                if (glAccountItem.getSubNumber() != null) {
                    row.field("SUB_NUMBER", "ANLN2", (ErpType)glAccountItem.getSubNumber());
                }
                if (glAccountItem.getSOrdItem() != null) {
                    row.field("S_ORD_ITEM", "KDPOS", (ErpType)glAccountItem.getSOrdItem());
                }
                if (glAccountItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)glAccountItem.getTaxjurcode());
                }
                if (glAccountItem.getTaxCalcDate() != null) {
                    row.field("TAX_CALC_DATE", "TXDAT", glAccountItem.getTaxCalcDate());
                }
                if (glAccountItem.getTaxCalcDtFrom() != null) {
                    row.field("TAX_CALC_DT_FROM", "FOT_TXDAT_FROM", glAccountItem.getTaxCalcDtFrom());
                }
                if (glAccountItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)glAccountItem.getTaxCode());
                }
                if (glAccountItem.getTradeId() != null) {
                    row.field("TRADE_ID", "RASSC", (ErpType)glAccountItem.getTradeId());
                }
                if (glAccountItem.getTrPartBa() != null) {
                    row.field("TR_PART_BA", "PARGB", (ErpType)glAccountItem.getTrPartBa());
                }
                if (glAccountItem.getUnitOfWt() != null) {
                    row.field("UNIT_OF_WT", "ACPI_GEWEI", (ErpType)glAccountItem.getUnitOfWt());
                }
                if (glAccountItem.getUnitOfWtIso() != null) {
                    row.field("UNIT_OF_WT_ISO", "ACPI_GEWEI_ISO", (ErpType)glAccountItem.getUnitOfWtIso());
                }
                if (glAccountItem.getValobjtype() != null) {
                    row.field("VALOBJTYPE", "VAL_OBJ_TYPE", (ErpType)glAccountItem.getValobjtype());
                }
                if (glAccountItem.getValobjId() != null) {
                    row.field("VALOBJ_ID", "VAL_OBJ_ID", (ErpType)glAccountItem.getValobjId());
                }
                if (glAccountItem.getValsubobjId() != null) {
                    row.field("VALSUBOBJ_ID", "VAL_SUBOBJ_ID", (ErpType)glAccountItem.getValsubobjId());
                }
                if (glAccountItem.getValueDate() != null) {
                    row.field("VALUE_DATE", "VALUT", glAccountItem.getValueDate());
                }
                if (glAccountItem.getValArea() != null) {
                    row.field("VAL_AREA", "BWKEY", (ErpType)glAccountItem.getValArea());
                }
                if (glAccountItem.getValType() != null) {
                    row.field("VAL_TYPE", "BWTAR_D", (ErpType)glAccountItem.getValType());
                }
                if (glAccountItem.getVendorNo() != null) {
                    row.field("VENDOR_NO", "LIFNR", (ErpType)glAccountItem.getVendorNo());
                }
                if (glAccountItem.getVolume() != null) {
                    row.field("VOLUME", "ACPI_VOLUM_15", (ErpType)glAccountItem.getVolume());
                }
                if (glAccountItem.getVolumeunit() != null) {
                    row.field("VOLUMEUNIT", "ACPI_VOLEH", (ErpType)glAccountItem.getVolumeunit());
                }
                if (glAccountItem.getVolumeunitIso() != null) {
                    row.field("VOLUMEUNIT_ISO", "ACPI_VOLEH_ISO", (ErpType)glAccountItem.getVolumeunitIso());
                }
                if (glAccountItem.getWbsElement() != null) {
                    row.field("WBS_ELEMENT", "PS_POSID", (ErpType)glAccountItem.getWbsElement());
                }
                if (glAccountItem.getXmfrw() == null) continue;
                row.field("XMFRW", "ACPI_XMFRW", (ErpType)glAccountItem.getXmfrw());
            }
            table.end();
        }
        if (this.accountReceivable != null && this.accountReceivable.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTRECEIVABLE", "BAPIACAR09");
            for (CustomerItem customerItem : this.accountReceivable) {
                row = table.row();
                if (customerItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)customerItem.getAllocNmbr());
                }
                if (customerItem.getAltPayee() != null) {
                    row.field("ALT_PAYEE", "VVABWZE", (ErpType)customerItem.getAltPayee());
                }
                if (customerItem.getAltPayeeBank() != null) {
                    row.field("ALT_PAYEE_BANK", "VVBVTYPABW", (ErpType)customerItem.getAltPayeeBank());
                }
                if (customerItem.getBankId() != null) {
                    row.field("BANK_ID", "HBKID", (ErpType)customerItem.getBankId());
                }
                if (customerItem.getBlineDate() != null) {
                    row.field("BLINE_DATE", "ACPI_ZFBDT", customerItem.getBlineDate());
                }
                if (customerItem.getBranch() != null) {
                    row.field("BRANCH", "ACPI_FILKD", (ErpType)customerItem.getBranch());
                }
                if (customerItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)customerItem.getBudgetPeriod());
                }
                if (customerItem.getBusinessplace() != null) {
                    row.field("BUSINESSPLACE", "ACPI_BRANCH", customerItem.getBusinessplace());
                }
                if (customerItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)customerItem.getBusArea());
                }
                if (customerItem.getCaseGuid() != null) {
                    row.field("CASE_GUID", "SCMG_CASE_GUID", (ErpType)customerItem.getCaseGuid());
                }
                if (customerItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)customerItem.getCompCode());
                }
                if (customerItem.getCustomer() != null) {
                    row.field("CUSTOMER", "KUNNR", (ErpType)customerItem.getCustomer());
                }
                if (customerItem.getCCtrArea() != null) {
                    row.field("C_CTR_AREA", "ACPI_KKBER", customerItem.getCCtrArea());
                }
                if (customerItem.getDisputeIfType() != null) {
                    row.field("DISPUTE_IF_TYPE", "DISPUTE_IF_TYPE", (ErpType)customerItem.getDisputeIfType());
                }
                if (customerItem.getDsctDays1() != null) {
                    row.field("DSCT_DAYS1", "ACPI_ZBD1T", (ErpType)customerItem.getDsctDays1());
                }
                if (customerItem.getDsctDays2() != null) {
                    row.field("DSCT_DAYS2", "ACPI_ZBD2T", (ErpType)customerItem.getDsctDays2());
                }
                if (customerItem.getDsctPct1() != null) {
                    row.field("DSCT_PCT1", "ACPI_ZBD1P", (ErpType)customerItem.getDsctPct1());
                }
                if (customerItem.getDsctPct2() != null) {
                    row.field("DSCT_PCT2", "ACPI_ZBD2P", (ErpType)customerItem.getDsctPct2());
                }
                if (customerItem.getDunnArea() != null) {
                    row.field("DUNN_AREA", "ACPI_MABER", (ErpType)customerItem.getDunnArea());
                }
                if (customerItem.getDunnBlock() != null) {
                    row.field("DUNN_BLOCK", "ACPI_MANSP", customerItem.getDunnBlock());
                }
                if (customerItem.getDunnKey() != null) {
                    row.field("DUNN_KEY", "ACPI_MSCHL", customerItem.getDunnKey());
                }
                if (customerItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)customerItem.getFund());
                }
                if (customerItem.getFundLong() != null) {
                    row.field("FUND_LONG", "FM_FUND_LONG", (ErpType)customerItem.getFundLong());
                }
                if (customerItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)customerItem.getGlAccount());
                }
                if (customerItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)customerItem.getGrantNbr());
                }
                if (customerItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)customerItem.getHousebankacctid());
                }
                if (customerItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)customerItem.getItemnoAcc());
                }
                if (customerItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", customerItem.getItemText());
                }
                if (customerItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)customerItem.getMeasure());
                }
                if (customerItem.getNetterms() != null) {
                    row.field("NETTERMS", "ACPI_ZBD3T", (ErpType)customerItem.getNetterms());
                }
                if (customerItem.getPartnerBk() != null) {
                    row.field("PARTNER_BK", "BVTYP", (ErpType)customerItem.getPartnerBk());
                }
                if (customerItem.getPartnerGuid() != null) {
                    row.field("PARTNER_GUID", "ACPI_GC_PARTNEG", customerItem.getPartnerGuid());
                }
                if (customerItem.getPartBusinessplace() != null) {
                    row.field("PART_BUSINESSPLACE", "BCODE", (ErpType)customerItem.getPartBusinessplace());
                }
                if (customerItem.getPaymtRef() != null) {
                    row.field("PAYMT_REF", "ACPI_KIDNO", customerItem.getPaymtRef());
                }
                if (customerItem.getPaysProv() != null) {
                    row.field("PAYS_PROV", "COM_WEC_PAYMENT_SRV_PROVIDER", (ErpType)customerItem.getPaysProv());
                }
                if (customerItem.getPaysTran() != null) {
                    row.field("PAYS_TRAN", "FPS_TRANSACTION", (ErpType)customerItem.getPaysTran());
                }
                if (customerItem.getPmnttrms() != null) {
                    row.field("PMNTTRMS", "ACPI_ZTERM", customerItem.getPmnttrms());
                }
                if (customerItem.getPmntBlock() != null) {
                    row.field("PMNT_BLOCK", "ACPI_ZLSPR", customerItem.getPmntBlock());
                }
                if (customerItem.getPmtmthsupl() != null) {
                    row.field("PMTMTHSUPL", "UZAWE", (ErpType)customerItem.getPmtmthsupl());
                }
                if (customerItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)customerItem.getProfitCtr());
                }
                if (customerItem.getPymtAmt() != null) {
                    row.field("PYMT_AMT", "ACPI_PYAMT", (ErpType)customerItem.getPymtAmt());
                }
                if (customerItem.getPymtAmtLong() != null) {
                    row.field("PYMT_AMT_LONG", "ACPI_PYAMT_31", (ErpType)customerItem.getPymtAmtLong());
                }
                if (customerItem.getPymtCur() != null) {
                    row.field("PYMT_CUR", "ACPI_PYCUR", (ErpType)customerItem.getPymtCur());
                }
                if (customerItem.getPymtCurIso() != null) {
                    row.field("PYMT_CUR_ISO", "WAERS_ISO", (ErpType)customerItem.getPymtCurIso());
                }
                if (customerItem.getPymtMeth() != null) {
                    row.field("PYMT_METH", "ACPI_ZLSCH", (ErpType)customerItem.getPymtMeth());
                }
                if (customerItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", customerItem.getRefKey1());
                }
                if (customerItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", customerItem.getRefKey2());
                }
                if (customerItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", customerItem.getRefKey3());
                }
                if (customerItem.getRepCountryEu() != null) {
                    row.field("REP_COUNTRY_EU", "EGMLD_BSEZ", (ErpType)customerItem.getRepCountryEu());
                }
                if (customerItem.getResDoc() != null) {
                    row.field("RES_DOC", "KBLNR", (ErpType)customerItem.getResDoc());
                }
                if (customerItem.getResItem() != null) {
                    row.field("RES_ITEM", "KBLPOS", (ErpType)customerItem.getResItem());
                }
                if (customerItem.getSalesOrd() != null) {
                    row.field("SALES_ORD", "KDAUF", (ErpType)customerItem.getSalesOrd());
                }
                if (customerItem.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)customerItem.getScbankInd());
                }
                if (customerItem.getSectioncode() != null) {
                    row.field("SECTIONCODE", "ACPI_SECCO1", customerItem.getSectioncode());
                }
                if (customerItem.getSepaMandateId() != null) {
                    row.field("SEPA_MANDATE_ID", "SEPA_MNDID", (ErpType)customerItem.getSepaMandateId());
                }
                if (customerItem.getSpGlInd() != null) {
                    row.field("SP_GL_IND", "ACPI_UMSKZ", customerItem.getSpGlInd());
                }
                if (customerItem.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)customerItem.getSupcountry());
                }
                if (customerItem.getSupcountryIso() != null) {
                    row.field("SUPCOUNTRY_ISO", "LANDL_ISO", (ErpType)customerItem.getSupcountryIso());
                }
                if (customerItem.getSOrdItem() != null) {
                    row.field("S_ORD_ITEM", "KDPOS", (ErpType)customerItem.getSOrdItem());
                }
                if (customerItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)customerItem.getTaxjurcode());
                }
                if (customerItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)customerItem.getTaxCode());
                }
                if (customerItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", customerItem.getTaxDate());
                }
                if (customerItem.getVatRegNo() == null) continue;
                row.field("VAT_REG_NO", "STCEG", (ErpType)customerItem.getVatRegNo());
            }
            table.end();
        }
        if (this.accountPayable != null && this.accountPayable.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTPAYABLE", "BAPIACAP09");
            for (VendorItem vendorItem : this.accountPayable) {
                row = table.row();
                if (vendorItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)vendorItem.getAllocNmbr());
                }
                if (vendorItem.getAltPayee() != null) {
                    row.field("ALT_PAYEE", "VVABWZE", (ErpType)vendorItem.getAltPayee());
                }
                if (vendorItem.getAltPayeeBank() != null) {
                    row.field("ALT_PAYEE_BANK", "VVBVTYPABW", (ErpType)vendorItem.getAltPayeeBank());
                }
                if (vendorItem.getBankId() != null) {
                    row.field("BANK_ID", "HBKID", (ErpType)vendorItem.getBankId());
                }
                if (vendorItem.getBlineDate() != null) {
                    row.field("BLINE_DATE", "ACPI_ZFBDT", vendorItem.getBlineDate());
                }
                if (vendorItem.getBllsrvInd() != null) {
                    row.field("BLLSRV_IND", "DIEKZ", (ErpType)vendorItem.getBllsrvInd());
                }
                if (vendorItem.getBranch() != null) {
                    row.field("BRANCH", "ACPI_FILKD", (ErpType)vendorItem.getBranch());
                }
                if (vendorItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)vendorItem.getBudgetPeriod());
                }
                if (vendorItem.getBusinessplace() != null) {
                    row.field("BUSINESSPLACE", "ACPI_BRANCH", vendorItem.getBusinessplace());
                }
                if (vendorItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)vendorItem.getBusArea());
                }
                if (vendorItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)vendorItem.getCompCode());
                }
                if (vendorItem.getDsctDays1() != null) {
                    row.field("DSCT_DAYS1", "ACPI_ZBD1T", (ErpType)vendorItem.getDsctDays1());
                }
                if (vendorItem.getDsctDays2() != null) {
                    row.field("DSCT_DAYS2", "ACPI_ZBD2T", (ErpType)vendorItem.getDsctDays2());
                }
                if (vendorItem.getDsctPct1() != null) {
                    row.field("DSCT_PCT1", "ACPI_ZBD1P", (ErpType)vendorItem.getDsctPct1());
                }
                if (vendorItem.getDsctPct2() != null) {
                    row.field("DSCT_PCT2", "ACPI_ZBD2P", (ErpType)vendorItem.getDsctPct2());
                }
                if (vendorItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)vendorItem.getFund());
                }
                if (vendorItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)vendorItem.getGlAccount());
                }
                if (vendorItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)vendorItem.getGrantNbr());
                }
                if (vendorItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)vendorItem.getHousebankacctid());
                }
                if (vendorItem.getInstr1() != null) {
                    row.field("INSTR1", "DTAT16", (ErpType)vendorItem.getInstr1());
                }
                if (vendorItem.getInstr2() != null) {
                    row.field("INSTR2", "DTAT17", (ErpType)vendorItem.getInstr2());
                }
                if (vendorItem.getInstr3() != null) {
                    row.field("INSTR3", "DTAT18", (ErpType)vendorItem.getInstr3());
                }
                if (vendorItem.getInstr4() != null) {
                    row.field("INSTR4", "DTAT19", (ErpType)vendorItem.getInstr4());
                }
                if (vendorItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)vendorItem.getItemnoAcc());
                }
                if (vendorItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", vendorItem.getItemText());
                }
                if (vendorItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)vendorItem.getMeasure());
                }
                if (vendorItem.getNetterms() != null) {
                    row.field("NETTERMS", "ACPI_ZBD3T", (ErpType)vendorItem.getNetterms());
                }
                if (vendorItem.getPartnerBk() != null) {
                    row.field("PARTNER_BK", "BVTYP", (ErpType)vendorItem.getPartnerBk());
                }
                if (vendorItem.getPartnerGuid() != null) {
                    row.field("PARTNER_GUID", "ACPI_GC_PARTNEG", vendorItem.getPartnerGuid());
                }
                if (vendorItem.getPartBusinessplace() != null) {
                    row.field("PART_BUSINESSPLACE", "BCODE", (ErpType)vendorItem.getPartBusinessplace());
                }
                if (vendorItem.getPaymtRef() != null) {
                    row.field("PAYMT_REF", "ACPI_KIDNO", vendorItem.getPaymtRef());
                }
                if (vendorItem.getPmnttrms() != null) {
                    row.field("PMNTTRMS", "ACPI_ZTERM", vendorItem.getPmnttrms());
                }
                if (vendorItem.getPmntBlock() != null) {
                    row.field("PMNT_BLOCK", "ACPI_ZLSPR", vendorItem.getPmntBlock());
                }
                if (vendorItem.getPmtmthsupl() != null) {
                    row.field("PMTMTHSUPL", "UZAWE", (ErpType)vendorItem.getPmtmthsupl());
                }
                if (vendorItem.getPoCheckdg() != null) {
                    row.field("PO_CHECKDG", "ESRPZ", vendorItem.getPoCheckdg());
                }
                if (vendorItem.getPoRefNo() != null) {
                    row.field("PO_REF_NO", "ESRRE", (ErpType)vendorItem.getPoRefNo());
                }
                if (vendorItem.getPoSubNo() != null) {
                    row.field("PO_SUB_NO", "ESRNR", (ErpType)vendorItem.getPoSubNo());
                }
                if (vendorItem.getPpaExInd() != null) {
                    row.field("PPA_EX_IND", "EXCLUDE_FLG", (ErpType)vendorItem.getPpaExInd());
                }
                if (vendorItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)vendorItem.getProfitCtr());
                }
                if (vendorItem.getPymtAmt() != null) {
                    row.field("PYMT_AMT", "ACPI_PYAMT", (ErpType)vendorItem.getPymtAmt());
                }
                if (vendorItem.getPymtAmtLong() != null) {
                    row.field("PYMT_AMT_LONG", "ACPI_PYAMT_31", (ErpType)vendorItem.getPymtAmtLong());
                }
                if (vendorItem.getPymtCur() != null) {
                    row.field("PYMT_CUR", "ACPI_PYCUR", (ErpType)vendorItem.getPymtCur());
                }
                if (vendorItem.getPymtCurIso() != null) {
                    row.field("PYMT_CUR_ISO", "WAERS_ISO", (ErpType)vendorItem.getPymtCurIso());
                }
                if (vendorItem.getPymtMeth() != null) {
                    row.field("PYMT_METH", "ACPI_ZLSCH", (ErpType)vendorItem.getPymtMeth());
                }
                if (vendorItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", vendorItem.getRefKey1());
                }
                if (vendorItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", vendorItem.getRefKey2());
                }
                if (vendorItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", vendorItem.getRefKey3());
                }
                if (vendorItem.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)vendorItem.getScbankInd());
                }
                if (vendorItem.getSectioncode() != null) {
                    row.field("SECTIONCODE", "ACPI_SECCO1", vendorItem.getSectioncode());
                }
                if (vendorItem.getSpGlInd() != null) {
                    row.field("SP_GL_IND", "ACPI_UMSKZ", vendorItem.getSpGlInd());
                }
                if (vendorItem.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)vendorItem.getSupcountry());
                }
                if (vendorItem.getSupcountryIso() != null) {
                    row.field("SUPCOUNTRY_ISO", "LANDL_ISO", (ErpType)vendorItem.getSupcountryIso());
                }
                if (vendorItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)vendorItem.getTaxjurcode());
                }
                if (vendorItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)vendorItem.getTaxCode());
                }
                if (vendorItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", vendorItem.getTaxDate());
                }
                if (vendorItem.getVendorNo() != null) {
                    row.field("VENDOR_NO", "LIFNR", (ErpType)vendorItem.getVendorNo());
                }
                if (vendorItem.getWTaxCode() == null) continue;
                row.field("W_TAX_CODE", "ACPI_QSSKZ", vendorItem.getWTaxCode());
            }
            table.end();
        }
        if (this.accountTax != null && this.accountTax.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTTAX", "BAPIACTX09");
            for (TaxItem taxItem : this.accountTax) {
                row = table.row();
                if (taxItem.getAcctKey() != null) {
                    row.field("ACCT_KEY", "KTOSL", taxItem.getAcctKey());
                }
                if (taxItem.getCondKey() != null) {
                    row.field("COND_KEY", "KSCHL", (ErpType)taxItem.getCondKey());
                }
                if (taxItem.getDirectTax() != null) {
                    row.field("DIRECT_TAX", "BAPI_FLG_DIR", (ErpType)taxItem.getDirectTax());
                }
                if (taxItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)taxItem.getGlAccount());
                }
                if (taxItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)taxItem.getItemnoAcc());
                }
                if (taxItem.getItemnoTax() != null) {
                    row.field("ITEMNO_TAX", "TAXPS", (ErpType)taxItem.getItemnoTax());
                }
                if (taxItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)taxItem.getTaxjurcode());
                }
                if (taxItem.getTaxjurcodeDeep() != null) {
                    row.field("TAXJURCODE_DEEP", "ACPI_TXJCD_DEEP", (ErpType)taxItem.getTaxjurcodeDeep());
                }
                if (taxItem.getTaxjurcodeLevel() != null) {
                    row.field("TAXJURCODE_LEVEL", "ACPI_TXJCD_LEVEL", taxItem.getTaxjurcodeLevel());
                }
                if (taxItem.getTaxCalcDtFrom() != null) {
                    row.field("TAX_CALC_DT_FROM", "FOT_TXDAT_FROM", taxItem.getTaxCalcDtFrom());
                }
                if (taxItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)taxItem.getTaxCode());
                }
                if (taxItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", taxItem.getTaxDate());
                }
                if (taxItem.getTaxRate() == null) continue;
                row.field("TAX_RATE", "MSATZ_F05L", (ErpType)taxItem.getTaxRate());
            }
            table.end();
        }
        if (this.currencyAmount != null && this.currencyAmount.iterator().hasNext()) {
            Table table = query.withTable("CURRENCYAMOUNT", "BAPIACCR09");
            for (CurrencyItem currencyItem : this.currencyAmount) {
                row = table.row();
                if (currencyItem.getAmtBase() != null) {
                    row.field("AMT_BASE", "BAPIAMTBASE", (ErpType)currencyItem.getAmtBase());
                }
                if (currencyItem.getAmtBaseLong() != null) {
                    row.field("AMT_BASE_LONG", "BAPIAMTBASE_31", (ErpType)currencyItem.getAmtBaseLong());
                }
                if (currencyItem.getAmtDoccur() != null) {
                    row.field("AMT_DOCCUR", "BAPIDOCCUR", (ErpType)currencyItem.getAmtDoccur());
                }
                if (currencyItem.getAmtDoccurLong() != null) {
                    row.field("AMT_DOCCUR_LONG", "BAPIDOCCUR_31", (ErpType)currencyItem.getAmtDoccurLong());
                }
                if (currencyItem.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)currencyItem.getCurrency());
                }
                if (currencyItem.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)currencyItem.getCurrencyIso());
                }
                if (currencyItem.getCurrType() != null) {
                    row.field("CURR_TYPE", "CURTP", (ErpType)currencyItem.getCurrType());
                }
                if (currencyItem.getDiscAmt() != null) {
                    row.field("DISC_AMT", "ACPI_ACSKT", (ErpType)currencyItem.getDiscAmt());
                }
                if (currencyItem.getDiscAmtLong() != null) {
                    row.field("DISC_AMT_LONG", "ACPI_ACSKT_31", (ErpType)currencyItem.getDiscAmtLong());
                }
                if (currencyItem.getDiscBase() != null) {
                    row.field("DISC_BASE", "ACPI_SKFBT", (ErpType)currencyItem.getDiscBase());
                }
                if (currencyItem.getDiscBaseLong() != null) {
                    row.field("DISC_BASE_LONG", "ACPI_SKFBT_31", (ErpType)currencyItem.getDiscBaseLong());
                }
                if (currencyItem.getExchRate() != null) {
                    row.field("EXCH_RATE", "KURSF", (ErpType)currencyItem.getExchRate());
                }
                if (currencyItem.getExchRateV() != null) {
                    row.field("EXCH_RATE_V", "ACPI_UKURSM", (ErpType)currencyItem.getExchRateV());
                }
                if (currencyItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)currencyItem.getItemnoAcc());
                }
                if (currencyItem.getTaxAmt() != null) {
                    row.field("TAX_AMT", "BAPITAXAMT", (ErpType)currencyItem.getTaxAmt());
                }
                if (currencyItem.getTaxAmtLong() == null) continue;
                row.field("TAX_AMT_LONG", "BAPITAXAMT_31", (ErpType)currencyItem.getTaxAmtLong());
            }
            table.end();
        }
        if (this.criteria != null && this.criteria.iterator().hasNext()) {
            Table table = query.withTable("CRITERIA", "BAPIACKEC9");
            for (AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                row = table.row();
                if (accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter() != null) {
                    row.field("CHARACTER", "ACPI_RKE_CRIGEN", accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter());
                }
                if (accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname());
                }
                if (accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc());
                }
                if (accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getProdNoLong() == null) continue;
                row.field("PROD_NO_LONG", "BAPI_PROD_NO", (ErpType)accountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic.getProdNoLong());
            }
            table.end();
        }
        if (this.valuefield != null && this.valuefield.iterator().hasNext()) {
            Table table = query.withTable("VALUEFIELD", "BAPIACKEV9");
            for (PostingInAccountingCoPaAcctAssignmentValueField postingInAccountingCoPaAcctAssignmentValueField : this.valuefield) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentValueField.getAmtValcom() != null) {
                    row.field("AMT_VALCOM", "BAPIRKEVAL", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getAmtValcom());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getAmtValcomLong() != null) {
                    row.field("AMT_VALCOM_LONG", "BAPIRKEVAL_31", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getAmtValcomLong());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getBaseUom() != null) {
                    row.field("BASE_UOM", "MEINS", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getBaseUom());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getBaseUomIso() != null) {
                    row.field("BASE_UOM_ISO", "MEINS_ISO", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getBaseUomIso());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrency());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrencyIso());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrType() != null) {
                    row.field("CURR_TYPE", "CURTP", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrType());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getQuaValcom() == null) continue;
                row.field("QUA_VALCOM", "QUA_VALCOM", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getQuaValcom());
            }
            table.end();
        }
        if (this.realEstate != null && this.realEstate.iterator().hasNext()) {
            Table table = query.withTable("REALESTATE", "BAPIACRE09");
            for (RealEstateAccountAssignmentData realEstateAccountAssignmentData : this.realEstate) {
                row = table.row();
                if (realEstateAccountAssignmentData.getBuilding() != null) {
                    row.field("BUILDING", "SGENR", (ErpType)realEstateAccountAssignmentData.getBuilding());
                }
                if (realEstateAccountAssignmentData.getBusinessEntity() != null) {
                    row.field("BUSINESS_ENTITY", "SWENR", (ErpType)realEstateAccountAssignmentData.getBusinessEntity());
                }
                if (realEstateAccountAssignmentData.getContractNo() != null) {
                    row.field("CONTRACT_NO", "RANL", (ErpType)realEstateAccountAssignmentData.getContractNo());
                }
                if (realEstateAccountAssignmentData.getCorrItem() != null) {
                    row.field("CORR_ITEM", "SBERI", (ErpType)realEstateAccountAssignmentData.getCorrItem());
                }
                if (realEstateAccountAssignmentData.getFlowType() != null) {
                    row.field("FLOW_TYPE", "SBEWART", (ErpType)realEstateAccountAssignmentData.getFlowType());
                }
                if (realEstateAccountAssignmentData.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)realEstateAccountAssignmentData.getItemnoAcc());
                }
                if (realEstateAccountAssignmentData.getOptionRate() != null) {
                    row.field("OPTION_RATE", "POPTSATZ", (ErpType)realEstateAccountAssignmentData.getOptionRate());
                }
                if (realEstateAccountAssignmentData.getProperty() != null) {
                    row.field("PROPERTY", "SGRNR", (ErpType)realEstateAccountAssignmentData.getProperty());
                }
                if (realEstateAccountAssignmentData.getRefDate() != null) {
                    row.field("REF_DATE", "DABRBEZ", realEstateAccountAssignmentData.getRefDate());
                }
                if (realEstateAccountAssignmentData.getRentalObject() != null) {
                    row.field("RENTAL_OBJECT", "REBDRONRBAPI", (ErpType)realEstateAccountAssignmentData.getRentalObject());
                }
                if (realEstateAccountAssignmentData.getServChargeKey() != null) {
                    row.field("SERV_CHARGE_KEY", "SNKSL", (ErpType)realEstateAccountAssignmentData.getServChargeKey());
                }
                if (realEstateAccountAssignmentData.getSettlementUnit() == null) continue;
                row.field("SETTLEMENT_UNIT", "SEMPSL", (ErpType)realEstateAccountAssignmentData.getSettlementUnit());
            }
            table.end();
        }
        if (this.extension1 != null && this.extension1.iterator().hasNext()) {
            Table table = query.withTable("EXTENSION1", "BAPIACEXTC");
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.extension1) {
                row = table.row();
                if (containerForCustomerExitParameter.getField1() != null) {
                    row.field("FIELD1", "STRNG250", containerForCustomerExitParameter.getField1());
                }
                if (containerForCustomerExitParameter.getField2() != null) {
                    row.field("FIELD2", "STRNG250", containerForCustomerExitParameter.getField2());
                }
                if (containerForCustomerExitParameter.getField3() != null) {
                    row.field("FIELD3", "STRNG250", containerForCustomerExitParameter.getField3());
                }
                if (containerForCustomerExitParameter.getField4() == null) continue;
                row.field("FIELD4", "STRNG250", containerForCustomerExitParameter.getField4());
            }
            table.end();
        }
        if (this.extension2 != null && this.extension2.iterator().hasNext()) {
            Table table = query.withTable("EXTENSION2", "BAPIPAREX");
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extension2) {
                row = table.row();
                if (refStructureForParameterExtensioninExtensionout.getStructure() != null) {
                    row.field("STRUCTURE", "TE_STRUC", (ErpType)refStructureForParameterExtensioninExtensionout.getStructure());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart1() != null) {
                    row.field("VALUEPART1", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart1());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart2() != null) {
                    row.field("VALUEPART2", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart2());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart3() != null) {
                    row.field("VALUEPART3", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart3());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart4() == null) continue;
                row.field("VALUEPART4", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart4());
            }
            table.end();
        }
        if (this.paymentCard != null && this.paymentCard.iterator().hasNext()) {
            Table table = query.withTable("PAYMENTCARD", "BAPIACPC09");
            for (PaymentCardInformation paymentCardInformation : this.paymentCard) {
                row = table.row();
                if (paymentCardInformation.getAuthamount() != null) {
                    row.field("AUTHAMOUNT", "ACPI_CAUTW", (ErpType)paymentCardInformation.getAuthamount());
                }
                if (paymentCardInformation.getAuthamountLong() != null) {
                    row.field("AUTHAMOUNT_LONG", "ACPI_CAUTW_31", (ErpType)paymentCardInformation.getAuthamountLong());
                }
                if (paymentCardInformation.getAuthDate() != null) {
                    row.field("AUTH_DATE", "AUDAT_CC", paymentCardInformation.getAuthDate());
                }
                if (paymentCardInformation.getAuthRefno() != null) {
                    row.field("AUTH_REFNO", "AUTRA", paymentCardInformation.getAuthRefno());
                }
                if (paymentCardInformation.getAuthTime() != null) {
                    row.field("AUTH_TIME", "AUTIM", paymentCardInformation.getAuthTime());
                }
                if (paymentCardInformation.getCctyp() != null) {
                    row.field("CCTYP", "ACPI_CCTYP", paymentCardInformation.getCctyp());
                }
                if (paymentCardInformation.getCcAutthNo() != null) {
                    row.field("CC_AUTTH_NO", "AUNUM", paymentCardInformation.getCcAutthNo());
                }
                if (paymentCardInformation.getCcGlaccount() != null) {
                    row.field("CC_GLACCOUNT", "ACPI_CCACT", (ErpType)paymentCardInformation.getCcGlaccount());
                }
                if (paymentCardInformation.getCcName() != null) {
                    row.field("CC_NAME", "CCNAME", paymentCardInformation.getCcName());
                }
                if (paymentCardInformation.getCcNumber() != null) {
                    row.field("CC_NUMBER", "CCNUM", (ErpType)paymentCardInformation.getCcNumber());
                }
                if (paymentCardInformation.getCcSeqNo() != null) {
                    row.field("CC_SEQ_NO", "CCFOL", paymentCardInformation.getCcSeqNo());
                }
                if (paymentCardInformation.getCcType() != null) {
                    row.field("CC_TYPE", "CCINS", (ErpType)paymentCardInformation.getCcType());
                }
                if (paymentCardInformation.getCcValidF() != null) {
                    row.field("CC_VALID_F", "DATAB_CC", paymentCardInformation.getCcValidF());
                }
                if (paymentCardInformation.getCcValidT() != null) {
                    row.field("CC_VALID_T", "DATBI_CC", paymentCardInformation.getCcValidT());
                }
                if (paymentCardInformation.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)paymentCardInformation.getCurrency());
                }
                if (paymentCardInformation.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)paymentCardInformation.getCurrencyIso());
                }
                if (paymentCardInformation.getDataorigin() != null) {
                    row.field("DATAORIGIN", "CSOUR", (ErpType)paymentCardInformation.getDataorigin());
                }
                if (paymentCardInformation.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)paymentCardInformation.getItemnoAcc());
                }
                if (paymentCardInformation.getMerchidcl() != null) {
                    row.field("MERCHIDCL", "MERCH", (ErpType)paymentCardInformation.getMerchidcl());
                }
                if (paymentCardInformation.getPointOfReceipt() != null) {
                    row.field("POINT_OF_RECEIPT", "LOCID_CC", (ErpType)paymentCardInformation.getPointOfReceipt());
                }
                if (paymentCardInformation.getTerminal() == null) continue;
                row.field("TERMINAL", "TRMID", paymentCardInformation.getTerminal());
            }
            table.end();
        }
        if (this.contractItem != null && this.contractItem.iterator().hasNext()) {
            Table table = query.withTable("CONTRACTITEM", "BAPIACCAIT");
            for (AddContractAccountsRecAndPayableDocumentLineItem addContractAccountsRecAndPayableDocumentLineItem : this.contractItem) {
                row = table.row();
                if (addContractAccountsRecAndPayableDocumentLineItem.getAgreementGuid() != null) {
                    row.field("AGREEMENT_GUID", "SYSUUID_X", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getAgreementGuid());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getBudgetPeriod());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getBusScenario() != null) {
                    row.field("BUS_SCENARIO", "ACPI_IAOM_BS_ID", addContractAccountsRecAndPayableDocumentLineItem.getBusScenario());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getCmmtItem() != null) {
                    row.field("CMMT_ITEM", "FIPOS", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getCmmtItem());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getCmmtItemLong() != null) {
                    row.field("CMMT_ITEM_LONG", "FM_FIPEX", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getCmmtItemLong());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getContAcct() != null) {
                    row.field("CONT_ACCT", "ACPI_CONT_ACCT", addContractAccountsRecAndPayableDocumentLineItem.getContAcct());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getExtObjectId() != null) {
                    row.field("EXT_OBJECT_ID", "ACPI_IAOM_EO_ID", addContractAccountsRecAndPayableDocumentLineItem.getExtObjectId());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFmArea() != null) {
                    row.field("FM_AREA", "FIKRS", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFmArea());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFuncArea() != null) {
                    row.field("FUNC_AREA", "FKBER_SHORT", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFuncArea());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFuncAreaLong() != null) {
                    row.field("FUNC_AREA_LONG", "FKBER", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFuncAreaLong());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFund());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFundsCtr() != null) {
                    row.field("FUNDS_CTR", "FISTL", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFundsCtr());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getGrantNbr());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getItemnoAcc());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getMainTrans() != null) {
                    row.field("MAIN_TRANS", "ACPI_MAIN_TRANS", addContractAccountsRecAndPayableDocumentLineItem.getMainTrans());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getReferenceNo() != null) {
                    row.field("REFERENCE_NO", "ACPI_CA_DOC_REF", addContractAccountsRecAndPayableDocumentLineItem.getReferenceNo());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getSubTrans() != null) {
                    row.field("SUB_TRANS", "ACPI_SUB_TRANS", addContractAccountsRecAndPayableDocumentLineItem.getSubTrans());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getVtref() != null) {
                    row.field("VTREF", "ACPI_CONT_REF", addContractAccountsRecAndPayableDocumentLineItem.getVtref());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getVtrefGuid() == null) continue;
                row.field("VTREF_GUID", "SYSUUID_X", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getVtrefGuid());
            }
            table.end();
        }
        if (this.withholdingTax != null && this.withholdingTax.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTWT", "BAPIACWT09");
            for (WithholdingTaxInformation withholdingTaxInformation : this.withholdingTax) {
                row = table.row();
                if (withholdingTaxInformation.getAwhAmtL2() != null) {
                    row.field("AWH_AMT_L2", "BAPIWT_AWT2", (ErpType)withholdingTaxInformation.getAwhAmtL2());
                }
                if (withholdingTaxInformation.getAwhAmtL2Long() != null) {
                    row.field("AWH_AMT_L2_LONG", "BAPIWT_AWT2_31", (ErpType)withholdingTaxInformation.getAwhAmtL2Long());
                }
                if (withholdingTaxInformation.getAwhAmtL3() != null) {
                    row.field("AWH_AMT_L3", "BAPIWT_AWT3", (ErpType)withholdingTaxInformation.getAwhAmtL3());
                }
                if (withholdingTaxInformation.getAwhAmtL3Long() != null) {
                    row.field("AWH_AMT_L3_LONG", "BAPIWT_AWT3_31", (ErpType)withholdingTaxInformation.getAwhAmtL3Long());
                }
                if (withholdingTaxInformation.getAwhAmtLc() != null) {
                    row.field("AWH_AMT_LC", "BAPIWT_AWT", (ErpType)withholdingTaxInformation.getAwhAmtLc());
                }
                if (withholdingTaxInformation.getAwhAmtLcLong() != null) {
                    row.field("AWH_AMT_LC_LONG", "BAPIWT_AWT_31", (ErpType)withholdingTaxInformation.getAwhAmtLcLong());
                }
                if (withholdingTaxInformation.getAwhAmtTc() != null) {
                    row.field("AWH_AMT_TC", "BAPIWT_AWT1", (ErpType)withholdingTaxInformation.getAwhAmtTc());
                }
                if (withholdingTaxInformation.getAwhAmtTcLong() != null) {
                    row.field("AWH_AMT_TC_LONG", "BAPIWT_AWT1_31", (ErpType)withholdingTaxInformation.getAwhAmtTcLong());
                }
                if (withholdingTaxInformation.getBasAmtInd() != null) {
                    row.field("BAS_AMT_IND", "WT_BASMAN", (ErpType)withholdingTaxInformation.getBasAmtInd());
                }
                if (withholdingTaxInformation.getBasAmtL2() != null) {
                    row.field("BAS_AMT_L2", "BAPIWT_BS2", (ErpType)withholdingTaxInformation.getBasAmtL2());
                }
                if (withholdingTaxInformation.getBasAmtL2Long() != null) {
                    row.field("BAS_AMT_L2_LONG", "BAPIWT_BS2_31", (ErpType)withholdingTaxInformation.getBasAmtL2Long());
                }
                if (withholdingTaxInformation.getBasAmtL3() != null) {
                    row.field("BAS_AMT_L3", "BAPIWT_BS3", (ErpType)withholdingTaxInformation.getBasAmtL3());
                }
                if (withholdingTaxInformation.getBasAmtL3Long() != null) {
                    row.field("BAS_AMT_L3_LONG", "BAPIWT_BS3_31", (ErpType)withholdingTaxInformation.getBasAmtL3Long());
                }
                if (withholdingTaxInformation.getBasAmtLc() != null) {
                    row.field("BAS_AMT_LC", "BAPIWT_BS", (ErpType)withholdingTaxInformation.getBasAmtLc());
                }
                if (withholdingTaxInformation.getBasAmtLcLong() != null) {
                    row.field("BAS_AMT_LC_LONG", "BAPIWT_BS_31", (ErpType)withholdingTaxInformation.getBasAmtLcLong());
                }
                if (withholdingTaxInformation.getBasAmtTc() != null) {
                    row.field("BAS_AMT_TC", "BAPIWT_BS1", (ErpType)withholdingTaxInformation.getBasAmtTc());
                }
                if (withholdingTaxInformation.getBasAmtTcLong() != null) {
                    row.field("BAS_AMT_TC_LONG", "BAPIWT_BS1_31", (ErpType)withholdingTaxInformation.getBasAmtTcLong());
                }
                if (withholdingTaxInformation.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)withholdingTaxInformation.getItemnoAcc());
                }
                if (withholdingTaxInformation.getManAmtInd() != null) {
                    row.field("MAN_AMT_IND", "WT_AMNMAN", (ErpType)withholdingTaxInformation.getManAmtInd());
                }
                if (withholdingTaxInformation.getManAmtL2() != null) {
                    row.field("MAN_AMT_L2", "BAPIWT_QBUIH2", (ErpType)withholdingTaxInformation.getManAmtL2());
                }
                if (withholdingTaxInformation.getManAmtL2Long() != null) {
                    row.field("MAN_AMT_L2_LONG", "BAPIWT_QBUIH2_31", (ErpType)withholdingTaxInformation.getManAmtL2Long());
                }
                if (withholdingTaxInformation.getManAmtL3() != null) {
                    row.field("MAN_AMT_L3", "BAPIWT_QBUIH3", (ErpType)withholdingTaxInformation.getManAmtL3());
                }
                if (withholdingTaxInformation.getManAmtL3Long() != null) {
                    row.field("MAN_AMT_L3_LONG", "BAPIWT_QBUIH3_31", (ErpType)withholdingTaxInformation.getManAmtL3Long());
                }
                if (withholdingTaxInformation.getManAmtLc() != null) {
                    row.field("MAN_AMT_LC", "BAPIWT_QBUIHH", (ErpType)withholdingTaxInformation.getManAmtLc());
                }
                if (withholdingTaxInformation.getManAmtLcLong() != null) {
                    row.field("MAN_AMT_LC_LONG", "BAPIWT_QBUIHH_31", (ErpType)withholdingTaxInformation.getManAmtLcLong());
                }
                if (withholdingTaxInformation.getManAmtTc() != null) {
                    row.field("MAN_AMT_TC", "BAPIWT_QBUIHB", (ErpType)withholdingTaxInformation.getManAmtTc());
                }
                if (withholdingTaxInformation.getManAmtTcLong() != null) {
                    row.field("MAN_AMT_TC_LONG", "BAPIWT_QBUIHB_31", (ErpType)withholdingTaxInformation.getManAmtTcLong());
                }
                if (withholdingTaxInformation.getWtCode() != null) {
                    row.field("WT_CODE", "WT_WITHCD", (ErpType)withholdingTaxInformation.getWtCode());
                }
                if (withholdingTaxInformation.getWtType() == null) continue;
                row.field("WT_TYPE", "WITHT", (ErpType)withholdingTaxInformation.getWtType());
            }
            table.end();
        }
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction accountGl(GlAccountItem ... items) {
        this.accountGl = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction accountReceivable(CustomerItem ... items) {
        this.accountReceivable = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction accountPayable(VendorItem ... items) {
        this.accountPayable = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction accountTax(TaxItem ... items) {
        this.accountTax = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction currencyAmount(CurrencyItem ... items) {
        this.currencyAmount = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction criteria(AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic ... items) {
        this.criteria = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction valuefield(PostingInAccountingCoPaAcctAssignmentValueField ... items) {
        this.valuefield = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction realEstate(RealEstateAccountAssignmentData ... items) {
        this.realEstate = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction extension1(ContainerForCustomerExitParameter ... items) {
        this.extension1 = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction extension2(RefStructureForParameterExtensioninExtensionout ... items) {
        this.extension2 = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction paymentCard(PaymentCardInformation ... items) {
        this.paymentCard = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction contractItem(AddContractAccountsRecAndPayableDocumentLineItem ... items) {
        this.contractItem = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public AcctngDocumentCheckFunction withholdingTax(WithholdingTaxInformation ... items) {
        this.withholdingTax = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultAcctngDocumentCheckFunction(documentHeader=" + this.documentHeader + ", customerCpd=" + this.customerCpd + ", contractHeader=" + this.contractHeader + ", accountGl=" + this.accountGl + ", accountReceivable=" + this.accountReceivable + ", accountPayable=" + this.accountPayable + ", accountTax=" + this.accountTax + ", currencyAmount=" + this.currencyAmount + ", criteria=" + this.criteria + ", valuefield=" + this.valuefield + ", realEstate=" + this.realEstate + ", extension1=" + this.extension1 + ", extension2=" + this.extension2 + ", paymentCard=" + this.paymentCard + ", contractItem=" + this.contractItem + ", withholdingTax=" + this.withholdingTax + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAcctngDocumentCheckFunction)) {
            return false;
        }
        DefaultAcctngDocumentCheckFunction other = (DefaultAcctngDocumentCheckFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Header this$documentHeader = this.documentHeader;
        Header other$documentHeader = other.documentHeader;
        if (this$documentHeader == null ? other$documentHeader != null : !((Object)this$documentHeader).equals(other$documentHeader)) {
            return false;
        }
        PostingInAccountingPartnerBillingDoc this$customerCpd = this.customerCpd;
        PostingInAccountingPartnerBillingDoc other$customerCpd = other.customerCpd;
        if (this$customerCpd == null ? other$customerCpd != null : !((Object)this$customerCpd).equals(other$customerCpd)) {
            return false;
        }
        AddContractAccountsRecievableAndPayableHeaderLine this$contractHeader = this.contractHeader;
        AddContractAccountsRecievableAndPayableHeaderLine other$contractHeader = other.contractHeader;
        if (this$contractHeader == null ? other$contractHeader != null : !((Object)this$contractHeader).equals(other$contractHeader)) {
            return false;
        }
        Iterable<GlAccountItem> this$accountGl = this.accountGl;
        Iterable<GlAccountItem> other$accountGl = other.accountGl;
        if (this$accountGl == null ? other$accountGl != null : !this$accountGl.equals(other$accountGl)) {
            return false;
        }
        Iterable<CustomerItem> this$accountReceivable = this.accountReceivable;
        Iterable<CustomerItem> other$accountReceivable = other.accountReceivable;
        if (this$accountReceivable == null ? other$accountReceivable != null : !this$accountReceivable.equals(other$accountReceivable)) {
            return false;
        }
        Iterable<VendorItem> this$accountPayable = this.accountPayable;
        Iterable<VendorItem> other$accountPayable = other.accountPayable;
        if (this$accountPayable == null ? other$accountPayable != null : !this$accountPayable.equals(other$accountPayable)) {
            return false;
        }
        Iterable<TaxItem> this$accountTax = this.accountTax;
        Iterable<TaxItem> other$accountTax = other.accountTax;
        if (this$accountTax == null ? other$accountTax != null : !this$accountTax.equals(other$accountTax)) {
            return false;
        }
        Iterable<CurrencyItem> this$currencyAmount = this.currencyAmount;
        Iterable<CurrencyItem> other$currencyAmount = other.currencyAmount;
        if (this$currencyAmount == null ? other$currencyAmount != null : !this$currencyAmount.equals(other$currencyAmount)) {
            return false;
        }
        Iterable<AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic> this$criteria = this.criteria;
        Iterable<AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic> other$criteria = other.criteria;
        if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> this$valuefield = this.valuefield;
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> other$valuefield = other.valuefield;
        if (this$valuefield == null ? other$valuefield != null : !this$valuefield.equals(other$valuefield)) {
            return false;
        }
        Iterable<RealEstateAccountAssignmentData> this$realEstate = this.realEstate;
        Iterable<RealEstateAccountAssignmentData> other$realEstate = other.realEstate;
        if (this$realEstate == null ? other$realEstate != null : !this$realEstate.equals(other$realEstate)) {
            return false;
        }
        Iterable<ContainerForCustomerExitParameter> this$extension1 = this.extension1;
        Iterable<ContainerForCustomerExitParameter> other$extension1 = other.extension1;
        if (this$extension1 == null ? other$extension1 != null : !this$extension1.equals(other$extension1)) {
            return false;
        }
        Iterable<RefStructureForParameterExtensioninExtensionout> this$extension2 = this.extension2;
        Iterable<RefStructureForParameterExtensioninExtensionout> other$extension2 = other.extension2;
        if (this$extension2 == null ? other$extension2 != null : !this$extension2.equals(other$extension2)) {
            return false;
        }
        Iterable<PaymentCardInformation> this$paymentCard = this.paymentCard;
        Iterable<PaymentCardInformation> other$paymentCard = other.paymentCard;
        if (this$paymentCard == null ? other$paymentCard != null : !this$paymentCard.equals(other$paymentCard)) {
            return false;
        }
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> this$contractItem = this.contractItem;
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> other$contractItem = other.contractItem;
        if (this$contractItem == null ? other$contractItem != null : !this$contractItem.equals(other$contractItem)) {
            return false;
        }
        Iterable<WithholdingTaxInformation> this$withholdingTax = this.withholdingTax;
        Iterable<WithholdingTaxInformation> other$withholdingTax = other.withholdingTax;
        return !(this$withholdingTax == null ? other$withholdingTax != null : !this$withholdingTax.equals(other$withholdingTax));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultAcctngDocumentCheckFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Header $documentHeader = this.documentHeader;
        result = result * 59 + ($documentHeader == null ? 43 : ((Object)$documentHeader).hashCode());
        PostingInAccountingPartnerBillingDoc $customerCpd = this.customerCpd;
        result = result * 59 + ($customerCpd == null ? 43 : ((Object)$customerCpd).hashCode());
        AddContractAccountsRecievableAndPayableHeaderLine $contractHeader = this.contractHeader;
        result = result * 59 + ($contractHeader == null ? 43 : ((Object)$contractHeader).hashCode());
        Iterable<GlAccountItem> $accountGl = this.accountGl;
        result = result * 59 + ($accountGl == null ? 43 : $accountGl.hashCode());
        Iterable<CustomerItem> $accountReceivable = this.accountReceivable;
        result = result * 59 + ($accountReceivable == null ? 43 : $accountReceivable.hashCode());
        Iterable<VendorItem> $accountPayable = this.accountPayable;
        result = result * 59 + ($accountPayable == null ? 43 : $accountPayable.hashCode());
        Iterable<TaxItem> $accountTax = this.accountTax;
        result = result * 59 + ($accountTax == null ? 43 : $accountTax.hashCode());
        Iterable<CurrencyItem> $currencyAmount = this.currencyAmount;
        result = result * 59 + ($currencyAmount == null ? 43 : $currencyAmount.hashCode());
        Iterable<AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic> $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> $valuefield = this.valuefield;
        result = result * 59 + ($valuefield == null ? 43 : $valuefield.hashCode());
        Iterable<RealEstateAccountAssignmentData> $realEstate = this.realEstate;
        result = result * 59 + ($realEstate == null ? 43 : $realEstate.hashCode());
        Iterable<ContainerForCustomerExitParameter> $extension1 = this.extension1;
        result = result * 59 + ($extension1 == null ? 43 : $extension1.hashCode());
        Iterable<RefStructureForParameterExtensioninExtensionout> $extension2 = this.extension2;
        result = result * 59 + ($extension2 == null ? 43 : $extension2.hashCode());
        Iterable<PaymentCardInformation> $paymentCard = this.paymentCard;
        result = result * 59 + ($paymentCard == null ? 43 : $paymentCard.hashCode());
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> $contractItem = this.contractItem;
        result = result * 59 + ($contractItem == null ? 43 : $contractItem.hashCode());
        Iterable<WithholdingTaxInformation> $withholdingTax = this.withholdingTax;
        result = result * 59 + ($withholdingTax == null ? 43 : $withholdingTax.hashCode());
        return result;
    }

    public DefaultAcctngDocumentCheckFunction(Header documentHeader) {
        this.documentHeader = documentHeader;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction customerCpd(PostingInAccountingPartnerBillingDoc customerCpd) {
        this.customerCpd = customerCpd;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction contractHeader(AddContractAccountsRecievableAndPayableHeaderLine contractHeader) {
        this.contractHeader = contractHeader;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction accountGl(@Nonnull Iterable<GlAccountItem> accountGl) {
        if (accountGl == null) {
            throw new NullPointerException("accountGl is marked @NonNull but is null");
        }
        this.accountGl = accountGl;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction accountReceivable(@Nonnull Iterable<CustomerItem> accountReceivable) {
        if (accountReceivable == null) {
            throw new NullPointerException("accountReceivable is marked @NonNull but is null");
        }
        this.accountReceivable = accountReceivable;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction accountPayable(@Nonnull Iterable<VendorItem> accountPayable) {
        if (accountPayable == null) {
            throw new NullPointerException("accountPayable is marked @NonNull but is null");
        }
        this.accountPayable = accountPayable;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction accountTax(@Nonnull Iterable<TaxItem> accountTax) {
        if (accountTax == null) {
            throw new NullPointerException("accountTax is marked @NonNull but is null");
        }
        this.accountTax = accountTax;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction currencyAmount(@Nonnull Iterable<CurrencyItem> currencyAmount) {
        if (currencyAmount == null) {
            throw new NullPointerException("currencyAmount is marked @NonNull but is null");
        }
        this.currencyAmount = currencyAmount;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction criteria(@Nonnull Iterable<AccountingDocumentCheckPostingInAccountingCoPaAcctAssignmentCharacteristic> criteria) {
        if (criteria == null) {
            throw new NullPointerException("criteria is marked @NonNull but is null");
        }
        this.criteria = criteria;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction valuefield(@Nonnull Iterable<PostingInAccountingCoPaAcctAssignmentValueField> valuefield) {
        if (valuefield == null) {
            throw new NullPointerException("valuefield is marked @NonNull but is null");
        }
        this.valuefield = valuefield;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction realEstate(@Nonnull Iterable<RealEstateAccountAssignmentData> realEstate) {
        if (realEstate == null) {
            throw new NullPointerException("realEstate is marked @NonNull but is null");
        }
        this.realEstate = realEstate;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction extension1(@Nonnull Iterable<ContainerForCustomerExitParameter> extension1) {
        if (extension1 == null) {
            throw new NullPointerException("extension1 is marked @NonNull but is null");
        }
        this.extension1 = extension1;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction extension2(@Nonnull Iterable<RefStructureForParameterExtensioninExtensionout> extension2) {
        if (extension2 == null) {
            throw new NullPointerException("extension2 is marked @NonNull but is null");
        }
        this.extension2 = extension2;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction paymentCard(@Nonnull Iterable<PaymentCardInformation> paymentCard) {
        if (paymentCard == null) {
            throw new NullPointerException("paymentCard is marked @NonNull but is null");
        }
        this.paymentCard = paymentCard;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction contractItem(@Nonnull Iterable<AddContractAccountsRecAndPayableDocumentLineItem> contractItem) {
        if (contractItem == null) {
            throw new NullPointerException("contractItem is marked @NonNull but is null");
        }
        this.contractItem = contractItem;
        return this;
    }

    @Override
    public DefaultAcctngDocumentCheckFunction withholdingTax(@Nonnull Iterable<WithholdingTaxInformation> withholdingTax) {
        if (withholdingTax == null) {
            throw new NullPointerException("withholdingTax is marked @NonNull but is null");
        }
        this.withholdingTax = withholdingTax;
        return this;
    }
}

