/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngManCostAllocPostFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngManCostAllocPostFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultAcctngManCostAllocPostFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ContainerForCustomerExitParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.DocumentHeaderPostCostsRevenuesActualPostings;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.LineItemsManualCostAllocationActualPosting;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultAcctngManCostAllocPostFunction
implements AcctngManCostAllocPostFunction {
    private final DocumentHeaderPostCostsRevenuesActualPostings docHeader;
    private ErpBoolean ignoreWarnings = null;
    @Nonnull
    private final Iterable<LineItemsManualCostAllocationActualPosting> docItems;
    @Nonnull
    private Iterable<ContainerForCustomerExitParameter> customerFields = Lists.newArrayList();

    @Override
    @Nonnull
    public AcctngManCostAllocPostFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultAcctngManCostAllocPostFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public AcctngManCostAllocPostFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        this.docHeader.validate();
        for (LineItemsManualCostAllocationActualPosting lineItemsManualCostAllocationActualPosting : this.docItems) {
            lineItemsManualCostAllocationActualPosting.validate();
        }
        if (this.customerFields != null) {
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                containerForCustomerExitParameter.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_ACC_MANUAL_ALLOC_POST");
        if (this.ignoreWarnings != null) {
            query.withExporting("IGNORE_WARNINGS", "BAPIIGNWAR", (ErpType)this.ignoreWarnings);
        }
        ParameterFields parameterFields = query.withExportingFields("DOC_HEADER", "BAPIDOCHDRU12P");
        if (this.docHeader.getAccPrinciple() != null) {
            parameterFields.field("ACC_PRINCIPLE", "ACCOUNTING_PRINCIPLE", (ErpType)this.docHeader.getAccPrinciple());
        }
        if (this.docHeader.getCoArea() != null) {
            parameterFields.field("CO_AREA", "KOKRS", (ErpType)this.docHeader.getCoArea());
        }
        if (this.docHeader.getDocdate() != null) {
            parameterFields.field("DOCDATE", "CO_BLDAT", this.docHeader.getDocdate());
        }
        if (this.docHeader.getDocHdrTx() != null) {
            parameterFields.field("DOC_HDR_TX", "CO_BLTXT", this.docHeader.getDocHdrTx());
        }
        if (this.docHeader.getDocNo() != null) {
            parameterFields.field("DOC_NO", "CO_BELNR", (ErpType)this.docHeader.getDocNo());
        }
        if (this.docHeader.getDocType() != null) {
            parameterFields.field("DOC_TYPE", "BLART", (ErpType)this.docHeader.getDocType());
        }
        if (this.docHeader.getLedgerGroup() != null) {
            parameterFields.field("LEDGER_GROUP", "LEDGER_GROUP", (ErpType)this.docHeader.getLedgerGroup());
        }
        if (this.docHeader.getObjKey() != null) {
            parameterFields.field("OBJ_KEY", "AWKEY", (ErpType)this.docHeader.getObjKey());
        }
        if (this.docHeader.getObjSys() != null) {
            parameterFields.field("OBJ_SYS", "AWSYS", (ErpType)this.docHeader.getObjSys());
        }
        if (this.docHeader.getObjType() != null) {
            parameterFields.field("OBJ_TYPE", "AWTYP", (ErpType)this.docHeader.getObjType());
        }
        if (this.docHeader.getPeriod() != null) {
            parameterFields.field("PERIOD", "CO_PERIO", (ErpType)this.docHeader.getPeriod());
        }
        if (this.docHeader.getPostgdate() != null) {
            parameterFields.field("POSTGDATE", "CO_BUDAT", this.docHeader.getPostgdate());
        }
        if (this.docHeader.getTransCurr() != null) {
            parameterFields.field("TRANS_CURR", "TWAER", (ErpType)this.docHeader.getTransCurr());
        }
        if (this.docHeader.getTransCurrIso() != null) {
            parameterFields.field("TRANS_CURR_ISO", "ISOCD", (ErpType)this.docHeader.getTransCurrIso());
        }
        if (this.docHeader.getUsername() != null) {
            parameterFields.field("USERNAME", "USNAM", (ErpType)this.docHeader.getUsername());
        }
        if (this.docHeader.getValuedate() != null) {
            parameterFields.field("VALUEDATE", "CO_WSDAT", this.docHeader.getValuedate());
        }
        if (this.docHeader.getVariant() != null) {
            parameterFields.field("VARIANT", "CO_VARNR", (ErpType)this.docHeader.getVariant());
        }
        parameterFields.end();
        if (this.docItems.iterator().hasNext()) {
            Table table = query.withTable("DOC_ITEMS", "BAPIMAITM");
            for (LineItemsManualCostAllocationActualPosting lineItemsManualCostAllocationActualPosting : this.docItems) {
                row = table.row();
                if (lineItemsManualCostAllocationActualPosting.getCostElem() != null) {
                    row.field("COST_ELEM", "KSTAR", (ErpType)lineItemsManualCostAllocationActualPosting.getCostElem());
                }
                if (lineItemsManualCostAllocationActualPosting.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)lineItemsManualCostAllocationActualPosting.getItemnoAcc());
                }
                if (lineItemsManualCostAllocationActualPosting.getPersonNo() != null) {
                    row.field("PERSON_NO", "PERNR_D", (ErpType)lineItemsManualCostAllocationActualPosting.getPersonNo());
                }
                if (lineItemsManualCostAllocationActualPosting.getPostquun() != null) {
                    row.field("POSTQUUN", "MEINB", (ErpType)lineItemsManualCostAllocationActualPosting.getPostquun());
                }
                if (lineItemsManualCostAllocationActualPosting.getPostquunIso() != null) {
                    row.field("POSTQUUN_ISO", "ISOCD_UNIT", (ErpType)lineItemsManualCostAllocationActualPosting.getPostquunIso());
                }
                if (lineItemsManualCostAllocationActualPosting.getQuantity() != null) {
                    row.field("QUANTITY", "MBGXXX", (ErpType)lineItemsManualCostAllocationActualPosting.getQuantity());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecbusproc() != null) {
                    row.field("RECBUSPROC", "EPRZNR", (ErpType)lineItemsManualCostAllocationActualPosting.getRecbusproc());
                }
                if (lineItemsManualCostAllocationActualPosting.getReccostobj() != null) {
                    row.field("RECCOSTOBJ", "EKSTR", (ErpType)lineItemsManualCostAllocationActualPosting.getReccostobj());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecitem() != null) {
                    row.field("RECITEM", "EKDPO", (ErpType)lineItemsManualCostAllocationActualPosting.getRecitem());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecoperatn() != null) {
                    row.field("RECOPERATN", "EVORG", (ErpType)lineItemsManualCostAllocationActualPosting.getRecoperatn());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecsaleord() != null) {
                    row.field("RECSALEORD", "EKDAU", (ErpType)lineItemsManualCostAllocationActualPosting.getRecsaleord());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecBudgetPeriod() != null) {
                    row.field("REC_BUDGET_PERIOD", "FM_EBUDGET_PERIOD", (ErpType)lineItemsManualCostAllocationActualPosting.getRecBudgetPeriod());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecCctr() != null) {
                    row.field("REC_CCTR", "EKOSTL", (ErpType)lineItemsManualCostAllocationActualPosting.getRecCctr());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecFunction() != null) {
                    row.field("REC_FUNCTION", "EFKTBER", (ErpType)lineItemsManualCostAllocationActualPosting.getRecFunction());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecFund() != null) {
                    row.field("REC_FUND", "FM_EFONDS", (ErpType)lineItemsManualCostAllocationActualPosting.getRecFund());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecFundLong() != null) {
                    row.field("REC_FUND_LONG", "FM_RGEBER_LONG", lineItemsManualCostAllocationActualPosting.getRecFundLong());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecGrant() != null) {
                    row.field("REC_GRANT", "GM_GRANT_RECEIVER", (ErpType)lineItemsManualCostAllocationActualPosting.getRecGrant());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecNetwrk() != null) {
                    row.field("REC_NETWRK", "ENPLN", (ErpType)lineItemsManualCostAllocationActualPosting.getRecNetwrk());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecOrder() != null) {
                    row.field("REC_ORDER", "EAUFNR", (ErpType)lineItemsManualCostAllocationActualPosting.getRecOrder());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecRsrce() != null) {
                    row.field("REC_RSRCE", "ERSRCE", (ErpType)lineItemsManualCostAllocationActualPosting.getRecRsrce());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecWbsEl() != null) {
                    row.field("REC_WBS_EL", "E_PS_POSID", (ErpType)lineItemsManualCostAllocationActualPosting.getRecWbsEl());
                }
                if (lineItemsManualCostAllocationActualPosting.getRecWorkItm() != null) {
                    row.field("REC_WORK_ITM", "EWORKITM", (ErpType)lineItemsManualCostAllocationActualPosting.getRecWorkItm());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreBuilding() != null) {
                    row.field("RRE_BUILDING", "ESGENR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreBuilding());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreBusEnt() != null) {
                    row.field("RRE_BUS_ENT", "ESWENR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreBusEnt());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreCompCode() != null) {
                    row.field("RRE_COMP_CODE", "EBUKRS", (ErpType)lineItemsManualCostAllocationActualPosting.getRreCompCode());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreConNo() != null) {
                    row.field("RRE_CON_NO", "REECNNR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreConNo());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreIncExp() != null) {
                    row.field("RRE_INC_EXP", "ESNKSL", (ErpType)lineItemsManualCostAllocationActualPosting.getRreIncExp());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreLease() != null) {
                    row.field("RRE_LEASE", "ESMIVE", (ErpType)lineItemsManualCostAllocationActualPosting.getRreLease());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreMgmtCon() != null) {
                    row.field("RRE_MGMT_CON", "VVESVWNR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreMgmtCon());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreProperty() != null) {
                    row.field("RRE_PROPERTY", "ESGRNR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreProperty());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreRefDate() != null) {
                    row.field("RRE_REF_DATE", "EDABRBEZ", lineItemsManualCostAllocationActualPosting.getRreRefDate());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreRentUnit() != null) {
                    row.field("RRE_RENT_UNIT", "ESMENR", (ErpType)lineItemsManualCostAllocationActualPosting.getRreRentUnit());
                }
                if (lineItemsManualCostAllocationActualPosting.getRreSettUnit() != null) {
                    row.field("RRE_SETT_UNIT", "ESEMPSL", (ErpType)lineItemsManualCostAllocationActualPosting.getRreSettUnit());
                }
                if (lineItemsManualCostAllocationActualPosting.getSegText() != null) {
                    row.field("SEG_TEXT", "CO_SGTXT", lineItemsManualCostAllocationActualPosting.getSegText());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenbusproc() != null) {
                    row.field("SENBUSPROC", "SPRZNR", (ErpType)lineItemsManualCostAllocationActualPosting.getSenbusproc());
                }
                if (lineItemsManualCostAllocationActualPosting.getSencostobj() != null) {
                    row.field("SENCOSTOBJ", "SKSTRG", (ErpType)lineItemsManualCostAllocationActualPosting.getSencostobj());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendBudgetPeriod() != null) {
                    row.field("SEND_BUDGET_PERIOD", "FM_SBUDGET_PERIOD", (ErpType)lineItemsManualCostAllocationActualPosting.getSendBudgetPeriod());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendCctr() != null) {
                    row.field("SEND_CCTR", "SKOSTL", (ErpType)lineItemsManualCostAllocationActualPosting.getSendCctr());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendFunction() != null) {
                    row.field("SEND_FUNCTION", "SFKTBER", (ErpType)lineItemsManualCostAllocationActualPosting.getSendFunction());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendFund() != null) {
                    row.field("SEND_FUND", "FM_SFONDS", (ErpType)lineItemsManualCostAllocationActualPosting.getSendFund());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendFundLong() != null) {
                    row.field("SEND_FUND_LONG", "FM_SGEBER_LONG", lineItemsManualCostAllocationActualPosting.getSendFundLong());
                }
                if (lineItemsManualCostAllocationActualPosting.getSendGrant() != null) {
                    row.field("SEND_GRANT", "GM_GRANT_SENDER", (ErpType)lineItemsManualCostAllocationActualPosting.getSendGrant());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenitem() != null) {
                    row.field("SENITEM", "SKDPO", (ErpType)lineItemsManualCostAllocationActualPosting.getSenitem());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenoperatn() != null) {
                    row.field("SENOPERATN", "SVORG", (ErpType)lineItemsManualCostAllocationActualPosting.getSenoperatn());
                }
                if (lineItemsManualCostAllocationActualPosting.getSensaleord() != null) {
                    row.field("SENSALEORD", "SKDAU", (ErpType)lineItemsManualCostAllocationActualPosting.getSensaleord());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenNetwrk() != null) {
                    row.field("SEN_NETWRK", "SNPLN", (ErpType)lineItemsManualCostAllocationActualPosting.getSenNetwrk());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenOrder() != null) {
                    row.field("SEN_ORDER", "SAUFNR", (ErpType)lineItemsManualCostAllocationActualPosting.getSenOrder());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenRsrce() != null) {
                    row.field("SEN_RSRCE", "SRSRCE", (ErpType)lineItemsManualCostAllocationActualPosting.getSenRsrce());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenWbsEl() != null) {
                    row.field("SEN_WBS_EL", "S_PS_POSID", (ErpType)lineItemsManualCostAllocationActualPosting.getSenWbsEl());
                }
                if (lineItemsManualCostAllocationActualPosting.getSenWorkItm() != null) {
                    row.field("SEN_WORK_ITM", "SWORKITM", (ErpType)lineItemsManualCostAllocationActualPosting.getSenWorkItm());
                }
                if (lineItemsManualCostAllocationActualPosting.getServDate() != null) {
                    row.field("SERV_DATE", "BAPI_FBUDA", lineItemsManualCostAllocationActualPosting.getServDate());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreBuilding() != null) {
                    row.field("SRE_BUILDING", "SSGENR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreBuilding());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreBusEnt() != null) {
                    row.field("SRE_BUS_ENT", "SSWENR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreBusEnt());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreCompCode() != null) {
                    row.field("SRE_COMP_CODE", "VVSBUKRS", (ErpType)lineItemsManualCostAllocationActualPosting.getSreCompCode());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreConNo() != null) {
                    row.field("SRE_CON_NO", "RESCNNR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreConNo());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreIncExp() != null) {
                    row.field("SRE_INC_EXP", "SSNKSL", (ErpType)lineItemsManualCostAllocationActualPosting.getSreIncExp());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreLease() != null) {
                    row.field("SRE_LEASE", "SSMIVE", (ErpType)lineItemsManualCostAllocationActualPosting.getSreLease());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreMgmtCon() != null) {
                    row.field("SRE_MGMT_CON", "VVSSVWNR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreMgmtCon());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreProperty() != null) {
                    row.field("SRE_PROPERTY", "SSGRNR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreProperty());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreRefDate() != null) {
                    row.field("SRE_REF_DATE", "SDABRBEZ", lineItemsManualCostAllocationActualPosting.getSreRefDate());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreRentUnit() != null) {
                    row.field("SRE_RENT_UNIT", "SSMENR", (ErpType)lineItemsManualCostAllocationActualPosting.getSreRentUnit());
                }
                if (lineItemsManualCostAllocationActualPosting.getSreSettUnit() != null) {
                    row.field("SRE_SETT_UNIT", "SSEMPSL", (ErpType)lineItemsManualCostAllocationActualPosting.getSreSettUnit());
                }
                if (lineItemsManualCostAllocationActualPosting.getTransCurr() != null) {
                    row.field("TRANS_CURR", "TWAER", (ErpType)lineItemsManualCostAllocationActualPosting.getTransCurr());
                }
                if (lineItemsManualCostAllocationActualPosting.getTransCurrIso() != null) {
                    row.field("TRANS_CURR_ISO", "ISOCD", (ErpType)lineItemsManualCostAllocationActualPosting.getTransCurrIso());
                }
                if (lineItemsManualCostAllocationActualPosting.getValueTcur() != null) {
                    row.field("VALUE_TCUR", "BGTXXX", (ErpType)lineItemsManualCostAllocationActualPosting.getValueTcur());
                }
                if (lineItemsManualCostAllocationActualPosting.getValueTcurLong() == null) continue;
                row.field("VALUE_TCUR_LONG", "BGTXXX_31_8", (ErpType)lineItemsManualCostAllocationActualPosting.getValueTcurLong());
            }
            table.end();
        }
        if (this.customerFields != null && this.customerFields.iterator().hasNext()) {
            Table table = query.withTable("CUSTOMER_FIELDS", "BAPIEXTC");
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                row = table.row();
                if (containerForCustomerExitParameter.getField1() != null) {
                    row.field("FIELD1", "STRNG250", containerForCustomerExitParameter.getField1());
                }
                if (containerForCustomerExitParameter.getField2() != null) {
                    row.field("FIELD2", "STRNG250", containerForCustomerExitParameter.getField2());
                }
                if (containerForCustomerExitParameter.getField3() != null) {
                    row.field("FIELD3", "STRNG250", containerForCustomerExitParameter.getField3());
                }
                if (containerForCustomerExitParameter.getField4() == null) continue;
                row.field("FIELD4", "STRNG250", containerForCustomerExitParameter.getField4());
            }
            table.end();
        }
        query.withImportingAsReturn("DOC_NO", "BAPIDOCHDRU12P");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    @Override
    @Nonnull
    public AcctngManCostAllocPostFunction customerFields(ContainerForCustomerExitParameter ... items) {
        this.customerFields = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultAcctngManCostAllocPostFunction(docHeader=" + this.docHeader + ", ignoreWarnings=" + this.ignoreWarnings + ", docItems=" + this.docItems + ", customerFields=" + this.customerFields + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultAcctngManCostAllocPostFunction)) {
            return false;
        }
        DefaultAcctngManCostAllocPostFunction other = (DefaultAcctngManCostAllocPostFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DocumentHeaderPostCostsRevenuesActualPostings this$docHeader = this.docHeader;
        DocumentHeaderPostCostsRevenuesActualPostings other$docHeader = other.docHeader;
        if (this$docHeader == null ? other$docHeader != null : !((Object)this$docHeader).equals(other$docHeader)) {
            return false;
        }
        ErpBoolean this$ignoreWarnings = this.ignoreWarnings;
        ErpBoolean other$ignoreWarnings = other.ignoreWarnings;
        if (this$ignoreWarnings == null ? other$ignoreWarnings != null : !this$ignoreWarnings.equals(other$ignoreWarnings)) {
            return false;
        }
        Iterable<LineItemsManualCostAllocationActualPosting> this$docItems = this.docItems;
        Iterable<LineItemsManualCostAllocationActualPosting> other$docItems = other.docItems;
        if (this$docItems == null ? other$docItems != null : !this$docItems.equals(other$docItems)) {
            return false;
        }
        Iterable<ContainerForCustomerExitParameter> this$customerFields = this.customerFields;
        Iterable<ContainerForCustomerExitParameter> other$customerFields = other.customerFields;
        return !(this$customerFields == null ? other$customerFields != null : !this$customerFields.equals(other$customerFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultAcctngManCostAllocPostFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocumentHeaderPostCostsRevenuesActualPostings $docHeader = this.docHeader;
        result = result * 59 + ($docHeader == null ? 43 : ((Object)$docHeader).hashCode());
        ErpBoolean $ignoreWarnings = this.ignoreWarnings;
        result = result * 59 + ($ignoreWarnings == null ? 43 : $ignoreWarnings.hashCode());
        Iterable<LineItemsManualCostAllocationActualPosting> $docItems = this.docItems;
        result = result * 59 + ($docItems == null ? 43 : $docItems.hashCode());
        Iterable<ContainerForCustomerExitParameter> $customerFields = this.customerFields;
        result = result * 59 + ($customerFields == null ? 43 : $customerFields.hashCode());
        return result;
    }

    public DefaultAcctngManCostAllocPostFunction(DocumentHeaderPostCostsRevenuesActualPostings docHeader, @Nonnull Iterable<LineItemsManualCostAllocationActualPosting> docItems) {
        if (docItems == null) {
            throw new NullPointerException("docItems is marked @NonNull but is null");
        }
        this.docHeader = docHeader;
        this.docItems = docItems;
    }

    @Override
    public DefaultAcctngManCostAllocPostFunction ignoreWarnings(ErpBoolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    @Override
    public DefaultAcctngManCostAllocPostFunction customerFields(@Nonnull Iterable<ContainerForCustomerExitParameter> customerFields) {
        if (customerFields == null) {
            throw new NullPointerException("customerFields is marked @NonNull but is null");
        }
        this.customerFields = customerFields;
        return this;
    }
}

