/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.CostCenterCreateMultipleFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.CostCenterCreateMultipleFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultCostCenterCreateMultipleFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CostCenterCreateInput;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ProfitCenterLanguage;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.ControllingArea;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.MasterRecordInactive;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultCostCenterCreateMultipleFunction
implements CostCenterCreateMultipleFunction {
    private final ControllingArea controllingArea;
    private ErpBoolean testRun = null;
    private MasterRecordInactive masterDataInactive = null;
    private ProfitCenterLanguage languageKey = null;
    @Nonnull
    private final Iterable<CostCenterCreateInput> costCenterList;
    @Nonnull
    private Iterable<RefStructureForParameterExtensioninExtensionout> extensionIn = Lists.newArrayList();

    @Override
    @Nonnull
    public CostCenterCreateMultipleFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultCostCenterCreateMultipleFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public CostCenterCreateMultipleFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        if (this.languageKey != null) {
            this.languageKey.validate();
        }
        for (CostCenterCreateInput costCenterCreateInput : this.costCenterList) {
            costCenterCreateInput.validate();
        }
        if (this.extensionIn != null) {
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionIn) {
                refStructureForParameterExtensioninExtensionout.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_COSTCENTER_CREATEMULTIPLE");
        query.withExporting("CONTROLLINGAREA", "KOKRS", (ErpType)this.controllingArea);
        if (this.testRun != null) {
            query.withExporting("TESTRUN", "TESTRUN", (ErpType)this.testRun);
        }
        if (this.masterDataInactive != null) {
            query.withExporting("MASTER_DATA_INACTIVE", "CMDT_INACT", (ErpType)this.masterDataInactive);
        }
        if (this.languageKey != null) {
            ParameterFields parameterFields = query.withExportingFields("LANGUAGE", "BAPI0015_10");
            if (this.languageKey.getLangu() != null) {
                parameterFields.field("LANGU", "SPRAS", (ErpType)this.languageKey.getLangu());
            }
            if (this.languageKey.getLanguIso() != null) {
                parameterFields.field("LANGU_ISO", "LAISO", (ErpType)this.languageKey.getLanguIso());
            }
            parameterFields.end();
        }
        if (this.costCenterList.iterator().hasNext()) {
            Table table = query.withTable("COSTCENTERLIST", "BAPI0012_CCINPUTLIST");
            for (CostCenterCreateInput costCenterCreateInput : this.costCenterList) {
                row = table.row();
                if (costCenterCreateInput.getActyDepTemplate() != null) {
                    row.field("ACTY_DEP_TEMPLATE", "CCA_TEMPL_CPD", (ErpType)costCenterCreateInput.getActyDepTemplate());
                }
                if (costCenterCreateInput.getActyDepTemplateAllocCc() != null) {
                    row.field("ACTY_DEP_TEMPLATE_ALLOC_CC", "CCA_TEMPL_SCD", (ErpType)costCenterCreateInput.getActyDepTemplateAllocCc());
                }
                if (costCenterCreateInput.getActyDepTemplateSk() != null) {
                    row.field("ACTY_DEP_TEMPLATE_SK", "CCA_TEMPL_SKD", (ErpType)costCenterCreateInput.getActyDepTemplateSk());
                }
                if (costCenterCreateInput.getActyIndepTemplate() != null) {
                    row.field("ACTY_INDEP_TEMPLATE", "CCA_TEMPL_CPI", (ErpType)costCenterCreateInput.getActyIndepTemplate());
                }
                if (costCenterCreateInput.getActyIndepTemplateAllocCc() != null) {
                    row.field("ACTY_INDEP_TEMPLATE_ALLOC_CC", "CCA_TEMPL_SCI", (ErpType)costCenterCreateInput.getActyIndepTemplateAllocCc());
                }
                if (costCenterCreateInput.getActyIndepTemplateSk() != null) {
                    row.field("ACTY_INDEP_TEMPLATE_SK", "CCA_TEMPL_SKI", (ErpType)costCenterCreateInput.getActyIndepTemplateSk());
                }
                if (costCenterCreateInput.getAddrCity() != null) {
                    row.field("ADDR_CITY", "ORT01_GP", costCenterCreateInput.getAddrCity());
                }
                if (costCenterCreateInput.getAddrCountry() != null) {
                    row.field("ADDR_COUNTRY", "LAND1", (ErpType)costCenterCreateInput.getAddrCountry());
                }
                if (costCenterCreateInput.getAddrCountryIso() != null) {
                    row.field("ADDR_COUNTRY_ISO", "LAND1_ISO", (ErpType)costCenterCreateInput.getAddrCountryIso());
                }
                if (costCenterCreateInput.getAddrDistrict() != null) {
                    row.field("ADDR_DISTRICT", "ORT02_GP", costCenterCreateInput.getAddrDistrict());
                }
                if (costCenterCreateInput.getAddrName1() != null) {
                    row.field("ADDR_NAME1", "NAME1_GP", (ErpType)costCenterCreateInput.getAddrName1());
                }
                if (costCenterCreateInput.getAddrName2() != null) {
                    row.field("ADDR_NAME2", "NAME2_GP", (ErpType)costCenterCreateInput.getAddrName2());
                }
                if (costCenterCreateInput.getAddrName3() != null) {
                    row.field("ADDR_NAME3", "NAME3_GP", (ErpType)costCenterCreateInput.getAddrName3());
                }
                if (costCenterCreateInput.getAddrName4() != null) {
                    row.field("ADDR_NAME4", "NAME4_GP", (ErpType)costCenterCreateInput.getAddrName4());
                }
                if (costCenterCreateInput.getAddrPobxPcd() != null) {
                    row.field("ADDR_POBX_PCD", "PSTL2", (ErpType)costCenterCreateInput.getAddrPobxPcd());
                }
                if (costCenterCreateInput.getAddrPostlCode() != null) {
                    row.field("ADDR_POSTL_CODE", "PSTLZ", (ErpType)costCenterCreateInput.getAddrPostlCode());
                }
                if (costCenterCreateInput.getAddrPoBox() != null) {
                    row.field("ADDR_PO_BOX", "PFACH", (ErpType)costCenterCreateInput.getAddrPoBox());
                }
                if (costCenterCreateInput.getAddrRegion() != null) {
                    row.field("ADDR_REGION", "REGIO", (ErpType)costCenterCreateInput.getAddrRegion());
                }
                if (costCenterCreateInput.getAddrStreet() != null) {
                    row.field("ADDR_STREET", "STRAS_GP", costCenterCreateInput.getAddrStreet());
                }
                if (costCenterCreateInput.getAddrTaxjurcode() != null) {
                    row.field("ADDR_TAXJURCODE", "TXJCD", (ErpType)costCenterCreateInput.getAddrTaxjurcode());
                }
                if (costCenterCreateInput.getAddrTitle() != null) {
                    row.field("ADDR_TITLE", "ANRED", costCenterCreateInput.getAddrTitle());
                }
                if (costCenterCreateInput.getApplication() != null) {
                    row.field("APPLICATION", "KAPPL", (ErpType)costCenterCreateInput.getApplication());
                }
                if (costCenterCreateInput.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)costCenterCreateInput.getBusArea());
                }
                if (costCenterCreateInput.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)costCenterCreateInput.getCompCode());
                }
                if (costCenterCreateInput.getConditionTableUsage() != null) {
                    row.field("CONDITION_TABLE_USAGE", "KVEWE", (ErpType)costCenterCreateInput.getConditionTableUsage());
                }
                if (costCenterCreateInput.getCostcenter() != null) {
                    row.field("COSTCENTER", "KOSTL", (ErpType)costCenterCreateInput.getCostcenter());
                }
                if (costCenterCreateInput.getCostcenterType() != null) {
                    row.field("COSTCENTER_TYPE", "KOSAR", (ErpType)costCenterCreateInput.getCostcenterType());
                }
                if (costCenterCreateInput.getCostctrHierGrp() != null) {
                    row.field("COSTCTR_HIER_GRP", "KHINR", (ErpType)costCenterCreateInput.getCostctrHierGrp());
                }
                if (costCenterCreateInput.getCstgSheet() != null) {
                    row.field("CSTG_SHEET", "AUFKALSM", (ErpType)costCenterCreateInput.getCstgSheet());
                }
                if (costCenterCreateInput.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)costCenterCreateInput.getCurrency());
                }
                if (costCenterCreateInput.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)costCenterCreateInput.getCurrencyIso());
                }
                if (costCenterCreateInput.getDepartment() != null) {
                    row.field("DEPARTMENT", "ABTEI", (ErpType)costCenterCreateInput.getDepartment());
                }
                if (costCenterCreateInput.getDescript() != null) {
                    row.field("DESCRIPT", "KLTXT", costCenterCreateInput.getDescript());
                }
                if (costCenterCreateInput.getFuncArea() != null) {
                    row.field("FUNC_AREA", "FKBER_SHORT", (ErpType)costCenterCreateInput.getFuncArea());
                }
                if (costCenterCreateInput.getFuncAreaLong() != null) {
                    row.field("FUNC_AREA_LONG", "FKBER", (ErpType)costCenterCreateInput.getFuncAreaLong());
                }
                if (costCenterCreateInput.getJvEquityTyp() != null) {
                    row.field("JV_EQUITY_TYP", "JV_ETYPE", (ErpType)costCenterCreateInput.getJvEquityTyp());
                }
                if (costCenterCreateInput.getJvJibcl() != null) {
                    row.field("JV_JIBCL", "JV_JIBCL", (ErpType)costCenterCreateInput.getJvJibcl());
                }
                if (costCenterCreateInput.getJvJibsa() != null) {
                    row.field("JV_JIBSA", "JV_JIBSA", (ErpType)costCenterCreateInput.getJvJibsa());
                }
                if (costCenterCreateInput.getJvOtype() != null) {
                    row.field("JV_OTYPE", "JV_OTYPE", (ErpType)costCenterCreateInput.getJvOtype());
                }
                if (costCenterCreateInput.getJvRecInd() != null) {
                    row.field("JV_REC_IND", "JV_RECIND", (ErpType)costCenterCreateInput.getJvRecInd());
                }
                if (costCenterCreateInput.getJvVenture() != null) {
                    row.field("JV_VENTURE", "JV_NAME", (ErpType)costCenterCreateInput.getJvVenture());
                }
                if (costCenterCreateInput.getLockIndActualPrimaryCosts() != null) {
                    row.field("LOCK_IND_ACTUAL_PRIMARY_COSTS", "BKZKP", (ErpType)costCenterCreateInput.getLockIndActualPrimaryCosts());
                }
                if (costCenterCreateInput.getLockIndActualRevenues() != null) {
                    row.field("LOCK_IND_ACTUAL_REVENUES", "BKZER", (ErpType)costCenterCreateInput.getLockIndActualRevenues());
                }
                if (costCenterCreateInput.getLockIndActSecondaryCosts() != null) {
                    row.field("LOCK_IND_ACT_SECONDARY_COSTS", "BKZKS", (ErpType)costCenterCreateInput.getLockIndActSecondaryCosts());
                }
                if (costCenterCreateInput.getLockIndCommitmentUpdate() != null) {
                    row.field("LOCK_IND_COMMITMENT_UPDATE", "BKZOB", (ErpType)costCenterCreateInput.getLockIndCommitmentUpdate());
                }
                if (costCenterCreateInput.getLockIndPlanPrimaryCosts() != null) {
                    row.field("LOCK_IND_PLAN_PRIMARY_COSTS", "PKZKP", (ErpType)costCenterCreateInput.getLockIndPlanPrimaryCosts());
                }
                if (costCenterCreateInput.getLockIndPlanRevenues() != null) {
                    row.field("LOCK_IND_PLAN_REVENUES", "PKZER", (ErpType)costCenterCreateInput.getLockIndPlanRevenues());
                }
                if (costCenterCreateInput.getLockIndPlanSecondaryCosts() != null) {
                    row.field("LOCK_IND_PLAN_SECONDARY_COSTS", "PKZKS", (ErpType)costCenterCreateInput.getLockIndPlanSecondaryCosts());
                }
                if (costCenterCreateInput.getLogsystem() != null) {
                    row.field("LOGSYSTEM", "LOGSYSTEM", (ErpType)costCenterCreateInput.getLogsystem());
                }
                if (costCenterCreateInput.getName() != null) {
                    row.field("NAME", "KTEXT", costCenterCreateInput.getName());
                }
                if (costCenterCreateInput.getPersonInCharge() != null) {
                    row.field("PERSON_IN_CHARGE", "VERAK", (ErpType)costCenterCreateInput.getPersonInCharge());
                }
                if (costCenterCreateInput.getPersonInChargeUser() != null) {
                    row.field("PERSON_IN_CHARGE_USER", "VERAK_USER", (ErpType)costCenterCreateInput.getPersonInChargeUser());
                }
                if (costCenterCreateInput.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)costCenterCreateInput.getProfitCtr());
                }
                if (costCenterCreateInput.getRecordQuantity() != null) {
                    row.field("RECORD_QUANTITY", "MGEFL", (ErpType)costCenterCreateInput.getRecordQuantity());
                }
                if (costCenterCreateInput.getTelcoDataLine() != null) {
                    row.field("TELCO_DATA_LINE", "DATLT", costCenterCreateInput.getTelcoDataLine());
                }
                if (costCenterCreateInput.getTelcoFaxNumber() != null) {
                    row.field("TELCO_FAX_NUMBER", "TELFX", costCenterCreateInput.getTelcoFaxNumber());
                }
                if (costCenterCreateInput.getTelcoLangu() != null) {
                    row.field("TELCO_LANGU", "SPRAS", (ErpType)costCenterCreateInput.getTelcoLangu());
                }
                if (costCenterCreateInput.getTelcoLanguIso() != null) {
                    row.field("TELCO_LANGU_ISO", "LAISO", (ErpType)costCenterCreateInput.getTelcoLanguIso());
                }
                if (costCenterCreateInput.getTelcoPrinter() != null) {
                    row.field("TELCO_PRINTER", "KDNAM", (ErpType)costCenterCreateInput.getTelcoPrinter());
                }
                if (costCenterCreateInput.getTelcoTelebox() != null) {
                    row.field("TELCO_TELEBOX", "TELBX", costCenterCreateInput.getTelcoTelebox());
                }
                if (costCenterCreateInput.getTelcoTelephone() != null) {
                    row.field("TELCO_TELEPHONE", "TELF1", costCenterCreateInput.getTelcoTelephone());
                }
                if (costCenterCreateInput.getTelcoTelephone2() != null) {
                    row.field("TELCO_TELEPHONE2", "TELF2", costCenterCreateInput.getTelcoTelephone2());
                }
                if (costCenterCreateInput.getTelcoTeletex() != null) {
                    row.field("TELCO_TELETEX", "TELTX", costCenterCreateInput.getTelcoTeletex());
                }
                if (costCenterCreateInput.getTelcoTelex() != null) {
                    row.field("TELCO_TELEX", "TELX1", costCenterCreateInput.getTelcoTelex());
                }
                if (costCenterCreateInput.getValidFrom() != null) {
                    row.field("VALID_FROM", "DATAB", costCenterCreateInput.getValidFrom());
                }
                if (costCenterCreateInput.getValidTo() == null) continue;
                row.field("VALID_TO", "DATBI", costCenterCreateInput.getValidTo());
            }
            table.end();
        }
        if (this.extensionIn != null && this.extensionIn.iterator().hasNext()) {
            Table table = query.withTable("EXTENSIONIN", "BAPIPAREX");
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionIn) {
                row = table.row();
                if (refStructureForParameterExtensioninExtensionout.getStructure() != null) {
                    row.field("STRUCTURE", "TE_STRUC", (ErpType)refStructureForParameterExtensioninExtensionout.getStructure());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart1() != null) {
                    row.field("VALUEPART1", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart1());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart2() != null) {
                    row.field("VALUEPART2", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart2());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart3() != null) {
                    row.field("VALUEPART3", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart3());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart4() == null) continue;
                row.field("VALUEPART4", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart4());
            }
            table.end();
        }
        query.withTableAsReturn("EXTENSIONOUT", "BAPIPAREX");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    @Override
    @Nonnull
    public CostCenterCreateMultipleFunction extensionIn(RefStructureForParameterExtensioninExtensionout ... items) {
        this.extensionIn = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultCostCenterCreateMultipleFunction(controllingArea=" + (Object)((Object)this.controllingArea) + ", testRun=" + this.testRun + ", masterDataInactive=" + (Object)((Object)this.masterDataInactive) + ", languageKey=" + this.languageKey + ", costCenterList=" + this.costCenterList + ", extensionIn=" + this.extensionIn + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCostCenterCreateMultipleFunction)) {
            return false;
        }
        DefaultCostCenterCreateMultipleFunction other = (DefaultCostCenterCreateMultipleFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ControllingArea this$controllingArea = this.controllingArea;
        ControllingArea other$controllingArea = other.controllingArea;
        if (this$controllingArea == null ? other$controllingArea != null : !((Object)((Object)this$controllingArea)).equals((Object)other$controllingArea)) {
            return false;
        }
        ErpBoolean this$testRun = this.testRun;
        ErpBoolean other$testRun = other.testRun;
        if (this$testRun == null ? other$testRun != null : !this$testRun.equals(other$testRun)) {
            return false;
        }
        MasterRecordInactive this$masterDataInactive = this.masterDataInactive;
        MasterRecordInactive other$masterDataInactive = other.masterDataInactive;
        if (this$masterDataInactive == null ? other$masterDataInactive != null : !((Object)((Object)this$masterDataInactive)).equals((Object)other$masterDataInactive)) {
            return false;
        }
        ProfitCenterLanguage this$languageKey = this.languageKey;
        ProfitCenterLanguage other$languageKey = other.languageKey;
        if (this$languageKey == null ? other$languageKey != null : !((Object)this$languageKey).equals(other$languageKey)) {
            return false;
        }
        Iterable<CostCenterCreateInput> this$costCenterList = this.costCenterList;
        Iterable<CostCenterCreateInput> other$costCenterList = other.costCenterList;
        if (this$costCenterList == null ? other$costCenterList != null : !this$costCenterList.equals(other$costCenterList)) {
            return false;
        }
        Iterable<RefStructureForParameterExtensioninExtensionout> this$extensionIn = this.extensionIn;
        Iterable<RefStructureForParameterExtensioninExtensionout> other$extensionIn = other.extensionIn;
        return !(this$extensionIn == null ? other$extensionIn != null : !this$extensionIn.equals(other$extensionIn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultCostCenterCreateMultipleFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ControllingArea $controllingArea = this.controllingArea;
        result = result * 59 + ($controllingArea == null ? 43 : ((Object)((Object)$controllingArea)).hashCode());
        ErpBoolean $testRun = this.testRun;
        result = result * 59 + ($testRun == null ? 43 : $testRun.hashCode());
        MasterRecordInactive $masterDataInactive = this.masterDataInactive;
        result = result * 59 + ($masterDataInactive == null ? 43 : ((Object)((Object)$masterDataInactive)).hashCode());
        ProfitCenterLanguage $languageKey = this.languageKey;
        result = result * 59 + ($languageKey == null ? 43 : ((Object)$languageKey).hashCode());
        Iterable<CostCenterCreateInput> $costCenterList = this.costCenterList;
        result = result * 59 + ($costCenterList == null ? 43 : $costCenterList.hashCode());
        Iterable<RefStructureForParameterExtensioninExtensionout> $extensionIn = this.extensionIn;
        result = result * 59 + ($extensionIn == null ? 43 : $extensionIn.hashCode());
        return result;
    }

    public DefaultCostCenterCreateMultipleFunction(ControllingArea controllingArea, @Nonnull Iterable<CostCenterCreateInput> costCenterList) {
        if (costCenterList == null) {
            throw new NullPointerException("costCenterList is marked @NonNull but is null");
        }
        this.controllingArea = controllingArea;
        this.costCenterList = costCenterList;
    }

    @Override
    public DefaultCostCenterCreateMultipleFunction testRun(ErpBoolean testRun) {
        this.testRun = testRun;
        return this;
    }

    @Override
    public DefaultCostCenterCreateMultipleFunction masterDataInactive(MasterRecordInactive masterDataInactive) {
        this.masterDataInactive = masterDataInactive;
        return this;
    }

    @Override
    public DefaultCostCenterCreateMultipleFunction languageKey(ProfitCenterLanguage languageKey) {
        this.languageKey = languageKey;
        return this;
    }

    @Override
    public DefaultCostCenterCreateMultipleFunction extensionIn(@Nonnull Iterable<RefStructureForParameterExtensioninExtensionout> extensionIn) {
        if (extensionIn == null) {
            throw new NullPointerException("extensionIn is marked @NonNull but is null");
        }
        this.extensionIn = extensionIn;
        return this;
    }
}

