/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultFinancialTransactionGetListFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FinancialTransactionGetListFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FinancialTransactionGetListFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForBusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForCompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForEntryDate;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForExternalReference;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForInternalReference;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForPersonEnteringData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForProductType;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForTransactionNumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FinancialTransactionRangeForTransactionType;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultFinancialTransactionGetListFunction
implements FinancialTransactionGetListFunction {
    @Nonnull
    private Iterable<FinancialTransactionRangeForTransactionNumber> transactions = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForCompanyCode> companyCodes = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForProductType> productTypes = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForTransactionType> transactionTypes = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForBusinessPartner> partners = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForPersonEnteringData> createUsers = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForEntryDate> createDates = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForExternalReference> externalReferences = Lists.newArrayList();
    @Nonnull
    private Iterable<FinancialTransactionRangeForInternalReference> internalReferences = Lists.newArrayList();

    @Override
    @Nonnull
    public FinancialTransactionGetListFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultFinancialTransactionGetListFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        if (this.transactions != null) {
            for (FinancialTransactionRangeForTransactionNumber financialTransactionRangeForTransactionNumber : this.transactions) {
                financialTransactionRangeForTransactionNumber.validate();
            }
        }
        if (this.companyCodes != null) {
            for (FinancialTransactionRangeForCompanyCode financialTransactionRangeForCompanyCode : this.companyCodes) {
                financialTransactionRangeForCompanyCode.validate();
            }
        }
        if (this.productTypes != null) {
            for (FinancialTransactionRangeForProductType financialTransactionRangeForProductType : this.productTypes) {
                financialTransactionRangeForProductType.validate();
            }
        }
        if (this.transactionTypes != null) {
            for (FinancialTransactionRangeForTransactionType financialTransactionRangeForTransactionType : this.transactionTypes) {
                financialTransactionRangeForTransactionType.validate();
            }
        }
        if (this.partners != null) {
            for (FinancialTransactionRangeForBusinessPartner financialTransactionRangeForBusinessPartner : this.partners) {
                financialTransactionRangeForBusinessPartner.validate();
            }
        }
        if (this.createUsers != null) {
            for (FinancialTransactionRangeForPersonEnteringData financialTransactionRangeForPersonEnteringData : this.createUsers) {
                financialTransactionRangeForPersonEnteringData.validate();
            }
        }
        if (this.createDates != null) {
            for (FinancialTransactionRangeForEntryDate financialTransactionRangeForEntryDate : this.createDates) {
                financialTransactionRangeForEntryDate.validate();
            }
        }
        if (this.externalReferences != null) {
            for (FinancialTransactionRangeForExternalReference financialTransactionRangeForExternalReference : this.externalReferences) {
                financialTransactionRangeForExternalReference.validate();
            }
        }
        if (this.internalReferences != null) {
            for (FinancialTransactionRangeForInternalReference financialTransactionRangeForInternalReference : this.internalReferences) {
                financialTransactionRangeForInternalReference.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_FTR_GETLIST");
        if (this.transactions != null && this.transactions.iterator().hasNext()) {
            Table table = query.withTable("TRANSACTIONS", "BAPI2042_TR_RANGE");
            for (FinancialTransactionRangeForTransactionNumber financialTransactionRangeForTransactionNumber : this.transactions) {
                row = table.row();
                if (financialTransactionRangeForTransactionNumber.getHigh() != null) {
                    row.field("HIGH", "TB_RFHA", (ErpType)financialTransactionRangeForTransactionNumber.getHigh());
                }
                if (financialTransactionRangeForTransactionNumber.getLow() != null) {
                    row.field("LOW", "TB_RFHA", (ErpType)financialTransactionRangeForTransactionNumber.getLow());
                }
                if (financialTransactionRangeForTransactionNumber.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForTransactionNumber.getOption());
                }
                if (financialTransactionRangeForTransactionNumber.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForTransactionNumber.getSign());
            }
            table.end();
        }
        if (this.companyCodes != null && this.companyCodes.iterator().hasNext()) {
            Table table = query.withTable("COMPANYCODES", "BAPI2042_CC_RANGE");
            for (FinancialTransactionRangeForCompanyCode financialTransactionRangeForCompanyCode : this.companyCodes) {
                row = table.row();
                if (financialTransactionRangeForCompanyCode.getHigh() != null) {
                    row.field("HIGH", "BUKRS", (ErpType)financialTransactionRangeForCompanyCode.getHigh());
                }
                if (financialTransactionRangeForCompanyCode.getLow() != null) {
                    row.field("LOW", "BUKRS", (ErpType)financialTransactionRangeForCompanyCode.getLow());
                }
                if (financialTransactionRangeForCompanyCode.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForCompanyCode.getOption());
                }
                if (financialTransactionRangeForCompanyCode.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForCompanyCode.getSign());
            }
            table.end();
        }
        if (this.productTypes != null && this.productTypes.iterator().hasNext()) {
            Table table = query.withTable("PRODUCTTYPES", "BAPI2042_PT_RANGE");
            for (FinancialTransactionRangeForProductType financialTransactionRangeForProductType : this.productTypes) {
                row = table.row();
                if (financialTransactionRangeForProductType.getHigh() != null) {
                    row.field("HIGH", "VVSART", (ErpType)financialTransactionRangeForProductType.getHigh());
                }
                if (financialTransactionRangeForProductType.getLow() != null) {
                    row.field("LOW", "VVSART", (ErpType)financialTransactionRangeForProductType.getLow());
                }
                if (financialTransactionRangeForProductType.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForProductType.getOption());
                }
                if (financialTransactionRangeForProductType.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForProductType.getSign());
            }
            table.end();
        }
        if (this.transactionTypes != null && this.transactionTypes.iterator().hasNext()) {
            Table table = query.withTable("TRANSACTIONTYPES", "BAPI2042_TT_RANGE");
            for (FinancialTransactionRangeForTransactionType financialTransactionRangeForTransactionType : this.transactionTypes) {
                row = table.row();
                if (financialTransactionRangeForTransactionType.getHigh() != null) {
                    row.field("HIGH", "TB_SFHAART", (ErpType)financialTransactionRangeForTransactionType.getHigh());
                }
                if (financialTransactionRangeForTransactionType.getLow() != null) {
                    row.field("LOW", "TB_SFHAART", (ErpType)financialTransactionRangeForTransactionType.getLow());
                }
                if (financialTransactionRangeForTransactionType.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForTransactionType.getOption());
                }
                if (financialTransactionRangeForTransactionType.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForTransactionType.getSign());
            }
            table.end();
        }
        if (this.partners != null && this.partners.iterator().hasNext()) {
            Table table = query.withTable("PARTNERS", "BAPI2042_PA_RANGE");
            for (FinancialTransactionRangeForBusinessPartner financialTransactionRangeForBusinessPartner : this.partners) {
                row = table.row();
                if (financialTransactionRangeForBusinessPartner.getHigh() != null) {
                    row.field("HIGH", "TB_KUNNR_NEW", (ErpType)financialTransactionRangeForBusinessPartner.getHigh());
                }
                if (financialTransactionRangeForBusinessPartner.getLow() != null) {
                    row.field("LOW", "TB_KUNNR_NEW", (ErpType)financialTransactionRangeForBusinessPartner.getLow());
                }
                if (financialTransactionRangeForBusinessPartner.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForBusinessPartner.getOption());
                }
                if (financialTransactionRangeForBusinessPartner.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForBusinessPartner.getSign());
            }
            table.end();
        }
        if (this.createUsers != null && this.createUsers.iterator().hasNext()) {
            Table table = query.withTable("CREATEUSERS", "BAPI2042_CU_RANGE");
            for (FinancialTransactionRangeForPersonEnteringData financialTransactionRangeForPersonEnteringData : this.createUsers) {
                row = table.row();
                if (financialTransactionRangeForPersonEnteringData.getHigh() != null) {
                    row.field("HIGH", "TB_CRUSER", financialTransactionRangeForPersonEnteringData.getHigh());
                }
                if (financialTransactionRangeForPersonEnteringData.getLow() != null) {
                    row.field("LOW", "TB_CRUSER", financialTransactionRangeForPersonEnteringData.getLow());
                }
                if (financialTransactionRangeForPersonEnteringData.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForPersonEnteringData.getOption());
                }
                if (financialTransactionRangeForPersonEnteringData.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForPersonEnteringData.getSign());
            }
            table.end();
        }
        if (this.createDates != null && this.createDates.iterator().hasNext()) {
            Table table = query.withTable("CREATEDATES", "BAPI2042_CD_RANGE");
            for (FinancialTransactionRangeForEntryDate financialTransactionRangeForEntryDate : this.createDates) {
                row = table.row();
                if (financialTransactionRangeForEntryDate.getHigh() != null) {
                    row.field("HIGH", "TB_DCRDAT", financialTransactionRangeForEntryDate.getHigh());
                }
                if (financialTransactionRangeForEntryDate.getLow() != null) {
                    row.field("LOW", "TB_DCRDAT", financialTransactionRangeForEntryDate.getLow());
                }
                if (financialTransactionRangeForEntryDate.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForEntryDate.getOption());
                }
                if (financialTransactionRangeForEntryDate.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForEntryDate.getSign());
            }
            table.end();
        }
        if (this.externalReferences != null && this.externalReferences.iterator().hasNext()) {
            Table table = query.withTable("EXTERNALREFERENCES", "BAPI2042_XR_RANGE");
            for (FinancialTransactionRangeForExternalReference financialTransactionRangeForExternalReference : this.externalReferences) {
                row = table.row();
                if (financialTransactionRangeForExternalReference.getHigh() != null) {
                    row.field("HIGH", "TB_NORDEXT", (ErpType)financialTransactionRangeForExternalReference.getHigh());
                }
                if (financialTransactionRangeForExternalReference.getLow() != null) {
                    row.field("LOW", "TB_NORDEXT", (ErpType)financialTransactionRangeForExternalReference.getLow());
                }
                if (financialTransactionRangeForExternalReference.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForExternalReference.getOption());
                }
                if (financialTransactionRangeForExternalReference.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForExternalReference.getSign());
            }
            table.end();
        }
        if (this.internalReferences != null && this.internalReferences.iterator().hasNext()) {
            Table table = query.withTable("INTERNALREFERENCES", "BAPI2042_IR_RANGE");
            for (FinancialTransactionRangeForInternalReference financialTransactionRangeForInternalReference : this.internalReferences) {
                row = table.row();
                if (financialTransactionRangeForInternalReference.getHigh() != null) {
                    row.field("HIGH", "TB_REFER", financialTransactionRangeForInternalReference.getHigh());
                }
                if (financialTransactionRangeForInternalReference.getLow() != null) {
                    row.field("LOW", "TB_REFER", financialTransactionRangeForInternalReference.getLow());
                }
                if (financialTransactionRangeForInternalReference.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)financialTransactionRangeForInternalReference.getOption());
                }
                if (financialTransactionRangeForInternalReference.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)financialTransactionRangeForInternalReference.getSign());
            }
            table.end();
        }
        query.withImportingAsReturn("RETURN", "BAPIRET2");
        query.withTableAsReturn("TRANSACTIONLIST", "BAPI2042_GETLIST");
        return query;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction transactions(FinancialTransactionRangeForTransactionNumber ... items) {
        this.transactions = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction companyCodes(FinancialTransactionRangeForCompanyCode ... items) {
        this.companyCodes = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction productTypes(FinancialTransactionRangeForProductType ... items) {
        this.productTypes = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction transactionTypes(FinancialTransactionRangeForTransactionType ... items) {
        this.transactionTypes = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction partners(FinancialTransactionRangeForBusinessPartner ... items) {
        this.partners = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction createUsers(FinancialTransactionRangeForPersonEnteringData ... items) {
        this.createUsers = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction createDates(FinancialTransactionRangeForEntryDate ... items) {
        this.createDates = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction externalReferences(FinancialTransactionRangeForExternalReference ... items) {
        this.externalReferences = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FinancialTransactionGetListFunction internalReferences(FinancialTransactionRangeForInternalReference ... items) {
        this.internalReferences = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultFinancialTransactionGetListFunction(transactions=" + this.transactions + ", companyCodes=" + this.companyCodes + ", productTypes=" + this.productTypes + ", transactionTypes=" + this.transactionTypes + ", partners=" + this.partners + ", createUsers=" + this.createUsers + ", createDates=" + this.createDates + ", externalReferences=" + this.externalReferences + ", internalReferences=" + this.internalReferences + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFinancialTransactionGetListFunction)) {
            return false;
        }
        DefaultFinancialTransactionGetListFunction other = (DefaultFinancialTransactionGetListFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForTransactionNumber> this$transactions = this.transactions;
        Iterable<FinancialTransactionRangeForTransactionNumber> other$transactions = other.transactions;
        if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForCompanyCode> this$companyCodes = this.companyCodes;
        Iterable<FinancialTransactionRangeForCompanyCode> other$companyCodes = other.companyCodes;
        if (this$companyCodes == null ? other$companyCodes != null : !this$companyCodes.equals(other$companyCodes)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForProductType> this$productTypes = this.productTypes;
        Iterable<FinancialTransactionRangeForProductType> other$productTypes = other.productTypes;
        if (this$productTypes == null ? other$productTypes != null : !this$productTypes.equals(other$productTypes)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForTransactionType> this$transactionTypes = this.transactionTypes;
        Iterable<FinancialTransactionRangeForTransactionType> other$transactionTypes = other.transactionTypes;
        if (this$transactionTypes == null ? other$transactionTypes != null : !this$transactionTypes.equals(other$transactionTypes)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForBusinessPartner> this$partners = this.partners;
        Iterable<FinancialTransactionRangeForBusinessPartner> other$partners = other.partners;
        if (this$partners == null ? other$partners != null : !this$partners.equals(other$partners)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForPersonEnteringData> this$createUsers = this.createUsers;
        Iterable<FinancialTransactionRangeForPersonEnteringData> other$createUsers = other.createUsers;
        if (this$createUsers == null ? other$createUsers != null : !this$createUsers.equals(other$createUsers)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForEntryDate> this$createDates = this.createDates;
        Iterable<FinancialTransactionRangeForEntryDate> other$createDates = other.createDates;
        if (this$createDates == null ? other$createDates != null : !this$createDates.equals(other$createDates)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForExternalReference> this$externalReferences = this.externalReferences;
        Iterable<FinancialTransactionRangeForExternalReference> other$externalReferences = other.externalReferences;
        if (this$externalReferences == null ? other$externalReferences != null : !this$externalReferences.equals(other$externalReferences)) {
            return false;
        }
        Iterable<FinancialTransactionRangeForInternalReference> this$internalReferences = this.internalReferences;
        Iterable<FinancialTransactionRangeForInternalReference> other$internalReferences = other.internalReferences;
        return !(this$internalReferences == null ? other$internalReferences != null : !this$internalReferences.equals(other$internalReferences));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFinancialTransactionGetListFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Iterable<FinancialTransactionRangeForTransactionNumber> $transactions = this.transactions;
        result = result * 59 + ($transactions == null ? 43 : $transactions.hashCode());
        Iterable<FinancialTransactionRangeForCompanyCode> $companyCodes = this.companyCodes;
        result = result * 59 + ($companyCodes == null ? 43 : $companyCodes.hashCode());
        Iterable<FinancialTransactionRangeForProductType> $productTypes = this.productTypes;
        result = result * 59 + ($productTypes == null ? 43 : $productTypes.hashCode());
        Iterable<FinancialTransactionRangeForTransactionType> $transactionTypes = this.transactionTypes;
        result = result * 59 + ($transactionTypes == null ? 43 : $transactionTypes.hashCode());
        Iterable<FinancialTransactionRangeForBusinessPartner> $partners = this.partners;
        result = result * 59 + ($partners == null ? 43 : $partners.hashCode());
        Iterable<FinancialTransactionRangeForPersonEnteringData> $createUsers = this.createUsers;
        result = result * 59 + ($createUsers == null ? 43 : $createUsers.hashCode());
        Iterable<FinancialTransactionRangeForEntryDate> $createDates = this.createDates;
        result = result * 59 + ($createDates == null ? 43 : $createDates.hashCode());
        Iterable<FinancialTransactionRangeForExternalReference> $externalReferences = this.externalReferences;
        result = result * 59 + ($externalReferences == null ? 43 : $externalReferences.hashCode());
        Iterable<FinancialTransactionRangeForInternalReference> $internalReferences = this.internalReferences;
        result = result * 59 + ($internalReferences == null ? 43 : $internalReferences.hashCode());
        return result;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction transactions(@Nonnull Iterable<FinancialTransactionRangeForTransactionNumber> transactions) {
        if (transactions == null) {
            throw new NullPointerException("transactions is marked @NonNull but is null");
        }
        this.transactions = transactions;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction companyCodes(@Nonnull Iterable<FinancialTransactionRangeForCompanyCode> companyCodes) {
        if (companyCodes == null) {
            throw new NullPointerException("companyCodes is marked @NonNull but is null");
        }
        this.companyCodes = companyCodes;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction productTypes(@Nonnull Iterable<FinancialTransactionRangeForProductType> productTypes) {
        if (productTypes == null) {
            throw new NullPointerException("productTypes is marked @NonNull but is null");
        }
        this.productTypes = productTypes;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction transactionTypes(@Nonnull Iterable<FinancialTransactionRangeForTransactionType> transactionTypes) {
        if (transactionTypes == null) {
            throw new NullPointerException("transactionTypes is marked @NonNull but is null");
        }
        this.transactionTypes = transactionTypes;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction partners(@Nonnull Iterable<FinancialTransactionRangeForBusinessPartner> partners) {
        if (partners == null) {
            throw new NullPointerException("partners is marked @NonNull but is null");
        }
        this.partners = partners;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction createUsers(@Nonnull Iterable<FinancialTransactionRangeForPersonEnteringData> createUsers) {
        if (createUsers == null) {
            throw new NullPointerException("createUsers is marked @NonNull but is null");
        }
        this.createUsers = createUsers;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction createDates(@Nonnull Iterable<FinancialTransactionRangeForEntryDate> createDates) {
        if (createDates == null) {
            throw new NullPointerException("createDates is marked @NonNull but is null");
        }
        this.createDates = createDates;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction externalReferences(@Nonnull Iterable<FinancialTransactionRangeForExternalReference> externalReferences) {
        if (externalReferences == null) {
            throw new NullPointerException("externalReferences is marked @NonNull but is null");
        }
        this.externalReferences = externalReferences;
        return this;
    }

    @Override
    public DefaultFinancialTransactionGetListFunction internalReferences(@Nonnull Iterable<FinancialTransactionRangeForInternalReference> internalReferences) {
        if (internalReferences == null) {
            throw new NullPointerException("internalReferences is marked @NonNull but is null");
        }
        this.internalReferences = internalReferences;
        return this;
    }
}

