/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultFixedAssetGetListFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FixedAssetGetListFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FixedAssetGetListFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetInvestmentSupportMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetSelectionsForGetlist;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetSpecificationOfTheDataToBeReturnedByGetlist;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.MaximumNumberOfLinesOfHits;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.RealDepreciationArea;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.time.LocalDate;
import javax.annotation.Nonnull;

public class DefaultFixedAssetGetListFunction
implements FixedAssetGetListFunction {
    private final CompanyCode companyCode;
    private LocalDate evaluationDate = null;
    private RealDepreciationArea depreciationArea = null;
    private MaximumNumberOfLinesOfHits maxEntries = null;
    private FixedAssetSpecificationOfTheDataToBeReturnedByGetlist requestedTablesX = null;
    @Nonnull
    private Iterable<FixedAssetSelectionsForGetlist> selectionCriteria = Lists.newArrayList();
    @Nonnull
    private Iterable<FixedAssetInvestmentSupportMeasure> investmentSupport = Lists.newArrayList();

    @Override
    @Nonnull
    public FixedAssetGetListFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultFixedAssetGetListFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public FixedAssetGetListFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        if (this.requestedTablesX != null) {
            this.requestedTablesX.validate();
        }
        if (this.selectionCriteria != null) {
            for (FixedAssetSelectionsForGetlist fixedAssetSelectionsForGetlist : this.selectionCriteria) {
                fixedAssetSelectionsForGetlist.validate();
            }
        }
        if (this.investmentSupport != null) {
            for (FixedAssetInvestmentSupportMeasure fixedAssetInvestmentSupportMeasure : this.investmentSupport) {
                fixedAssetInvestmentSupportMeasure.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_FIXEDASSET_GETLIST");
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companyCode);
        if (this.evaluationDate != null) {
            query.withExporting("EVALUATIONDATE", "DATE_", this.evaluationDate);
        }
        if (this.depreciationArea != null) {
            query.withExporting("DEPRECIATIONAREA", "BF_AFABE_D", (ErpType)this.depreciationArea);
        }
        if (this.maxEntries != null) {
            query.withExporting("MAXENTRIES", "BAPIMAXROW", (ErpType)this.maxEntries);
        }
        if (this.requestedTablesX != null) {
            ParameterFields parameterFields = query.withExportingFields("REQUESTEDTABLESX", "BAPI1022_REQUESTEDTABLESX");
            if (this.requestedTablesX.getAllocations() != null) {
                parameterFields.field("ALLOCATIONS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getAllocations());
            }
            if (this.requestedTablesX.getDepreciationareas() != null) {
                parameterFields.field("DEPRECIATIONAREAS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getDepreciationareas());
            }
            if (this.requestedTablesX.getDepreciationareavals() != null) {
                parameterFields.field("DEPRECIATIONAREAVALS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getDepreciationareavals());
            }
            if (this.requestedTablesX.getExtensionout() != null) {
                parameterFields.field("EXTENSIONOUT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getExtensionout());
            }
            if (this.requestedTablesX.getGeneraldata() != null) {
                parameterFields.field("GENERALDATA", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getGeneraldata());
            }
            if (this.requestedTablesX.getInsurance() != null) {
                parameterFields.field("INSURANCE", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInsurance());
            }
            if (this.requestedTablesX.getInventory() != null) {
                parameterFields.field("INVENTORY", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInventory());
            }
            if (this.requestedTablesX.getInvestacctassignmnt() != null) {
                parameterFields.field("INVESTACCTASSIGNMNT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInvestacctassignmnt());
            }
            if (this.requestedTablesX.getInvestmentSupport() != null) {
                parameterFields.field("INVESTMENT_SUPPORT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInvestmentSupport());
            }
            if (this.requestedTablesX.getLeasing() != null) {
                parameterFields.field("LEASING", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getLeasing());
            }
            if (this.requestedTablesX.getNetworthvaluation() != null) {
                parameterFields.field("NETWORTHVALUATION", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getNetworthvaluation());
            }
            if (this.requestedTablesX.getOrigin() != null) {
                parameterFields.field("ORIGIN", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getOrigin());
            }
            if (this.requestedTablesX.getPostinginformation() != null) {
                parameterFields.field("POSTINGINFORMATION", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getPostinginformation());
            }
            if (this.requestedTablesX.getRealestate() != null) {
                parameterFields.field("REALESTATE", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getRealestate());
            }
            if (this.requestedTablesX.getTimedependentdata() != null) {
                parameterFields.field("TIMEDEPENDENTDATA", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getTimedependentdata());
            }
            parameterFields.end();
        }
        if (this.selectionCriteria != null && this.selectionCriteria.iterator().hasNext()) {
            Table table = query.withTable("SELECTIONCRITERIA", "BAPI1022_SELECTIONCRITERIA");
            for (FixedAssetSelectionsForGetlist fixedAssetSelectionsForGetlist : this.selectionCriteria) {
                row = table.row();
                if (fixedAssetSelectionsForGetlist.getField() != null) {
                    row.field("FIELD", "BAPI1022_FIELD", (ErpType)fixedAssetSelectionsForGetlist.getField());
                }
                if (fixedAssetSelectionsForGetlist.getHigh() != null) {
                    row.field("HIGH", "BAPI1022_HIGH", (ErpType)fixedAssetSelectionsForGetlist.getHigh());
                }
                if (fixedAssetSelectionsForGetlist.getLow() != null) {
                    row.field("LOW", "BAPI1022_LOW", (ErpType)fixedAssetSelectionsForGetlist.getLow());
                }
                if (fixedAssetSelectionsForGetlist.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)fixedAssetSelectionsForGetlist.getOption());
                }
                if (fixedAssetSelectionsForGetlist.getParameter() != null) {
                    row.field("PARAMETER", "BAPI1022_PARAM", (ErpType)fixedAssetSelectionsForGetlist.getParameter());
                }
                if (fixedAssetSelectionsForGetlist.getSign() == null) continue;
                row.field("SIGN", "BAPISIGN", (ErpType)fixedAssetSelectionsForGetlist.getSign());
            }
            table.end();
        }
        if (this.investmentSupport != null && this.investmentSupport.iterator().hasNext()) {
            Table table = query.withTable("INVESTMENT_SUPPORT", "BAPI1022_INV_SUPPORT_PID");
            for (FixedAssetInvestmentSupportMeasure fixedAssetInvestmentSupportMeasure : this.investmentSupport) {
                row = table.row();
                if (fixedAssetInvestmentSupportMeasure.getAsset() != null) {
                    row.field("ASSET", "BF_ANLN1", (ErpType)fixedAssetInvestmentSupportMeasure.getAsset());
                }
                if (fixedAssetInvestmentSupportMeasure.getChangeInd() != null) {
                    row.field("CHANGE_IND", "CDCHNGIND", (ErpType)fixedAssetInvestmentSupportMeasure.getChangeInd());
                }
                if (fixedAssetInvestmentSupportMeasure.getInvSupportKey() != null) {
                    row.field("INV_SUPPORT_KEY", "INVSL", (ErpType)fixedAssetInvestmentSupportMeasure.getInvSupportKey());
                }
                if (fixedAssetInvestmentSupportMeasure.getSubnumber() == null) continue;
                row.field("SUBNUMBER", "BF_ANLN2", (ErpType)fixedAssetInvestmentSupportMeasure.getSubnumber());
            }
            table.end();
        }
        query.withImportingAsReturn("RETURN", "BAPIRET2");
        query.withTableAsReturn("GENERALDATA", "BAPI1022_FEGLG001_PID");
        query.withTableAsReturn("INVENTORY", "BAPI1022_FEGLG011_PID");
        query.withTableAsReturn("POSTINGINFORMATION", "BAPI1022_FEGLG002_PID");
        query.withTableAsReturn("TIMEDEPENDENTDATA", "BAPI1022_FEGLG003_PID");
        query.withTableAsReturn("ALLOCATIONS", "BAPI1022_FEGLG004_PID");
        query.withTableAsReturn("ORIGIN", "BAPI1022_FEGLG009_PID");
        query.withTableAsReturn("INVESTACCTASSIGNMNT", "BAPI1022_FEGLG010_PID");
        query.withTableAsReturn("NETWORTHVALUATION", "BAPI1022_FEGLG006_PID");
        query.withTableAsReturn("REALESTATE", "BAPI1022_FEGLG007_PID");
        query.withTableAsReturn("INSURANCE", "BAPI1022_FEGLG008_PID");
        query.withTableAsReturn("LEASING", "BAPI1022_FEGLG005_PID");
        query.withTableAsReturn("DEPRECIATIONAREAS", "BAPI1022_DEP_AREAS_PID");
        query.withTableAsReturn("DEPRECIATIONAREAVALS", "BAPI1022_VALUES");
        query.withTableAsReturn("EXTENSIONOUT", "BAPIPAREX");
        return query;
    }

    @Override
    @Nonnull
    public FixedAssetGetListFunction selectionCriteria(FixedAssetSelectionsForGetlist ... items) {
        this.selectionCriteria = Lists.newArrayList((Object[])items);
        return this;
    }

    @Override
    @Nonnull
    public FixedAssetGetListFunction investmentSupport(FixedAssetInvestmentSupportMeasure ... items) {
        this.investmentSupport = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultFixedAssetGetListFunction(companyCode=" + (Object)((Object)this.companyCode) + ", evaluationDate=" + this.evaluationDate + ", depreciationArea=" + (Object)((Object)this.depreciationArea) + ", maxEntries=" + this.maxEntries + ", requestedTablesX=" + this.requestedTablesX + ", selectionCriteria=" + this.selectionCriteria + ", investmentSupport=" + this.investmentSupport + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFixedAssetGetListFunction)) {
            return false;
        }
        DefaultFixedAssetGetListFunction other = (DefaultFixedAssetGetListFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompanyCode this$companyCode = this.companyCode;
        CompanyCode other$companyCode = other.companyCode;
        if (this$companyCode == null ? other$companyCode != null : !((Object)((Object)this$companyCode)).equals((Object)other$companyCode)) {
            return false;
        }
        LocalDate this$evaluationDate = this.evaluationDate;
        LocalDate other$evaluationDate = other.evaluationDate;
        if (this$evaluationDate == null ? other$evaluationDate != null : !((Object)this$evaluationDate).equals(other$evaluationDate)) {
            return false;
        }
        RealDepreciationArea this$depreciationArea = this.depreciationArea;
        RealDepreciationArea other$depreciationArea = other.depreciationArea;
        if (this$depreciationArea == null ? other$depreciationArea != null : !((Object)((Object)this$depreciationArea)).equals((Object)other$depreciationArea)) {
            return false;
        }
        MaximumNumberOfLinesOfHits this$maxEntries = this.maxEntries;
        MaximumNumberOfLinesOfHits other$maxEntries = other.maxEntries;
        if (this$maxEntries == null ? other$maxEntries != null : !((Object)this$maxEntries).equals(other$maxEntries)) {
            return false;
        }
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist this$requestedTablesX = this.requestedTablesX;
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist other$requestedTablesX = other.requestedTablesX;
        if (this$requestedTablesX == null ? other$requestedTablesX != null : !((Object)this$requestedTablesX).equals(other$requestedTablesX)) {
            return false;
        }
        Iterable<FixedAssetSelectionsForGetlist> this$selectionCriteria = this.selectionCriteria;
        Iterable<FixedAssetSelectionsForGetlist> other$selectionCriteria = other.selectionCriteria;
        if (this$selectionCriteria == null ? other$selectionCriteria != null : !this$selectionCriteria.equals(other$selectionCriteria)) {
            return false;
        }
        Iterable<FixedAssetInvestmentSupportMeasure> this$investmentSupport = this.investmentSupport;
        Iterable<FixedAssetInvestmentSupportMeasure> other$investmentSupport = other.investmentSupport;
        return !(this$investmentSupport == null ? other$investmentSupport != null : !this$investmentSupport.equals(other$investmentSupport));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFixedAssetGetListFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompanyCode $companyCode = this.companyCode;
        result = result * 59 + ($companyCode == null ? 43 : ((Object)((Object)$companyCode)).hashCode());
        LocalDate $evaluationDate = this.evaluationDate;
        result = result * 59 + ($evaluationDate == null ? 43 : ((Object)$evaluationDate).hashCode());
        RealDepreciationArea $depreciationArea = this.depreciationArea;
        result = result * 59 + ($depreciationArea == null ? 43 : ((Object)((Object)$depreciationArea)).hashCode());
        MaximumNumberOfLinesOfHits $maxEntries = this.maxEntries;
        result = result * 59 + ($maxEntries == null ? 43 : ((Object)$maxEntries).hashCode());
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist $requestedTablesX = this.requestedTablesX;
        result = result * 59 + ($requestedTablesX == null ? 43 : ((Object)$requestedTablesX).hashCode());
        Iterable<FixedAssetSelectionsForGetlist> $selectionCriteria = this.selectionCriteria;
        result = result * 59 + ($selectionCriteria == null ? 43 : $selectionCriteria.hashCode());
        Iterable<FixedAssetInvestmentSupportMeasure> $investmentSupport = this.investmentSupport;
        result = result * 59 + ($investmentSupport == null ? 43 : $investmentSupport.hashCode());
        return result;
    }

    public DefaultFixedAssetGetListFunction(CompanyCode companyCode) {
        this.companyCode = companyCode;
    }

    @Override
    public DefaultFixedAssetGetListFunction evaluationDate(LocalDate evaluationDate) {
        this.evaluationDate = evaluationDate;
        return this;
    }

    @Override
    public DefaultFixedAssetGetListFunction depreciationArea(RealDepreciationArea depreciationArea) {
        this.depreciationArea = depreciationArea;
        return this;
    }

    @Override
    public DefaultFixedAssetGetListFunction maxEntries(MaximumNumberOfLinesOfHits maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    @Override
    public DefaultFixedAssetGetListFunction requestedTablesX(FixedAssetSpecificationOfTheDataToBeReturnedByGetlist requestedTablesX) {
        this.requestedTablesX = requestedTablesX;
        return this;
    }

    @Override
    public DefaultFixedAssetGetListFunction selectionCriteria(@Nonnull Iterable<FixedAssetSelectionsForGetlist> selectionCriteria) {
        if (selectionCriteria == null) {
            throw new NullPointerException("selectionCriteria is marked @NonNull but is null");
        }
        this.selectionCriteria = selectionCriteria;
        return this;
    }

    @Override
    public DefaultFixedAssetGetListFunction investmentSupport(@Nonnull Iterable<FixedAssetInvestmentSupportMeasure> investmentSupport) {
        if (investmentSupport == null) {
            throw new NullPointerException("investmentSupport is marked @NonNull but is null");
        }
        this.investmentSupport = investmentSupport;
        return this;
    }
}

