/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultForeignExchangeCreateSwapFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.ForeignExchangeCreateSwapFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.ForeignExchangeCreateSwapFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AdditionalDataForCurrencySwap;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CreateForexTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ForeignExchangeCreateswapFtrStructureForCreatingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForCreatingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForReferencedTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TransactionActivityCategory;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultForeignExchangeCreateSwapFunction
implements ForeignExchangeCreateSwapFunction {
    private final CreateForexTransaction forex1;
    private final CreateForexTransaction forex2;
    private final AdditionalDataForCurrencySwap swapAdditions;
    private final ForeignExchangeCreateswapFtrStructureForCreatingTransactions generalContractData2;
    private final FtrStructureForCreatingTransactions generalContractData1;
    private ErpBoolean testRun = null;
    private TransactionActivityCategory activityCategory = null;
    private FtrStructureForReferencedTransactions swapContractData = null;

    @Override
    @Nonnull
    public ForeignExchangeCreateSwapFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultForeignExchangeCreateSwapFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public ForeignExchangeCreateSwapFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        this.forex1.validate();
        this.forex2.validate();
        this.swapAdditions.validate();
        this.generalContractData2.validate();
        this.generalContractData1.validate();
        if (this.swapContractData != null) {
            this.swapContractData.validate();
        }
        BapiQuery query = new BapiQuery("BAPI_FTR_FXT_CREATESWAP");
        if (this.testRun != null) {
            query.withExporting("TESTRUN", "TESTRUN", (ErpType)this.testRun);
        }
        if (this.activityCategory != null) {
            query.withExporting("ACTIVITY_CATEGORY", "TB_SFGZUTY", (ErpType)this.activityCategory);
        }
        ParameterFields row = query.withExportingFields("FOREX_1", "BAPI_FTR_CREATE_FOREX_1");
        if (this.forex1.getBuyAmount() != null) {
            row.field("BUY_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex1.getBuyAmount());
        }
        if (this.forex1.getBuyCurrency() != null) {
            row.field("BUY_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex1.getBuyCurrency());
        }
        if (this.forex1.getBuyCurrencyIso() != null) {
            row.field("BUY_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getBuyCurrencyIso());
        }
        if (this.forex1.getFixingReferenceId() != null) {
            row.field("FIXING_REFERENCE_ID", "FTR_FIXING_REF_ID", (ErpType)this.forex1.getFixingReferenceId());
        }
        if (this.forex1.getFollowCurrency() != null) {
            row.field("FOLLOW_CURRENCY", "TB_WFWAERS", (ErpType)this.forex1.getFollowCurrency());
        }
        if (this.forex1.getFollowCurrencyIso() != null) {
            row.field("FOLLOW_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getFollowCurrencyIso());
        }
        if (this.forex1.getForwardRate() != null) {
            row.field("FORWARD_RATE", "TB_KKURS", (ErpType)this.forex1.getForwardRate());
        }
        if (this.forex1.getLeadCurrency() != null) {
            row.field("LEAD_CURRENCY", "TB_WLWAERS", (ErpType)this.forex1.getLeadCurrency());
        }
        if (this.forex1.getLeadCurrencyIso() != null) {
            row.field("LEAD_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getLeadCurrencyIso());
        }
        if (this.forex1.getNdfFixingCurrency() != null) {
            row.field("NDF_FIXING_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex1.getNdfFixingCurrency());
        }
        if (this.forex1.getNdfFixingCurrencyIso() != null) {
            row.field("NDF_FIXING_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getNdfFixingCurrencyIso());
        }
        if (this.forex1.getNdfFixingDate() != null) {
            row.field("NDF_FIXING_DATE", "TB_DFIX", this.forex1.getNdfFixingDate());
        }
        if (this.forex1.getRolloverLiquidityEffect() != null) {
            row.field("ROLLOVER_LIQUIDITY_EFFECT", "TX_KWLIQ", (ErpType)this.forex1.getRolloverLiquidityEffect());
        }
        if (this.forex1.getSellAmount() != null) {
            row.field("SELL_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex1.getSellAmount());
        }
        if (this.forex1.getSellCurrency() != null) {
            row.field("SELL_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex1.getSellCurrency());
        }
        if (this.forex1.getSellCurrencyIso() != null) {
            row.field("SELL_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getSellCurrencyIso());
        }
        if (this.forex1.getSpotRate() != null) {
            row.field("SPOT_RATE", "TB_KKASSA", (ErpType)this.forex1.getSpotRate());
        }
        if (this.forex1.getSwapRate() != null) {
            row.field("SWAP_RATE", "TB_KSWAP", (ErpType)this.forex1.getSwapRate());
        }
        if (this.forex1.getTradedCurrency() != null) {
            row.field("TRADED_CURRENCY", "FTR_TRADED_CURR", (ErpType)this.forex1.getTradedCurrency());
        }
        if (this.forex1.getTradedCurrencyIso() != null) {
            row.field("TRADED_CURRENCY_ISO", "ISOCD", (ErpType)this.forex1.getTradedCurrencyIso());
        }
        if (this.forex1.getValueDate() != null) {
            row.field("VALUE_DATE", "TB_DVALUTA", this.forex1.getValueDate());
        }
        row.end();
        row = query.withExportingFields("FOREX_2", "BAPI_FTR_CREATE_FOREX_2");
        if (this.forex2.getBuyAmount() != null) {
            row.field("BUY_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex2.getBuyAmount());
        }
        if (this.forex2.getBuyCurrency() != null) {
            row.field("BUY_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex2.getBuyCurrency());
        }
        if (this.forex2.getBuyCurrencyIso() != null) {
            row.field("BUY_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getBuyCurrencyIso());
        }
        if (this.forex2.getFixingReferenceId() != null) {
            row.field("FIXING_REFERENCE_ID", "FTR_FIXING_REF_ID", (ErpType)this.forex2.getFixingReferenceId());
        }
        if (this.forex2.getFollowCurrency() != null) {
            row.field("FOLLOW_CURRENCY", "TB_WFWAERS", (ErpType)this.forex2.getFollowCurrency());
        }
        if (this.forex2.getFollowCurrencyIso() != null) {
            row.field("FOLLOW_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getFollowCurrencyIso());
        }
        if (this.forex2.getForwardRate() != null) {
            row.field("FORWARD_RATE", "TB_KKURS", (ErpType)this.forex2.getForwardRate());
        }
        if (this.forex2.getLeadCurrency() != null) {
            row.field("LEAD_CURRENCY", "TB_WLWAERS", (ErpType)this.forex2.getLeadCurrency());
        }
        if (this.forex2.getLeadCurrencyIso() != null) {
            row.field("LEAD_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getLeadCurrencyIso());
        }
        if (this.forex2.getNdfFixingCurrency() != null) {
            row.field("NDF_FIXING_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex2.getNdfFixingCurrency());
        }
        if (this.forex2.getNdfFixingCurrencyIso() != null) {
            row.field("NDF_FIXING_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getNdfFixingCurrencyIso());
        }
        if (this.forex2.getNdfFixingDate() != null) {
            row.field("NDF_FIXING_DATE", "TB_DFIX", this.forex2.getNdfFixingDate());
        }
        if (this.forex2.getRolloverLiquidityEffect() != null) {
            row.field("ROLLOVER_LIQUIDITY_EFFECT", "TX_KWLIQ", (ErpType)this.forex2.getRolloverLiquidityEffect());
        }
        if (this.forex2.getSellAmount() != null) {
            row.field("SELL_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex2.getSellAmount());
        }
        if (this.forex2.getSellCurrency() != null) {
            row.field("SELL_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex2.getSellCurrency());
        }
        if (this.forex2.getSellCurrencyIso() != null) {
            row.field("SELL_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getSellCurrencyIso());
        }
        if (this.forex2.getSpotRate() != null) {
            row.field("SPOT_RATE", "TB_KKASSA", (ErpType)this.forex2.getSpotRate());
        }
        if (this.forex2.getSwapRate() != null) {
            row.field("SWAP_RATE", "TB_KSWAP", (ErpType)this.forex2.getSwapRate());
        }
        if (this.forex2.getTradedCurrency() != null) {
            row.field("TRADED_CURRENCY", "FTR_TRADED_CURR", (ErpType)this.forex2.getTradedCurrency());
        }
        if (this.forex2.getTradedCurrencyIso() != null) {
            row.field("TRADED_CURRENCY_ISO", "ISOCD", (ErpType)this.forex2.getTradedCurrencyIso());
        }
        if (this.forex2.getValueDate() != null) {
            row.field("VALUE_DATE", "TB_DVALUTA", this.forex2.getValueDate());
        }
        row.end();
        row = query.withExportingFields("SWAP_ADDITIONS", "BAPI_FTR_CREATE_FXSWAP");
        if (this.swapAdditions.getCopyAssignment() != null) {
            row.field("COPY_ASSIGNMENT", "TX_XCOPIEFPR", (ErpType)this.swapAdditions.getCopyAssignment());
        }
        if (this.swapAdditions.getCopyBuySide() != null) {
            row.field("COPY_BUY_SIDE", "TX_XCOPIEBT1", (ErpType)this.swapAdditions.getCopyBuySide());
        }
        if (this.swapAdditions.getCopyCharacteristics() != null) {
            row.field("COPY_CHARACTERISTICS", "TX_COPIEMER", (ErpType)this.swapAdditions.getCopyCharacteristics());
        }
        if (this.swapAdditions.getCopyExternalReference() != null) {
            row.field("COPY_EXTERNAL_REFERENCE", "TX_XCOPIEREF", (ErpType)this.swapAdditions.getCopyExternalReference());
        }
        if (this.swapAdditions.getCopyFinanceProject() != null) {
            row.field("COPY_FINANCE_PROJECT", "TX_XCOPIEFPR", (ErpType)this.swapAdditions.getCopyFinanceProject());
        }
        if (this.swapAdditions.getCopyForwardRate() != null) {
            row.field("COPY_FORWARD_RATE", "TX_XCOPIEKUR", (ErpType)this.swapAdditions.getCopyForwardRate());
        }
        if (this.swapAdditions.getCopyGuarantor() != null) {
            row.field("COPY_GUARANTOR", "TX_COPIERGA", (ErpType)this.swapAdditions.getCopyGuarantor());
        }
        if (this.swapAdditions.getCopyInternalReference() != null) {
            row.field("COPY_INTERNAL_REFERENCE", "TX_COPIERFR", (ErpType)this.swapAdditions.getCopyInternalReference());
        }
        if (this.swapAdditions.getCopySellSide() != null) {
            row.field("COPY_SELL_SIDE", "TX_XCOPIEBT2", (ErpType)this.swapAdditions.getCopySellSide());
        }
        if (this.swapAdditions.getCopySpotRate() != null) {
            row.field("COPY_SPOT_RATE", "TX_XCOPIESPO", (ErpType)this.swapAdditions.getCopySpotRate());
        }
        if (this.swapAdditions.getCopySwapRate() != null) {
            row.field("COPY_SWAP_RATE", "TX_XCOPIESWA", (ErpType)this.swapAdditions.getCopySwapRate());
        }
        if (this.swapAdditions.getCopyValueDate() != null) {
            row.field("COPY_VALUE_DATE", "TX_XCOPIEVAL", (ErpType)this.swapAdditions.getCopyValueDate());
        }
        row.end();
        row = query.withExportingFields("GENERALCONTRACTDATA_2", "BAPI_FTR_CREATE2");
        if (this.generalContractData2.getAcctAssignmentRef() != null) {
            row.field("ACCT_ASSIGNMENT_REF", "RREFKONT_OBSOLETE", (ErpType)this.generalContractData2.getAcctAssignmentRef());
        }
        if (this.generalContractData2.getAssignment() != null) {
            row.field("ASSIGNMENT", "TB_ZUOND", this.generalContractData2.getAssignment());
        }
        if (this.generalContractData2.getAuthGroup() != null) {
            row.field("AUTH_GROUP", "TBEGRU", (ErpType)this.generalContractData2.getAuthGroup());
        }
        if (this.generalContractData2.getBusinessArea() != null) {
            row.field("BUSINESS_AREA", "GSBER", (ErpType)this.generalContractData2.getBusinessArea());
        }
        if (this.generalContractData2.getCfiCode() != null) {
            row.field("CFI_CODE", "FTR_CFI_CODE", this.generalContractData2.getCfiCode());
        }
        if (this.generalContractData2.getCharacteristics() != null) {
            row.field("CHARACTERISTICS", "TB_MERKM", this.generalContractData2.getCharacteristics());
        }
        if (this.generalContractData2.getCompanyCode() != null) {
            row.field("COMPANY_CODE", "BUKRS", (ErpType)this.generalContractData2.getCompanyCode());
        }
        if (this.generalContractData2.getContactPerson() != null) {
            row.field("CONTACT_PERSON", "TB_GSPPART", this.generalContractData2.getContactPerson());
        }
        if (this.generalContractData2.getContractDate() != null) {
            row.field("CONTRACT_DATE", "TB_DVTRAB", this.generalContractData2.getContractDate());
        }
        if (this.generalContractData2.getContractTime() != null) {
            row.field("CONTRACT_TIME", "TB_TVTRAB", this.generalContractData2.getContractTime());
        }
        if (this.generalContractData2.getContractTimestampUtc() != null) {
            row.field("CONTRACT_TIMESTAMP_UTC", "FTR_CONTRACT_TIMESTAMP_UTC", (ErpType)this.generalContractData2.getContractTimestampUtc());
        }
        if (this.generalContractData2.getCostCenter() != null) {
            row.field("COST_CENTER", "KOSTL", (ErpType)this.generalContractData2.getCostCenter());
        }
        if (this.generalContractData2.getCountry() != null) {
            row.field("COUNTRY", "LAND1", (ErpType)this.generalContractData2.getCountry());
        }
        if (this.generalContractData2.getCountryIso() != null) {
            row.field("COUNTRY_ISO", "INTCA", (ErpType)this.generalContractData2.getCountryIso());
        }
        if (this.generalContractData2.getCreateUser() != null) {
            row.field("CREATE_USER", "TB_CRUSER", this.generalContractData2.getCreateUser());
        }
        if (this.generalContractData2.getEntryDate() != null) {
            row.field("ENTRY_DATE", "TB_DCRDAT", this.generalContractData2.getEntryDate());
        }
        if (this.generalContractData2.getExternalReference() != null) {
            row.field("EXTERNAL_REFERENCE", "TB_NORDEXT", (ErpType)this.generalContractData2.getExternalReference());
        }
        if (this.generalContractData2.getExternalTradeId() != null) {
            row.field("EXTERNAL_TRADE_ID", "FTR_TARO_TRADE_ID", (ErpType)this.generalContractData2.getExternalTradeId());
        }
        if (this.generalContractData2.getExternalTransactionNumber() != null) {
            row.field("EXTERNAL_TRANSACTION_NUMBER", "TB_RFHA", (ErpType)this.generalContractData2.getExternalTransactionNumber());
        }
        if (this.generalContractData2.getFacility() != null) {
            row.field("FACILITY", "TB_FACILITYNR", (ErpType)this.generalContractData2.getFacility());
        }
        if (this.generalContractData2.getFacilityCompanyCode() != null) {
            row.field("FACILITY_COMPANY_CODE", "TB_FACILITYBUKRS", (ErpType)this.generalContractData2.getFacilityCompanyCode());
        }
        if (this.generalContractData2.getFinanceProject() != null) {
            row.field("FINANCE_PROJECT", "TB_TFPROJ", (ErpType)this.generalContractData2.getFinanceProject());
        }
        if (this.generalContractData2.getGuarantor() != null) {
            row.field("GUARANTOR", "TB_RGARANT_NEW", (ErpType)this.generalContractData2.getGuarantor());
        }
        if (this.generalContractData2.getHedgeRequestId() != null) {
            row.field("HEDGE_REQUEST_ID", "TOE_REQUEST_ID", (ErpType)this.generalContractData2.getHedgeRequestId());
        }
        if (this.generalContractData2.getHedgingClassification() != null) {
            row.field("HEDGING_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION", (ErpType)this.generalContractData2.getHedgingClassification());
        }
        if (this.generalContractData2.getInitClassifier() != null) {
            row.field("INIT_CLASSIFIER", "TRPA_INITIAL_STAGE", (ErpType)this.generalContractData2.getInitClassifier());
        }
        if (this.generalContractData2.getInternalReference() != null) {
            row.field("INTERNAL_REFERENCE", "TB_REFER", this.generalContractData2.getInternalReference());
        }
        if (this.generalContractData2.getIsin() != null) {
            row.field("ISIN", "RANL_ISIN", (ErpType)this.generalContractData2.getIsin());
        }
        if (this.generalContractData2.getLegalBasis() != null) {
            row.field("LEGAL_BASIS", "FTR_THRESHOLD_SCHEME", (ErpType)this.generalContractData2.getLegalBasis());
        }
        if (this.generalContractData2.getMasterAgreement() != null) {
            row.field("MASTER_AGREEMENT", "TB_RMAID", (ErpType)this.generalContractData2.getMasterAgreement());
        }
        if (this.generalContractData2.getMic() != null) {
            row.field("MIC", "TBA_MIC", (ErpType)this.generalContractData2.getMic());
        }
        if (this.generalContractData2.getOnBehalfOfCompany() != null) {
            row.field("ON_BEHALF_OF_COMPANY", "TRBA_BEHALF_OF_COMPANY", (ErpType)this.generalContractData2.getOnBehalfOfCompany());
        }
        if (this.generalContractData2.getPartner() != null) {
            row.field("PARTNER", "TB_KUNNR_NEW", (ErpType)this.generalContractData2.getPartner());
        }
        if (this.generalContractData2.getPortfolio() != null) {
            row.field("PORTFOLIO", "RPORTB", (ErpType)this.generalContractData2.getPortfolio());
        }
        if (this.generalContractData2.getProductType() != null) {
            row.field("PRODUCT_TYPE", "VVSART", (ErpType)this.generalContractData2.getProductType());
        }
        if (this.generalContractData2.getProfitCenter() != null) {
            row.field("PROFIT_CENTER", "PRCTR", (ErpType)this.generalContractData2.getProfitCenter());
        }
        if (this.generalContractData2.getRiskMitigation() != null) {
            row.field("RISK_MITIGATION", "FTR_THRESHOLD_RISK_MITIGATING", (ErpType)this.generalContractData2.getRiskMitigation());
        }
        if (this.generalContractData2.getSegment() != null) {
            row.field("SEGMENT", "FB_SEGMENT", (ErpType)this.generalContractData2.getSegment());
        }
        if (this.generalContractData2.getTrader() != null) {
            row.field("TRADER", "RDEALER", (ErpType)this.generalContractData2.getTrader());
        }
        if (this.generalContractData2.getTransactionType() != null) {
            row.field("TRANSACTION_TYPE", "TB_SFHAART", (ErpType)this.generalContractData2.getTransactionType());
        }
        if (this.generalContractData2.getValuationClass() != null) {
            row.field("VALUATION_CLASS", "TPM_COM_VAL_CLASS", (ErpType)this.generalContractData2.getValuationClass());
        }
        if (this.generalContractData2.getWbsElement() != null) {
            row.field("WBS_ELEMENT", "PS_PSP_PNR", (ErpType)this.generalContractData2.getWbsElement());
        }
        row.end();
        row = query.withExportingFields("GENERALCONTRACTDATA_1", "BAPI_FTR_CREATE");
        if (this.generalContractData1.getAcctAssignmentRef() != null) {
            row.field("ACCT_ASSIGNMENT_REF", "RREFKONT_OBSOLETE", (ErpType)this.generalContractData1.getAcctAssignmentRef());
        }
        if (this.generalContractData1.getAssignment() != null) {
            row.field("ASSIGNMENT", "TB_ZUOND", this.generalContractData1.getAssignment());
        }
        if (this.generalContractData1.getAuthGroup() != null) {
            row.field("AUTH_GROUP", "TBEGRU", (ErpType)this.generalContractData1.getAuthGroup());
        }
        if (this.generalContractData1.getBusinessArea() != null) {
            row.field("BUSINESS_AREA", "GSBER", (ErpType)this.generalContractData1.getBusinessArea());
        }
        if (this.generalContractData1.getCfiCode() != null) {
            row.field("CFI_CODE", "FTR_CFI_CODE", this.generalContractData1.getCfiCode());
        }
        if (this.generalContractData1.getCharacteristics() != null) {
            row.field("CHARACTERISTICS", "TB_MERKM", this.generalContractData1.getCharacteristics());
        }
        if (this.generalContractData1.getClearingDate() != null) {
            row.field("CLEARING_DATE", "TPM_TREA_CLEARING_DATE", this.generalContractData1.getClearingDate());
        }
        if (this.generalContractData1.getClearingOption() != null) {
            row.field("CLEARING_OPTION", "TPM_TREA_CLEARING_OPT", (ErpType)this.generalContractData1.getClearingOption());
        }
        if (this.generalContractData1.getClearingStatus() != null) {
            row.field("CLEARING_STATUS", "TPM_TREA_CLEARING_STATUS", (ErpType)this.generalContractData1.getClearingStatus());
        }
        if (this.generalContractData1.getClearDateAct() != null) {
            row.field("CLEAR_DATE_ACT", "TPM_TREA_CLEARING_DATE_ACT", this.generalContractData1.getClearDateAct());
        }
        if (this.generalContractData1.getCompanyCode() != null) {
            row.field("COMPANY_CODE", "BUKRS", (ErpType)this.generalContractData1.getCompanyCode());
        }
        if (this.generalContractData1.getContactPerson() != null) {
            row.field("CONTACT_PERSON", "TB_GSPPART", this.generalContractData1.getContactPerson());
        }
        if (this.generalContractData1.getContractDate() != null) {
            row.field("CONTRACT_DATE", "TB_DVTRAB", this.generalContractData1.getContractDate());
        }
        if (this.generalContractData1.getContractTime() != null) {
            row.field("CONTRACT_TIME", "TB_TVTRAB", this.generalContractData1.getContractTime());
        }
        if (this.generalContractData1.getContractTimestampUtc() != null) {
            row.field("CONTRACT_TIMESTAMP_UTC", "FTR_CONTRACT_TIMESTAMP_UTC", (ErpType)this.generalContractData1.getContractTimestampUtc());
        }
        if (this.generalContractData1.getCostCenter() != null) {
            row.field("COST_CENTER", "KOSTL", (ErpType)this.generalContractData1.getCostCenter());
        }
        if (this.generalContractData1.getCountry() != null) {
            row.field("COUNTRY", "LAND1", (ErpType)this.generalContractData1.getCountry());
        }
        if (this.generalContractData1.getCountryIso() != null) {
            row.field("COUNTRY_ISO", "INTCA", (ErpType)this.generalContractData1.getCountryIso());
        }
        if (this.generalContractData1.getCreateUser() != null) {
            row.field("CREATE_USER", "TB_CRUSER", this.generalContractData1.getCreateUser());
        }
        if (this.generalContractData1.getEntryDate() != null) {
            row.field("ENTRY_DATE", "TB_DCRDAT", this.generalContractData1.getEntryDate());
        }
        if (this.generalContractData1.getExpenseKey() != null) {
            row.field("EXPENSE_KEY", "TB_SPESEN", (ErpType)this.generalContractData1.getExpenseKey());
        }
        if (this.generalContractData1.getExternalReference() != null) {
            row.field("EXTERNAL_REFERENCE", "TB_NORDEXT", (ErpType)this.generalContractData1.getExternalReference());
        }
        if (this.generalContractData1.getExternalTradeId() != null) {
            row.field("EXTERNAL_TRADE_ID", "FTR_TARO_TRADE_ID", (ErpType)this.generalContractData1.getExternalTradeId());
        }
        if (this.generalContractData1.getExternalTransactionNumber() != null) {
            row.field("EXTERNAL_TRANSACTION_NUMBER", "TB_RFHA", (ErpType)this.generalContractData1.getExternalTransactionNumber());
        }
        if (this.generalContractData1.getExtAccount() != null) {
            row.field("EXT_ACCOUNT", "TPM_EXT_ACCOUNT", (ErpType)this.generalContractData1.getExtAccount());
        }
        if (this.generalContractData1.getFacility() != null) {
            row.field("FACILITY", "TB_FACILITYNR", (ErpType)this.generalContractData1.getFacility());
        }
        if (this.generalContractData1.getFacilityCompanyCode() != null) {
            row.field("FACILITY_COMPANY_CODE", "TB_FACILITYBUKRS", (ErpType)this.generalContractData1.getFacilityCompanyCode());
        }
        if (this.generalContractData1.getFinanceProject() != null) {
            row.field("FINANCE_PROJECT", "TB_TFPROJ", (ErpType)this.generalContractData1.getFinanceProject());
        }
        if (this.generalContractData1.getFund() != null) {
            row.field("FUND", "FM_FUND", (ErpType)this.generalContractData1.getFund());
        }
        if (this.generalContractData1.getGrantNbr() != null) {
            row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)this.generalContractData1.getGrantNbr());
        }
        if (this.generalContractData1.getGuarantor() != null) {
            row.field("GUARANTOR", "TB_RGARANT_NEW", (ErpType)this.generalContractData1.getGuarantor());
        }
        if (this.generalContractData1.getHedgeClassification() != null) {
            row.field("HEDGE_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION_OLD", (ErpType)this.generalContractData1.getHedgeClassification());
        }
        if (this.generalContractData1.getHedgeRequestId() != null) {
            row.field("HEDGE_REQUEST_ID", "TOE_REQUEST_ID", (ErpType)this.generalContractData1.getHedgeRequestId());
        }
        if (this.generalContractData1.getHedgingClassification() != null) {
            row.field("HEDGING_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION", (ErpType)this.generalContractData1.getHedgingClassification());
        }
        if (this.generalContractData1.getInitClassifier() != null) {
            row.field("INIT_CLASSIFIER", "TRPA_INITIAL_STAGE", (ErpType)this.generalContractData1.getInitClassifier());
        }
        if (this.generalContractData1.getInternalReference() != null) {
            row.field("INTERNAL_REFERENCE", "TB_REFER", this.generalContractData1.getInternalReference());
        }
        if (this.generalContractData1.getIsin() != null) {
            row.field("ISIN", "RANL_ISIN", (ErpType)this.generalContractData1.getIsin());
        }
        if (this.generalContractData1.getLegalBasis() != null) {
            row.field("LEGAL_BASIS", "FTR_THRESHOLD_SCHEME", (ErpType)this.generalContractData1.getLegalBasis());
        }
        if (this.generalContractData1.getMasterAgreement() != null) {
            row.field("MASTER_AGREEMENT", "TB_RMAID", (ErpType)this.generalContractData1.getMasterAgreement());
        }
        if (this.generalContractData1.getMic() != null) {
            row.field("MIC", "TBA_MIC", (ErpType)this.generalContractData1.getMic());
        }
        if (this.generalContractData1.getOnBehalfOfCompany() != null) {
            row.field("ON_BEHALF_OF_COMPANY", "TRBA_BEHALF_OF_COMPANY", (ErpType)this.generalContractData1.getOnBehalfOfCompany());
        }
        if (this.generalContractData1.getPartner() != null) {
            row.field("PARTNER", "TB_KUNNR_NEW", (ErpType)this.generalContractData1.getPartner());
        }
        if (this.generalContractData1.getPortfolio() != null) {
            row.field("PORTFOLIO", "RPORTB", (ErpType)this.generalContractData1.getPortfolio());
        }
        if (this.generalContractData1.getProductType() != null) {
            row.field("PRODUCT_TYPE", "VVSART", (ErpType)this.generalContractData1.getProductType());
        }
        if (this.generalContractData1.getProfitCenter() != null) {
            row.field("PROFIT_CENTER", "PRCTR", (ErpType)this.generalContractData1.getProfitCenter());
        }
        if (this.generalContractData1.getReservReason() != null) {
            row.field("RESERV_REASON", "TB_SANST", (ErpType)this.generalContractData1.getReservReason());
        }
        if (this.generalContractData1.getRiskMitigation() != null) {
            row.field("RISK_MITIGATION", "FTR_THRESHOLD_RISK_MITIGATING", (ErpType)this.generalContractData1.getRiskMitigation());
        }
        if (this.generalContractData1.getSegment() != null) {
            row.field("SEGMENT", "FB_SEGMENT", (ErpType)this.generalContractData1.getSegment());
        }
        if (this.generalContractData1.getTrader() != null) {
            row.field("TRADER", "RDEALER", (ErpType)this.generalContractData1.getTrader());
        }
        if (this.generalContractData1.getTransactionType() != null) {
            row.field("TRANSACTION_TYPE", "TB_SFHAART", (ErpType)this.generalContractData1.getTransactionType());
        }
        if (this.generalContractData1.getValuationClass() != null) {
            row.field("VALUATION_CLASS", "TPM_COM_VAL_CLASS", (ErpType)this.generalContractData1.getValuationClass());
        }
        if (this.generalContractData1.getWbsElement() != null) {
            row.field("WBS_ELEMENT", "PS_PSP_PNR", (ErpType)this.generalContractData1.getWbsElement());
        }
        row.end();
        if (this.swapContractData != null) {
            row = query.withExportingFields("SWAP_CONTRACT_DATA", "BAPI_FTR_REF_CONTRACT_DATA");
            if (this.swapContractData.getCfiCode() != null) {
                row.field("CFI_CODE", "FTR_CFI_CODE", this.swapContractData.getCfiCode());
            }
            if (this.swapContractData.getIsin() != null) {
                row.field("ISIN", "RANL_ISIN", (ErpType)this.swapContractData.getIsin());
            }
            row.end();
        }
        query.withImportingAsReturn("FINANCIALTRANSACTION", "BAPI2042");
        query.withImportingAsReturn("COMPANYCODE", "BAPI2042");
        query.withImportingAsReturn("FINANCIALTRANSACTION2", "BAPI2042");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    public String toString() {
        return "DefaultForeignExchangeCreateSwapFunction(forex1=" + this.forex1 + ", forex2=" + this.forex2 + ", swapAdditions=" + this.swapAdditions + ", generalContractData2=" + this.generalContractData2 + ", generalContractData1=" + this.generalContractData1 + ", testRun=" + this.testRun + ", activityCategory=" + (Object)((Object)this.activityCategory) + ", swapContractData=" + this.swapContractData + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultForeignExchangeCreateSwapFunction)) {
            return false;
        }
        DefaultForeignExchangeCreateSwapFunction other = (DefaultForeignExchangeCreateSwapFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CreateForexTransaction this$forex1 = this.forex1;
        CreateForexTransaction other$forex1 = other.forex1;
        if (this$forex1 == null ? other$forex1 != null : !((Object)this$forex1).equals(other$forex1)) {
            return false;
        }
        CreateForexTransaction this$forex2 = this.forex2;
        CreateForexTransaction other$forex2 = other.forex2;
        if (this$forex2 == null ? other$forex2 != null : !((Object)this$forex2).equals(other$forex2)) {
            return false;
        }
        AdditionalDataForCurrencySwap this$swapAdditions = this.swapAdditions;
        AdditionalDataForCurrencySwap other$swapAdditions = other.swapAdditions;
        if (this$swapAdditions == null ? other$swapAdditions != null : !((Object)this$swapAdditions).equals(other$swapAdditions)) {
            return false;
        }
        ForeignExchangeCreateswapFtrStructureForCreatingTransactions this$generalContractData2 = this.generalContractData2;
        ForeignExchangeCreateswapFtrStructureForCreatingTransactions other$generalContractData2 = other.generalContractData2;
        if (this$generalContractData2 == null ? other$generalContractData2 != null : !((Object)this$generalContractData2).equals(other$generalContractData2)) {
            return false;
        }
        FtrStructureForCreatingTransactions this$generalContractData1 = this.generalContractData1;
        FtrStructureForCreatingTransactions other$generalContractData1 = other.generalContractData1;
        if (this$generalContractData1 == null ? other$generalContractData1 != null : !((Object)this$generalContractData1).equals(other$generalContractData1)) {
            return false;
        }
        ErpBoolean this$testRun = this.testRun;
        ErpBoolean other$testRun = other.testRun;
        if (this$testRun == null ? other$testRun != null : !this$testRun.equals(other$testRun)) {
            return false;
        }
        TransactionActivityCategory this$activityCategory = this.activityCategory;
        TransactionActivityCategory other$activityCategory = other.activityCategory;
        if (this$activityCategory == null ? other$activityCategory != null : !((Object)((Object)this$activityCategory)).equals((Object)other$activityCategory)) {
            return false;
        }
        FtrStructureForReferencedTransactions this$swapContractData = this.swapContractData;
        FtrStructureForReferencedTransactions other$swapContractData = other.swapContractData;
        return !(this$swapContractData == null ? other$swapContractData != null : !((Object)this$swapContractData).equals(other$swapContractData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultForeignExchangeCreateSwapFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CreateForexTransaction $forex1 = this.forex1;
        result = result * 59 + ($forex1 == null ? 43 : ((Object)$forex1).hashCode());
        CreateForexTransaction $forex2 = this.forex2;
        result = result * 59 + ($forex2 == null ? 43 : ((Object)$forex2).hashCode());
        AdditionalDataForCurrencySwap $swapAdditions = this.swapAdditions;
        result = result * 59 + ($swapAdditions == null ? 43 : ((Object)$swapAdditions).hashCode());
        ForeignExchangeCreateswapFtrStructureForCreatingTransactions $generalContractData2 = this.generalContractData2;
        result = result * 59 + ($generalContractData2 == null ? 43 : ((Object)$generalContractData2).hashCode());
        FtrStructureForCreatingTransactions $generalContractData1 = this.generalContractData1;
        result = result * 59 + ($generalContractData1 == null ? 43 : ((Object)$generalContractData1).hashCode());
        ErpBoolean $testRun = this.testRun;
        result = result * 59 + ($testRun == null ? 43 : $testRun.hashCode());
        TransactionActivityCategory $activityCategory = this.activityCategory;
        result = result * 59 + ($activityCategory == null ? 43 : ((Object)((Object)$activityCategory)).hashCode());
        FtrStructureForReferencedTransactions $swapContractData = this.swapContractData;
        result = result * 59 + ($swapContractData == null ? 43 : ((Object)$swapContractData).hashCode());
        return result;
    }

    public DefaultForeignExchangeCreateSwapFunction(CreateForexTransaction forex1, CreateForexTransaction forex2, AdditionalDataForCurrencySwap swapAdditions, ForeignExchangeCreateswapFtrStructureForCreatingTransactions generalContractData2, FtrStructureForCreatingTransactions generalContractData1) {
        this.forex1 = forex1;
        this.forex2 = forex2;
        this.swapAdditions = swapAdditions;
        this.generalContractData2 = generalContractData2;
        this.generalContractData1 = generalContractData1;
    }

    @Override
    public DefaultForeignExchangeCreateSwapFunction testRun(ErpBoolean testRun) {
        this.testRun = testRun;
        return this;
    }

    @Override
    public DefaultForeignExchangeCreateSwapFunction activityCategory(TransactionActivityCategory activityCategory) {
        this.activityCategory = activityCategory;
        return this;
    }

    @Override
    public DefaultForeignExchangeCreateSwapFunction swapContractData(FtrStructureForReferencedTransactions swapContractData) {
        this.swapContractData = swapContractData;
        return this;
    }
}

