/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultForeignExchangeDealGetFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.ForeignExchangeDealGetFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.ForeignExchangeDealGetFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForFlow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForPaymentDetail;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.FinancialTransaction;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultForeignExchangeDealGetFunction
implements ForeignExchangeDealGetFunction {
    private final CompanyCode companycode;
    private final FinancialTransaction financialtransaction;
    @Nonnull
    private final Iterable<FtrStructureForPaymentDetail> paymentdetail;
    @Nonnull
    private final Iterable<FtrStructureForFlow> addflow;
    @Nonnull
    private Iterable<RefStructureForParameterExtensioninExtensionout> extensionOut = Lists.newArrayList();

    @Override
    @Nonnull
    public ForeignExchangeDealGetFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultForeignExchangeDealGetFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public ForeignExchangeDealGetFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        TableRow row;
        for (FtrStructureForPaymentDetail ftrStructureForPaymentDetail : this.paymentdetail) {
            ftrStructureForPaymentDetail.validate();
        }
        for (FtrStructureForFlow ftrStructureForFlow : this.addflow) {
            ftrStructureForFlow.validate();
        }
        if (this.extensionOut != null) {
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionOut) {
                refStructureForParameterExtensioninExtensionout.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_FTR_FXT_DEALGET");
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companycode);
        query.withExporting("FINANCIALTRANSACTION", "TB_RFHA", (ErpType)this.financialtransaction);
        if (this.paymentdetail.iterator().hasNext()) {
            Table table = query.withTable("PAYMENTDETAIL", "BAPI_FTR_PAYDET");
            for (FtrStructureForPaymentDetail ftrStructureForPaymentDetail : this.paymentdetail) {
                row = table.row();
                if (ftrStructureForPaymentDetail.getAccountId() != null) {
                    row.field("ACCOUNT_ID", "HKTID", (ErpType)ftrStructureForPaymentDetail.getAccountId());
                }
                if (ftrStructureForPaymentDetail.getAlternativePayerTrans() != null) {
                    row.field("ALTERNATIVE_PAYER_TRANS", "TB_RPZAHLA", (ErpType)ftrStructureForPaymentDetail.getAlternativePayerTrans());
                }
                if (ftrStructureForPaymentDetail.getBankAccount() != null) {
                    row.field("BANK_ACCOUNT", "BANKN", (ErpType)ftrStructureForPaymentDetail.getBankAccount());
                }
                if (ftrStructureForPaymentDetail.getBankAccount2() != null) {
                    row.field("BANK_ACCOUNT_2", "BNKN2_BF", ftrStructureForPaymentDetail.getBankAccount2());
                }
                if (ftrStructureForPaymentDetail.getBankAccountBankref() != null) {
                    row.field("BANK_ACCOUNT_BANKREF", "REFZL", ftrStructureForPaymentDetail.getBankAccountBankref());
                }
                if (ftrStructureForPaymentDetail.getBankAccountBankKey() != null) {
                    row.field("BANK_ACCOUNT_BANK_KEY", "BANKK", (ErpType)ftrStructureForPaymentDetail.getBankAccountBankKey());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCountry() != null) {
                    row.field("BANK_ACCOUNT_COUNTRY", "BANKS", (ErpType)ftrStructureForPaymentDetail.getBankAccountCountry());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCountryIso() != null) {
                    row.field("BANK_ACCOUNT_COUNTRY_ISO", "INTCA", (ErpType)ftrStructureForPaymentDetail.getBankAccountCountryIso());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCurrency() != null) {
                    row.field("BANK_ACCOUNT_CURRENCY", "WAERS", (ErpType)ftrStructureForPaymentDetail.getBankAccountCurrency());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCurrencyIso() != null) {
                    row.field("BANK_ACCOUNT_CURRENCY_ISO", "ISOCD", (ErpType)ftrStructureForPaymentDetail.getBankAccountCurrencyIso());
                }
                if (ftrStructureForPaymentDetail.getBankAccountGlAccount() != null) {
                    row.field("BANK_ACCOUNT_GL_ACCOUNT", "HKONT", (ErpType)ftrStructureForPaymentDetail.getBankAccountGlAccount());
                }
                if (ftrStructureForPaymentDetail.getBankAccountName() != null) {
                    row.field("BANK_ACCOUNT_NAME", "TEXT1", ftrStructureForPaymentDetail.getBankAccountName());
                }
                if (ftrStructureForPaymentDetail.getBankControlKey() != null) {
                    row.field("BANK_CONTROL_KEY", "BKONT", (ErpType)ftrStructureForPaymentDetail.getBankControlKey());
                }
                if (ftrStructureForPaymentDetail.getConsideredPaymntMeth() != null) {
                    row.field("CONSIDERED_PAYMNT_METH", "DZWELS", (ErpType)ftrStructureForPaymentDetail.getConsideredPaymntMeth());
                }
                if (ftrStructureForPaymentDetail.getDetGroupDefinition() != null) {
                    row.field("DET_GROUP_DEFINITION", "TB_SPRGRD", (ErpType)ftrStructureForPaymentDetail.getDetGroupDefinition());
                }
                if (ftrStructureForPaymentDetail.getDirection() != null) {
                    row.field("DIRECTION", "TB_SSIGN", (ErpType)ftrStructureForPaymentDetail.getDirection());
                }
                if (ftrStructureForPaymentDetail.getEffectiveDate() != null) {
                    row.field("EFFECTIVE_DATE", "TB_DZVERB", ftrStructureForPaymentDetail.getEffectiveDate());
                }
                if (ftrStructureForPaymentDetail.getEqualDirection() != null) {
                    row.field("EQUAL_DIRECTION", "TB_SCSPAY", (ErpType)ftrStructureForPaymentDetail.getEqualDirection());
                }
                if (ftrStructureForPaymentDetail.getFlowType() != null) {
                    row.field("FLOW_TYPE", "SBEWART", (ErpType)ftrStructureForPaymentDetail.getFlowType());
                }
                if (ftrStructureForPaymentDetail.getHouseBank() != null) {
                    row.field("HOUSE_BANK", "HBKID", (ErpType)ftrStructureForPaymentDetail.getHouseBank());
                }
                if (ftrStructureForPaymentDetail.getIndividualPayment() != null) {
                    row.field("INDIVIDUAL_PAYMENT", "TB_SPRSNGK", (ErpType)ftrStructureForPaymentDetail.getIndividualPayment());
                }
                if (ftrStructureForPaymentDetail.getPartnerBank() != null) {
                    row.field("PARTNER_BANK", "TB_RPBANK", (ErpType)ftrStructureForPaymentDetail.getPartnerBank());
                }
                if (ftrStructureForPaymentDetail.getPayer() != null) {
                    row.field("PAYER", "TB_RPZAHL_NEW", (ErpType)ftrStructureForPaymentDetail.getPayer());
                }
                if (ftrStructureForPaymentDetail.getPayerTransaction() != null) {
                    row.field("PAYER_TRANSACTION", "TB_RPZAHL_NEW", (ErpType)ftrStructureForPaymentDetail.getPayerTransaction());
                }
                if (ftrStructureForPaymentDetail.getPaymentActivity() != null) {
                    row.field("PAYMENT_ACTIVITY", "TB_SZART", (ErpType)ftrStructureForPaymentDetail.getPaymentActivity());
                }
                if (ftrStructureForPaymentDetail.getPaymentCurrency() != null) {
                    row.field("PAYMENT_CURRENCY", "WAERS", (ErpType)ftrStructureForPaymentDetail.getPaymentCurrency());
                }
                if (ftrStructureForPaymentDetail.getPaymentCurrencyIso() != null) {
                    row.field("PAYMENT_CURRENCY_ISO", "ISOCD", (ErpType)ftrStructureForPaymentDetail.getPaymentCurrencyIso());
                }
                if (ftrStructureForPaymentDetail.getPaymentMethod() != null) {
                    row.field("PAYMENT_METHOD", "DZLSCH", (ErpType)ftrStructureForPaymentDetail.getPaymentMethod());
                }
                if (ftrStructureForPaymentDetail.getPaymentMethodSuppl() != null) {
                    row.field("PAYMENT_METHOD_SUPPL", "UZAWE", (ErpType)ftrStructureForPaymentDetail.getPaymentMethodSuppl());
                }
                if (ftrStructureForPaymentDetail.getPaymentRequest() != null) {
                    row.field("PAYMENT_REQUEST", "TB_SPAYRQK", (ErpType)ftrStructureForPaymentDetail.getPaymentRequest());
                }
                if (ftrStructureForPaymentDetail.getRepetitiveCode() != null) {
                    row.field("REPETITIVE_CODE", "RPCODE", (ErpType)ftrStructureForPaymentDetail.getRepetitiveCode());
                }
                if (ftrStructureForPaymentDetail.getRepetitiveCodeText() != null) {
                    row.field("REPETITIVE_CODE_TEXT", "RPCODE_TEXT", ftrStructureForPaymentDetail.getRepetitiveCodeText());
                }
                if (ftrStructureForPaymentDetail.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)ftrStructureForPaymentDetail.getScbankInd());
                }
                if (ftrStructureForPaymentDetail.getSepaMandateId() != null) {
                    row.field("SEPA_MANDATE_ID", "SEPA_MNDID", (ErpType)ftrStructureForPaymentDetail.getSepaMandateId());
                }
                if (ftrStructureForPaymentDetail.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)ftrStructureForPaymentDetail.getSupcountry());
                }
                if (ftrStructureForPaymentDetail.getTableindex() == null) continue;
                row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureForPaymentDetail.getTableindex());
            }
            table.end();
        }
        if (this.addflow.iterator().hasNext()) {
            Table table = query.withTable("ADDFLOW", "BAPI_FTR_FLOW");
            for (FtrStructureForFlow ftrStructureForFlow : this.addflow) {
                row = table.row();
                if (ftrStructureForFlow.getAssignment() != null) {
                    row.field("ASSIGNMENT", "DZUONR", (ErpType)ftrStructureForFlow.getAssignment());
                }
                if (ftrStructureForFlow.getCalcBaseAmount() != null) {
                    row.field("CALC_BASE_AMOUNT", "BAPIBBASIS", (ErpType)ftrStructureForFlow.getCalcBaseAmount());
                }
                if (ftrStructureForFlow.getCalcBaseAmountChar() != null) {
                    row.field("CALC_BASE_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getCalcBaseAmountChar());
                }
                if (ftrStructureForFlow.getCalcBaseCur() != null) {
                    row.field("CALC_BASE_CUR", "TB_WBASIS", (ErpType)ftrStructureForFlow.getCalcBaseCur());
                }
                if (ftrStructureForFlow.getCalcBaseCurIso() != null) {
                    row.field("CALC_BASE_CUR_ISO", "ISOCD", (ErpType)ftrStructureForFlow.getCalcBaseCurIso());
                }
                if (ftrStructureForFlow.getCalcBaseDays() != null) {
                    row.field("CALC_BASE_DAYS", "ABASTAGE", (ErpType)ftrStructureForFlow.getCalcBaseDays());
                }
                if (ftrStructureForFlow.getCalcDate() != null) {
                    row.field("CALC_DATE", "DVALUT", ftrStructureForFlow.getCalcDate());
                }
                if (ftrStructureForFlow.getCalcFrom() != null) {
                    row.field("CALC_FROM", "DBERVON", ftrStructureForFlow.getCalcFrom());
                }
                if (ftrStructureForFlow.getCalcFromIncl() != null) {
                    row.field("CALC_FROM_INCL", "TB_SINCLV", (ErpType)ftrStructureForFlow.getCalcFromIncl());
                }
                if (ftrStructureForFlow.getCalcFromMonthEnd() != null) {
                    row.field("CALC_FROM_MONTH_END", "VVSULTVON", (ErpType)ftrStructureForFlow.getCalcFromMonthEnd());
                }
                if (ftrStructureForFlow.getCalcTo() != null) {
                    row.field("CALC_TO", "DBERBIS", ftrStructureForFlow.getCalcTo());
                }
                if (ftrStructureForFlow.getCalcToIncl() != null) {
                    row.field("CALC_TO_INCL", "TB_SINCLB", (ErpType)ftrStructureForFlow.getCalcToIncl());
                }
                if (ftrStructureForFlow.getCalcToMonthEnd() != null) {
                    row.field("CALC_TO_MONTH_END", "VVSULTBIS", (ErpType)ftrStructureForFlow.getCalcToMonthEnd());
                }
                if (ftrStructureForFlow.getCurrentRate() != null) {
                    row.field("CURRENT_RATE", "TB_SHWKAKT", (ErpType)ftrStructureForFlow.getCurrentRate());
                }
                if (ftrStructureForFlow.getFixedAmount() != null) {
                    row.field("FIXED_AMOUNT", "TB_SHWBFIX", (ErpType)ftrStructureForFlow.getFixedAmount());
                }
                if (ftrStructureForFlow.getFixedRate() != null) {
                    row.field("FIXED_RATE", "TB_SHWKFIX", (ErpType)ftrStructureForFlow.getFixedRate());
                }
                if (ftrStructureForFlow.getFlowKey() != null) {
                    row.field("FLOW_KEY", "TB_BAPI_FLOW_KEY", (ErpType)ftrStructureForFlow.getFlowKey());
                }
                if (ftrStructureForFlow.getFlowSide() != null) {
                    row.field("FLOW_SIDE", "TB_RKONDGR", (ErpType)ftrStructureForFlow.getFlowSide());
                }
                if (ftrStructureForFlow.getFlowSign() != null) {
                    row.field("FLOW_SIGN", "TB_SSIGN", (ErpType)ftrStructureForFlow.getFlowSign());
                }
                if (ftrStructureForFlow.getFlowType() != null) {
                    row.field("FLOW_TYPE", "TB_SFHAZBA", (ErpType)ftrStructureForFlow.getFlowType());
                }
                if (ftrStructureForFlow.getInterestCalcDays() != null) {
                    row.field("INTEREST_CALC_DAYS", "VVATAGE", (ErpType)ftrStructureForFlow.getInterestCalcDays());
                }
                if (ftrStructureForFlow.getInterestCalcExpon() != null) {
                    row.field("INTEREST_CALC_EXPON", "TB_JZINSRE", (ErpType)ftrStructureForFlow.getInterestCalcExpon());
                }
                if (ftrStructureForFlow.getInterestCalcMethod() != null) {
                    row.field("INTEREST_CALC_METHOD", "SZBMETH", (ErpType)ftrStructureForFlow.getInterestCalcMethod());
                }
                if (ftrStructureForFlow.getInterestCalendar() != null) {
                    row.field("INTEREST_CALENDAR", "TFMSKALIDWT", (ErpType)ftrStructureForFlow.getInterestCalendar());
                }
                if (ftrStructureForFlow.getLocalCurAmount() != null) {
                    row.field("LOCAL_CUR_AMOUNT", "BAPITB_HWBETR", (ErpType)ftrStructureForFlow.getLocalCurAmount());
                }
                if (ftrStructureForFlow.getLocalCurAmountChar() != null) {
                    row.field("LOCAL_CUR_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getLocalCurAmountChar());
                }
                if (ftrStructureForFlow.getLocalCurRate() != null) {
                    row.field("LOCAL_CUR_RATE", "TB_KHWKURS", (ErpType)ftrStructureForFlow.getLocalCurRate());
                }
                if (ftrStructureForFlow.getPaymentAmount() != null) {
                    row.field("PAYMENT_AMOUNT", "BAPITB_BZBETR", (ErpType)ftrStructureForFlow.getPaymentAmount());
                }
                if (ftrStructureForFlow.getPaymentAmountChar() != null) {
                    row.field("PAYMENT_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getPaymentAmountChar());
                }
                if (ftrStructureForFlow.getPaymentCur() != null) {
                    row.field("PAYMENT_CUR", "TB_WZBETR", (ErpType)ftrStructureForFlow.getPaymentCur());
                }
                if (ftrStructureForFlow.getPaymentCurIso() != null) {
                    row.field("PAYMENT_CUR_ISO", "ISOCD", (ErpType)ftrStructureForFlow.getPaymentCurIso());
                }
                if (ftrStructureForFlow.getPaymentDate() != null) {
                    row.field("PAYMENT_DATE", "TB_DZTERM", ftrStructureForFlow.getPaymentDate());
                }
                if (ftrStructureForFlow.getPercentageRate() != null) {
                    row.field("PERCENTAGE_RATE", "PKOND", (ErpType)ftrStructureForFlow.getPercentageRate());
                }
                if (ftrStructureForFlow.getPositionAmount() != null) {
                    row.field("POSITION_AMOUNT", "BAPITB_BBBETR", (ErpType)ftrStructureForFlow.getPositionAmount());
                }
                if (ftrStructureForFlow.getPositionAmountChar() != null) {
                    row.field("POSITION_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getPositionAmountChar());
                }
                if (ftrStructureForFlow.getPostingStatus() != null) {
                    row.field("POSTING_STATUS", "TB_SBEWEBE", (ErpType)ftrStructureForFlow.getPostingStatus());
                }
                if (ftrStructureForFlow.getPosAmountFixed() != null) {
                    row.field("POS_AMOUNT_FIXED", "TB_SBWBFIX", (ErpType)ftrStructureForFlow.getPosAmountFixed());
                }
                if (ftrStructureForFlow.getTableindex() == null) continue;
                row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureForFlow.getTableindex());
            }
            table.end();
        }
        if (this.extensionOut != null && this.extensionOut.iterator().hasNext()) {
            Table table = query.withTable("EXTENSIONOUT", "BAPIPAREX");
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionOut) {
                row = table.row();
                if (refStructureForParameterExtensioninExtensionout.getStructure() != null) {
                    row.field("STRUCTURE", "TE_STRUC", (ErpType)refStructureForParameterExtensioninExtensionout.getStructure());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart1() != null) {
                    row.field("VALUEPART1", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart1());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart2() != null) {
                    row.field("VALUEPART2", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart2());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart3() != null) {
                    row.field("VALUEPART3", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart3());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart4() == null) continue;
                row.field("VALUEPART4", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart4());
            }
            table.end();
        }
        query.withImportingAsReturn("RETURNCOMPANYCODE", "BAPI2042");
        query.withImportingAsReturn("RETURNFINANCIALTRANSACTION", "BAPI2042");
        query.withImportingAsReturn("RETURNFOREX", "BAPI_FTR_GETDETAIL_FXT");
        query.withImportingAsReturn("RETURNGENERALCONTRACTDATA", "BAPI_FTR_GETDETAIL");
        query.withImportingAsReturn("RETURNCASHSETTLEMENT", "BAPI_FTR_CASH_SETTLEMENT");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    @Override
    @Nonnull
    public ForeignExchangeDealGetFunction extensionOut(RefStructureForParameterExtensioninExtensionout ... items) {
        this.extensionOut = Lists.newArrayList((Object[])items);
        return this;
    }

    public String toString() {
        return "DefaultForeignExchangeDealGetFunction(companycode=" + (Object)((Object)this.companycode) + ", financialtransaction=" + (Object)((Object)this.financialtransaction) + ", paymentdetail=" + this.paymentdetail + ", addflow=" + this.addflow + ", extensionOut=" + this.extensionOut + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultForeignExchangeDealGetFunction)) {
            return false;
        }
        DefaultForeignExchangeDealGetFunction other = (DefaultForeignExchangeDealGetFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompanyCode this$companycode = this.companycode;
        CompanyCode other$companycode = other.companycode;
        if (this$companycode == null ? other$companycode != null : !((Object)((Object)this$companycode)).equals((Object)other$companycode)) {
            return false;
        }
        FinancialTransaction this$financialtransaction = this.financialtransaction;
        FinancialTransaction other$financialtransaction = other.financialtransaction;
        if (this$financialtransaction == null ? other$financialtransaction != null : !((Object)((Object)this$financialtransaction)).equals((Object)other$financialtransaction)) {
            return false;
        }
        Iterable<FtrStructureForPaymentDetail> this$paymentdetail = this.paymentdetail;
        Iterable<FtrStructureForPaymentDetail> other$paymentdetail = other.paymentdetail;
        if (this$paymentdetail == null ? other$paymentdetail != null : !this$paymentdetail.equals(other$paymentdetail)) {
            return false;
        }
        Iterable<FtrStructureForFlow> this$addflow = this.addflow;
        Iterable<FtrStructureForFlow> other$addflow = other.addflow;
        if (this$addflow == null ? other$addflow != null : !this$addflow.equals(other$addflow)) {
            return false;
        }
        Iterable<RefStructureForParameterExtensioninExtensionout> this$extensionOut = this.extensionOut;
        Iterable<RefStructureForParameterExtensioninExtensionout> other$extensionOut = other.extensionOut;
        return !(this$extensionOut == null ? other$extensionOut != null : !this$extensionOut.equals(other$extensionOut));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultForeignExchangeDealGetFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompanyCode $companycode = this.companycode;
        result = result * 59 + ($companycode == null ? 43 : ((Object)((Object)$companycode)).hashCode());
        FinancialTransaction $financialtransaction = this.financialtransaction;
        result = result * 59 + ($financialtransaction == null ? 43 : ((Object)((Object)$financialtransaction)).hashCode());
        Iterable<FtrStructureForPaymentDetail> $paymentdetail = this.paymentdetail;
        result = result * 59 + ($paymentdetail == null ? 43 : $paymentdetail.hashCode());
        Iterable<FtrStructureForFlow> $addflow = this.addflow;
        result = result * 59 + ($addflow == null ? 43 : $addflow.hashCode());
        Iterable<RefStructureForParameterExtensioninExtensionout> $extensionOut = this.extensionOut;
        result = result * 59 + ($extensionOut == null ? 43 : $extensionOut.hashCode());
        return result;
    }

    public DefaultForeignExchangeDealGetFunction(CompanyCode companycode, FinancialTransaction financialtransaction, @Nonnull Iterable<FtrStructureForPaymentDetail> paymentdetail, @Nonnull Iterable<FtrStructureForFlow> addflow) {
        if (paymentdetail == null) {
            throw new NullPointerException("paymentdetail is marked @NonNull but is null");
        }
        if (addflow == null) {
            throw new NullPointerException("addflow is marked @NonNull but is null");
        }
        this.companycode = companycode;
        this.financialtransaction = financialtransaction;
        this.paymentdetail = paymentdetail;
        this.addflow = addflow;
    }

    @Override
    public DefaultForeignExchangeDealGetFunction extensionOut(@Nonnull Iterable<RefStructureForParameterExtensioninExtensionout> extensionOut) {
        if (extensionOut == null) {
            throw new NullPointerException("extensionOut is marked @NonNull but is null");
        }
        this.extensionOut = extensionOut;
        return this;
    }
}

