/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.functions;

import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultFxOptionGetDetailFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FxOptionGetDetailFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.FxOptionGetDetailFunctionResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.FinancialTransaction;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import javax.annotation.Nonnull;

public class DefaultFxOptionGetDetailFunction
implements FxOptionGetDetailFunction {
    private final CompanyCode companycode;
    private final FinancialTransaction financialtransaction;

    @Override
    @Nonnull
    public FxOptionGetDetailFunctionResult execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = this.toQuery();
        BapiQueryResult queryResult = query.execute(erpConfigContext);
        return new DefaultFxOptionGetDetailFunctionResult(queryResult);
    }

    @Override
    @Nonnull
    public FxOptionGetDetailFunctionResult execute() throws QueryExecutionException {
        return this.execute(new ErpConfigContext());
    }

    @Override
    @Nonnull
    public BapiQuery toQuery() {
        BapiQuery query = new BapiQuery("BAPI_FTR_FXOPTION_GETDETAIL");
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companycode);
        query.withExporting("FINANCIALTRANSACTION", "TB_RFHA", (ErpType)this.financialtransaction);
        query.withImportingAsReturn("RETURNFOREX", "BAPI_FTR_GETDETAIL_FXOPTION");
        query.withImportingAsReturn("RETURNGENERALCONTRACTDATA", "BAPI_FTR_GETDETAIL");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        return query;
    }

    public String toString() {
        return "DefaultFxOptionGetDetailFunction(companycode=" + (Object)((Object)this.companycode) + ", financialtransaction=" + (Object)((Object)this.financialtransaction) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultFxOptionGetDetailFunction)) {
            return false;
        }
        DefaultFxOptionGetDetailFunction other = (DefaultFxOptionGetDetailFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompanyCode this$companycode = this.companycode;
        CompanyCode other$companycode = other.companycode;
        if (this$companycode == null ? other$companycode != null : !((Object)((Object)this$companycode)).equals((Object)other$companycode)) {
            return false;
        }
        FinancialTransaction this$financialtransaction = this.financialtransaction;
        FinancialTransaction other$financialtransaction = other.financialtransaction;
        return !(this$financialtransaction == null ? other$financialtransaction != null : !((Object)((Object)this$financialtransaction)).equals((Object)other$financialtransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultFxOptionGetDetailFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompanyCode $companycode = this.companycode;
        result = result * 59 + ($companycode == null ? 43 : ((Object)((Object)$companycode)).hashCode());
        FinancialTransaction $financialtransaction = this.financialtransaction;
        result = result * 59 + ($financialtransaction == null ? 43 : ((Object)((Object)$financialtransaction)).hashCode());
        return result;
    }

    public DefaultFxOptionGetDetailFunction(CompanyCode companycode, FinancialTransaction financialtransaction) {
        this.companycode = companycode;
        this.financialtransaction = financialtransaction;
    }
}

