/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngDocumentCheckFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.AcctngDocumentPostFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultAcctngDocumentCheckFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.functions.DefaultAcctngDocumentPostFunction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.services.AccountingDocumentService;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CurrencyItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.Header;
import javax.annotation.Nonnull;
import javax.inject.Named;

@Named
public class DefaultAccountingDocumentService
implements AccountingDocumentService {
    @Override
    public AcctngDocumentCheckFunction check(@Nonnull Header documentHeader) {
        return new DefaultAcctngDocumentCheckFunction(documentHeader);
    }

    @Override
    public AcctngDocumentPostFunction post(@Nonnull Header documentHeader, @Nonnull Iterable<CurrencyItem> currencyAmount) {
        return new DefaultAcctngDocumentPostFunction(documentHeader, currencyAmount);
    }

    @Override
    public AcctngDocumentPostFunction post(@Nonnull Header documentHeader, CurrencyItem ... currencyAmount) {
        if (currencyAmount.length < 1) {
            throw new IllegalArgumentException("Parameter \"currencyAmount\" needs to have at least one value.");
        }
        return new DefaultAcctngDocumentPostFunction(documentHeader, Lists.newArrayList((Object[])currencyAmount));
    }
}

