/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.structures;

import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.AssetInsuranceType;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.BaseInsurableValue;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CurrencyKey;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CurrentInsurableValue;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.InsuranceCompanies;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.InsuranceIndexSeries;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.InsuranceRateFiAa;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.IsoCodeCurrency;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.ManualInsurableValue;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.time.LocalDate;
import javax.annotation.Nullable;

public class FixedAssetInsurance {
    @ElementName(value="BASE_VALUE")
    @Nullable
    private BaseInsurableValue baseValue;
    @ElementName(value="BASE_VAL_MAN_UPD")
    @Nullable
    private ErpBoolean baseValManUpd;
    @ElementName(value="COMPANY")
    @Nullable
    private InsuranceCompanies company;
    @ElementName(value="CURRENCY")
    @Nullable
    private CurrencyKey currency;
    @ElementName(value="CURRENCY_ISO")
    @Nullable
    private IsoCodeCurrency currencyIso;
    @ElementName(value="CUR_INS_VALUE")
    @Nullable
    private CurrentInsurableValue curInsValue;
    @ElementName(value="CUR_INS_VALUE_MAINT_YR")
    @Nullable
    private Year curInsValueMaintYr;
    @ElementName(value="INDEX")
    @Nullable
    private InsuranceIndexSeries index;
    @ElementName(value="MAN_INS_VAL")
    @Nullable
    private ManualInsurableValue manInsVal;
    @ElementName(value="MAN_INS_VAL_MAINT_YR")
    @Nullable
    private Year manInsValMaintYr;
    @ElementName(value="POLICY_NO")
    @Nullable
    private String policyNo;
    @ElementName(value="PREMIUM")
    @Nullable
    private InsuranceRateFiAa premium;
    @ElementName(value="START_DATE")
    @Nullable
    private LocalDate startDate;
    @ElementName(value="TEXT")
    @Nullable
    private String text;
    @ElementName(value="TYPE")
    @Nullable
    private AssetInsuranceType type;

    public void validate() throws IllegalArgumentException {
        if (this.policyNo != null && this.policyNo.length() > 15) {
            throw new IllegalArgumentException("Bapi method parameter \"policyNo\" contains an invalid structure. Structure attribute \"POLICY_NO\" / Function parameter \"policyNo\" must have at most 15 characters. The given value is too long.");
        }
        if (this.text != null && this.text.length() > 50) {
            throw new IllegalArgumentException("Bapi method parameter \"text\" contains an invalid structure. Structure attribute \"TEXT\" / Function parameter \"text\" must have at most 50 characters. The given value is too long.");
        }
    }

    FixedAssetInsurance(@Nullable BaseInsurableValue baseValue, @Nullable ErpBoolean baseValManUpd, @Nullable InsuranceCompanies company, @Nullable CurrencyKey currency, @Nullable IsoCodeCurrency currencyIso, @Nullable CurrentInsurableValue curInsValue, @Nullable Year curInsValueMaintYr, @Nullable InsuranceIndexSeries index, @Nullable ManualInsurableValue manInsVal, @Nullable Year manInsValMaintYr, @Nullable String policyNo, @Nullable InsuranceRateFiAa premium, @Nullable LocalDate startDate, @Nullable String text, @Nullable AssetInsuranceType type) {
        this.baseValue = baseValue;
        this.baseValManUpd = baseValManUpd;
        this.company = company;
        this.currency = currency;
        this.currencyIso = currencyIso;
        this.curInsValue = curInsValue;
        this.curInsValueMaintYr = curInsValueMaintYr;
        this.index = index;
        this.manInsVal = manInsVal;
        this.manInsValMaintYr = manInsValMaintYr;
        this.policyNo = policyNo;
        this.premium = premium;
        this.startDate = startDate;
        this.text = text;
        this.type = type;
    }

    public static FixedAssetInsuranceBuilder builder() {
        return new FixedAssetInsuranceBuilder();
    }

    @Nullable
    public BaseInsurableValue getBaseValue() {
        return this.baseValue;
    }

    @Nullable
    public ErpBoolean getBaseValManUpd() {
        return this.baseValManUpd;
    }

    @Nullable
    public InsuranceCompanies getCompany() {
        return this.company;
    }

    @Nullable
    public CurrencyKey getCurrency() {
        return this.currency;
    }

    @Nullable
    public IsoCodeCurrency getCurrencyIso() {
        return this.currencyIso;
    }

    @Nullable
    public CurrentInsurableValue getCurInsValue() {
        return this.curInsValue;
    }

    @Nullable
    public Year getCurInsValueMaintYr() {
        return this.curInsValueMaintYr;
    }

    @Nullable
    public InsuranceIndexSeries getIndex() {
        return this.index;
    }

    @Nullable
    public ManualInsurableValue getManInsVal() {
        return this.manInsVal;
    }

    @Nullable
    public Year getManInsValMaintYr() {
        return this.manInsValMaintYr;
    }

    @Nullable
    public String getPolicyNo() {
        return this.policyNo;
    }

    @Nullable
    public InsuranceRateFiAa getPremium() {
        return this.premium;
    }

    @Nullable
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public AssetInsuranceType getType() {
        return this.type;
    }

    public void setBaseValue(@Nullable BaseInsurableValue baseValue) {
        this.baseValue = baseValue;
    }

    public void setBaseValManUpd(@Nullable ErpBoolean baseValManUpd) {
        this.baseValManUpd = baseValManUpd;
    }

    public void setCompany(@Nullable InsuranceCompanies company) {
        this.company = company;
    }

    public void setCurrency(@Nullable CurrencyKey currency) {
        this.currency = currency;
    }

    public void setCurrencyIso(@Nullable IsoCodeCurrency currencyIso) {
        this.currencyIso = currencyIso;
    }

    public void setCurInsValue(@Nullable CurrentInsurableValue curInsValue) {
        this.curInsValue = curInsValue;
    }

    public void setCurInsValueMaintYr(@Nullable Year curInsValueMaintYr) {
        this.curInsValueMaintYr = curInsValueMaintYr;
    }

    public void setIndex(@Nullable InsuranceIndexSeries index) {
        this.index = index;
    }

    public void setManInsVal(@Nullable ManualInsurableValue manInsVal) {
        this.manInsVal = manInsVal;
    }

    public void setManInsValMaintYr(@Nullable Year manInsValMaintYr) {
        this.manInsValMaintYr = manInsValMaintYr;
    }

    public void setPolicyNo(@Nullable String policyNo) {
        this.policyNo = policyNo;
    }

    public void setPremium(@Nullable InsuranceRateFiAa premium) {
        this.premium = premium;
    }

    public void setStartDate(@Nullable LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setText(@Nullable String text) {
        this.text = text;
    }

    public void setType(@Nullable AssetInsuranceType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedAssetInsurance)) {
            return false;
        }
        FixedAssetInsurance other = (FixedAssetInsurance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseInsurableValue this$baseValue = this.getBaseValue();
        BaseInsurableValue other$baseValue = other.getBaseValue();
        if (this$baseValue == null ? other$baseValue != null : !((Object)((Object)this$baseValue)).equals((Object)other$baseValue)) {
            return false;
        }
        ErpBoolean this$baseValManUpd = this.getBaseValManUpd();
        ErpBoolean other$baseValManUpd = other.getBaseValManUpd();
        if (this$baseValManUpd == null ? other$baseValManUpd != null : !this$baseValManUpd.equals(other$baseValManUpd)) {
            return false;
        }
        InsuranceCompanies this$company = this.getCompany();
        InsuranceCompanies other$company = other.getCompany();
        if (this$company == null ? other$company != null : !((Object)((Object)this$company)).equals((Object)other$company)) {
            return false;
        }
        CurrencyKey this$currency = this.getCurrency();
        CurrencyKey other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        IsoCodeCurrency this$currencyIso = this.getCurrencyIso();
        IsoCodeCurrency other$currencyIso = other.getCurrencyIso();
        if (this$currencyIso == null ? other$currencyIso != null : !((Object)((Object)this$currencyIso)).equals((Object)other$currencyIso)) {
            return false;
        }
        CurrentInsurableValue this$curInsValue = this.getCurInsValue();
        CurrentInsurableValue other$curInsValue = other.getCurInsValue();
        if (this$curInsValue == null ? other$curInsValue != null : !((Object)((Object)this$curInsValue)).equals((Object)other$curInsValue)) {
            return false;
        }
        Year this$curInsValueMaintYr = this.getCurInsValueMaintYr();
        Year other$curInsValueMaintYr = other.getCurInsValueMaintYr();
        if (this$curInsValueMaintYr == null ? other$curInsValueMaintYr != null : !this$curInsValueMaintYr.equals(other$curInsValueMaintYr)) {
            return false;
        }
        InsuranceIndexSeries this$index = this.getIndex();
        InsuranceIndexSeries other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)((Object)this$index)).equals((Object)other$index)) {
            return false;
        }
        ManualInsurableValue this$manInsVal = this.getManInsVal();
        ManualInsurableValue other$manInsVal = other.getManInsVal();
        if (this$manInsVal == null ? other$manInsVal != null : !((Object)((Object)this$manInsVal)).equals((Object)other$manInsVal)) {
            return false;
        }
        Year this$manInsValMaintYr = this.getManInsValMaintYr();
        Year other$manInsValMaintYr = other.getManInsValMaintYr();
        if (this$manInsValMaintYr == null ? other$manInsValMaintYr != null : !this$manInsValMaintYr.equals(other$manInsValMaintYr)) {
            return false;
        }
        String this$policyNo = this.getPolicyNo();
        String other$policyNo = other.getPolicyNo();
        if (this$policyNo == null ? other$policyNo != null : !this$policyNo.equals(other$policyNo)) {
            return false;
        }
        InsuranceRateFiAa this$premium = this.getPremium();
        InsuranceRateFiAa other$premium = other.getPremium();
        if (this$premium == null ? other$premium != null : !((Object)((Object)this$premium)).equals((Object)other$premium)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        AssetInsuranceType this$type = this.getType();
        AssetInsuranceType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedAssetInsurance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseInsurableValue $baseValue = this.getBaseValue();
        result = result * 59 + ($baseValue == null ? 43 : ((Object)((Object)$baseValue)).hashCode());
        ErpBoolean $baseValManUpd = this.getBaseValManUpd();
        result = result * 59 + ($baseValManUpd == null ? 43 : $baseValManUpd.hashCode());
        InsuranceCompanies $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : ((Object)((Object)$company)).hashCode());
        CurrencyKey $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        IsoCodeCurrency $currencyIso = this.getCurrencyIso();
        result = result * 59 + ($currencyIso == null ? 43 : ((Object)((Object)$currencyIso)).hashCode());
        CurrentInsurableValue $curInsValue = this.getCurInsValue();
        result = result * 59 + ($curInsValue == null ? 43 : ((Object)((Object)$curInsValue)).hashCode());
        Year $curInsValueMaintYr = this.getCurInsValueMaintYr();
        result = result * 59 + ($curInsValueMaintYr == null ? 43 : $curInsValueMaintYr.hashCode());
        InsuranceIndexSeries $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)((Object)$index)).hashCode());
        ManualInsurableValue $manInsVal = this.getManInsVal();
        result = result * 59 + ($manInsVal == null ? 43 : ((Object)((Object)$manInsVal)).hashCode());
        Year $manInsValMaintYr = this.getManInsValMaintYr();
        result = result * 59 + ($manInsValMaintYr == null ? 43 : $manInsValMaintYr.hashCode());
        String $policyNo = this.getPolicyNo();
        result = result * 59 + ($policyNo == null ? 43 : $policyNo.hashCode());
        InsuranceRateFiAa $premium = this.getPremium();
        result = result * 59 + ($premium == null ? 43 : ((Object)((Object)$premium)).hashCode());
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        AssetInsuranceType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "FixedAssetInsurance(baseValue=" + (Object)((Object)this.getBaseValue()) + ", baseValManUpd=" + this.getBaseValManUpd() + ", company=" + (Object)((Object)this.getCompany()) + ", currency=" + (Object)((Object)this.getCurrency()) + ", currencyIso=" + (Object)((Object)this.getCurrencyIso()) + ", curInsValue=" + (Object)((Object)this.getCurInsValue()) + ", curInsValueMaintYr=" + this.getCurInsValueMaintYr() + ", index=" + (Object)((Object)this.getIndex()) + ", manInsVal=" + (Object)((Object)this.getManInsVal()) + ", manInsValMaintYr=" + this.getManInsValMaintYr() + ", policyNo=" + this.getPolicyNo() + ", premium=" + (Object)((Object)this.getPremium()) + ", startDate=" + this.getStartDate() + ", text=" + this.getText() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    public static class FixedAssetInsuranceBuilder {
        private BaseInsurableValue baseValue;
        private ErpBoolean baseValManUpd;
        private InsuranceCompanies company;
        private CurrencyKey currency;
        private IsoCodeCurrency currencyIso;
        private CurrentInsurableValue curInsValue;
        private Year curInsValueMaintYr;
        private InsuranceIndexSeries index;
        private ManualInsurableValue manInsVal;
        private Year manInsValMaintYr;
        private String policyNo;
        private InsuranceRateFiAa premium;
        private LocalDate startDate;
        private String text;
        private AssetInsuranceType type;

        FixedAssetInsuranceBuilder() {
        }

        public FixedAssetInsuranceBuilder baseValue(BaseInsurableValue baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public FixedAssetInsuranceBuilder baseValManUpd(ErpBoolean baseValManUpd) {
            this.baseValManUpd = baseValManUpd;
            return this;
        }

        public FixedAssetInsuranceBuilder company(InsuranceCompanies company) {
            this.company = company;
            return this;
        }

        public FixedAssetInsuranceBuilder currency(CurrencyKey currency) {
            this.currency = currency;
            return this;
        }

        public FixedAssetInsuranceBuilder currencyIso(IsoCodeCurrency currencyIso) {
            this.currencyIso = currencyIso;
            return this;
        }

        public FixedAssetInsuranceBuilder curInsValue(CurrentInsurableValue curInsValue) {
            this.curInsValue = curInsValue;
            return this;
        }

        public FixedAssetInsuranceBuilder curInsValueMaintYr(Year curInsValueMaintYr) {
            this.curInsValueMaintYr = curInsValueMaintYr;
            return this;
        }

        public FixedAssetInsuranceBuilder index(InsuranceIndexSeries index) {
            this.index = index;
            return this;
        }

        public FixedAssetInsuranceBuilder manInsVal(ManualInsurableValue manInsVal) {
            this.manInsVal = manInsVal;
            return this;
        }

        public FixedAssetInsuranceBuilder manInsValMaintYr(Year manInsValMaintYr) {
            this.manInsValMaintYr = manInsValMaintYr;
            return this;
        }

        public FixedAssetInsuranceBuilder policyNo(String policyNo) {
            this.policyNo = policyNo;
            return this;
        }

        public FixedAssetInsuranceBuilder premium(InsuranceRateFiAa premium) {
            this.premium = premium;
            return this;
        }

        public FixedAssetInsuranceBuilder startDate(LocalDate startDate) {
            this.startDate = startDate;
            return this;
        }

        public FixedAssetInsuranceBuilder text(String text) {
            this.text = text;
            return this;
        }

        public FixedAssetInsuranceBuilder type(AssetInsuranceType type) {
            this.type = type;
            return this;
        }

        public FixedAssetInsurance build() {
            return new FixedAssetInsurance(this.baseValue, this.baseValManUpd, this.company, this.currency, this.currencyIso, this.curInsValue, this.curInsValueMaintYr, this.index, this.manInsVal, this.manInsValMaintYr, this.policyNo, this.premium, this.startDate, this.text, this.type);
        }

        public String toString() {
            return "FixedAssetInsurance.FixedAssetInsuranceBuilder(baseValue=" + (Object)((Object)this.baseValue) + ", baseValManUpd=" + this.baseValManUpd + ", company=" + (Object)((Object)this.company) + ", currency=" + (Object)((Object)this.currency) + ", currencyIso=" + (Object)((Object)this.currencyIso) + ", curInsValue=" + (Object)((Object)this.curInsValue) + ", curInsValueMaintYr=" + this.curInsValueMaintYr + ", index=" + (Object)((Object)this.index) + ", manInsVal=" + (Object)((Object)this.manInsVal) + ", manInsValMaintYr=" + this.manInsValMaintYr + ", policyNo=" + this.policyNo + ", premium=" + (Object)((Object)this.premium) + ", startDate=" + this.startDate + ", text=" + this.text + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

