/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.structures;

import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.AreaUnit;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.BaseUnitOfMeasureInIsoCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.LandRegisterEntrySequenceNumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.LandRegisterPage;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.LandRegisterVolume;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.SurfaceArea;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TaxNumberOfTheNoticeOfAssessment;
import java.time.LocalDate;
import javax.annotation.Nullable;

public class FixedAssetRealEstateAndSimilarRights {
    @ElementName(value="AREA")
    @Nullable
    private SurfaceArea area;
    @ElementName(value="AREA_UOM")
    @Nullable
    private AreaUnit areaUom;
    @ElementName(value="AREA_UOM_ISO")
    @Nullable
    private BaseUnitOfMeasureInIsoCode areaUomIso;
    @ElementName(value="ASSESSMENT_NOTICE_DATE")
    @Nullable
    private LocalDate assessmentNoticeDate;
    @ElementName(value="CONVEYANCE_DATE")
    @Nullable
    private LocalDate conveyanceDate;
    @ElementName(value="LNDREG_DATE")
    @Nullable
    private LocalDate lndregDate;
    @ElementName(value="LNDREG_ENTRY_DATE")
    @Nullable
    private LocalDate lndregEntryDate;
    @ElementName(value="LNDREG_MAP_NO")
    @Nullable
    private String lndregMapNo;
    @ElementName(value="LNDREG_NO")
    @Nullable
    private LandRegisterEntrySequenceNumber lndregNo;
    @ElementName(value="LNDREG_PG")
    @Nullable
    private LandRegisterPage lndregPg;
    @ElementName(value="LNDREG_PLOT_NO")
    @Nullable
    private String lndregPlotNo;
    @ElementName(value="LNDREG_VOL")
    @Nullable
    private LandRegisterVolume lndregVol;
    @ElementName(value="MUNICIPALITY")
    @Nullable
    private String municipality;
    @ElementName(value="TAX_NO")
    @Nullable
    private TaxNumberOfTheNoticeOfAssessment taxNo;
    @ElementName(value="TAX_OFFICE")
    @Nullable
    private String taxOffice;

    public void validate() throws IllegalArgumentException {
        if (this.lndregMapNo != null && this.lndregMapNo.length() > 4) {
            throw new IllegalArgumentException("Bapi method parameter \"lndregMapNo\" contains an invalid structure. Structure attribute \"LNDREG_MAP_NO\" / Function parameter \"lndregMapNo\" must have at most 4 characters. The given value is too long.");
        }
        if (this.lndregPlotNo != null && this.lndregPlotNo.length() > 10) {
            throw new IllegalArgumentException("Bapi method parameter \"lndregPlotNo\" contains an invalid structure. Structure attribute \"LNDREG_PLOT_NO\" / Function parameter \"lndregPlotNo\" must have at most 10 characters. The given value is too long.");
        }
        if (this.municipality != null && this.municipality.length() > 25) {
            throw new IllegalArgumentException("Bapi method parameter \"municipality\" contains an invalid structure. Structure attribute \"MUNICIPALITY\" / Function parameter \"municipality\" must have at most 25 characters. The given value is too long.");
        }
        if (this.taxOffice != null && this.taxOffice.length() > 25) {
            throw new IllegalArgumentException("Bapi method parameter \"taxOffice\" contains an invalid structure. Structure attribute \"TAX_OFFICE\" / Function parameter \"taxOffice\" must have at most 25 characters. The given value is too long.");
        }
    }

    FixedAssetRealEstateAndSimilarRights(@Nullable SurfaceArea area, @Nullable AreaUnit areaUom, @Nullable BaseUnitOfMeasureInIsoCode areaUomIso, @Nullable LocalDate assessmentNoticeDate, @Nullable LocalDate conveyanceDate, @Nullable LocalDate lndregDate, @Nullable LocalDate lndregEntryDate, @Nullable String lndregMapNo, @Nullable LandRegisterEntrySequenceNumber lndregNo, @Nullable LandRegisterPage lndregPg, @Nullable String lndregPlotNo, @Nullable LandRegisterVolume lndregVol, @Nullable String municipality, @Nullable TaxNumberOfTheNoticeOfAssessment taxNo, @Nullable String taxOffice) {
        this.area = area;
        this.areaUom = areaUom;
        this.areaUomIso = areaUomIso;
        this.assessmentNoticeDate = assessmentNoticeDate;
        this.conveyanceDate = conveyanceDate;
        this.lndregDate = lndregDate;
        this.lndregEntryDate = lndregEntryDate;
        this.lndregMapNo = lndregMapNo;
        this.lndregNo = lndregNo;
        this.lndregPg = lndregPg;
        this.lndregPlotNo = lndregPlotNo;
        this.lndregVol = lndregVol;
        this.municipality = municipality;
        this.taxNo = taxNo;
        this.taxOffice = taxOffice;
    }

    public static FixedAssetRealEstateAndSimilarRightsBuilder builder() {
        return new FixedAssetRealEstateAndSimilarRightsBuilder();
    }

    @Nullable
    public SurfaceArea getArea() {
        return this.area;
    }

    @Nullable
    public AreaUnit getAreaUom() {
        return this.areaUom;
    }

    @Nullable
    public BaseUnitOfMeasureInIsoCode getAreaUomIso() {
        return this.areaUomIso;
    }

    @Nullable
    public LocalDate getAssessmentNoticeDate() {
        return this.assessmentNoticeDate;
    }

    @Nullable
    public LocalDate getConveyanceDate() {
        return this.conveyanceDate;
    }

    @Nullable
    public LocalDate getLndregDate() {
        return this.lndregDate;
    }

    @Nullable
    public LocalDate getLndregEntryDate() {
        return this.lndregEntryDate;
    }

    @Nullable
    public String getLndregMapNo() {
        return this.lndregMapNo;
    }

    @Nullable
    public LandRegisterEntrySequenceNumber getLndregNo() {
        return this.lndregNo;
    }

    @Nullable
    public LandRegisterPage getLndregPg() {
        return this.lndregPg;
    }

    @Nullable
    public String getLndregPlotNo() {
        return this.lndregPlotNo;
    }

    @Nullable
    public LandRegisterVolume getLndregVol() {
        return this.lndregVol;
    }

    @Nullable
    public String getMunicipality() {
        return this.municipality;
    }

    @Nullable
    public TaxNumberOfTheNoticeOfAssessment getTaxNo() {
        return this.taxNo;
    }

    @Nullable
    public String getTaxOffice() {
        return this.taxOffice;
    }

    public void setArea(@Nullable SurfaceArea area) {
        this.area = area;
    }

    public void setAreaUom(@Nullable AreaUnit areaUom) {
        this.areaUom = areaUom;
    }

    public void setAreaUomIso(@Nullable BaseUnitOfMeasureInIsoCode areaUomIso) {
        this.areaUomIso = areaUomIso;
    }

    public void setAssessmentNoticeDate(@Nullable LocalDate assessmentNoticeDate) {
        this.assessmentNoticeDate = assessmentNoticeDate;
    }

    public void setConveyanceDate(@Nullable LocalDate conveyanceDate) {
        this.conveyanceDate = conveyanceDate;
    }

    public void setLndregDate(@Nullable LocalDate lndregDate) {
        this.lndregDate = lndregDate;
    }

    public void setLndregEntryDate(@Nullable LocalDate lndregEntryDate) {
        this.lndregEntryDate = lndregEntryDate;
    }

    public void setLndregMapNo(@Nullable String lndregMapNo) {
        this.lndregMapNo = lndregMapNo;
    }

    public void setLndregNo(@Nullable LandRegisterEntrySequenceNumber lndregNo) {
        this.lndregNo = lndregNo;
    }

    public void setLndregPg(@Nullable LandRegisterPage lndregPg) {
        this.lndregPg = lndregPg;
    }

    public void setLndregPlotNo(@Nullable String lndregPlotNo) {
        this.lndregPlotNo = lndregPlotNo;
    }

    public void setLndregVol(@Nullable LandRegisterVolume lndregVol) {
        this.lndregVol = lndregVol;
    }

    public void setMunicipality(@Nullable String municipality) {
        this.municipality = municipality;
    }

    public void setTaxNo(@Nullable TaxNumberOfTheNoticeOfAssessment taxNo) {
        this.taxNo = taxNo;
    }

    public void setTaxOffice(@Nullable String taxOffice) {
        this.taxOffice = taxOffice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedAssetRealEstateAndSimilarRights)) {
            return false;
        }
        FixedAssetRealEstateAndSimilarRights other = (FixedAssetRealEstateAndSimilarRights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SurfaceArea this$area = this.getArea();
        SurfaceArea other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)((Object)this$area)).equals((Object)other$area)) {
            return false;
        }
        AreaUnit this$areaUom = this.getAreaUom();
        AreaUnit other$areaUom = other.getAreaUom();
        if (this$areaUom == null ? other$areaUom != null : !((Object)((Object)this$areaUom)).equals((Object)other$areaUom)) {
            return false;
        }
        BaseUnitOfMeasureInIsoCode this$areaUomIso = this.getAreaUomIso();
        BaseUnitOfMeasureInIsoCode other$areaUomIso = other.getAreaUomIso();
        if (this$areaUomIso == null ? other$areaUomIso != null : !((Object)((Object)this$areaUomIso)).equals((Object)other$areaUomIso)) {
            return false;
        }
        LocalDate this$assessmentNoticeDate = this.getAssessmentNoticeDate();
        LocalDate other$assessmentNoticeDate = other.getAssessmentNoticeDate();
        if (this$assessmentNoticeDate == null ? other$assessmentNoticeDate != null : !((Object)this$assessmentNoticeDate).equals(other$assessmentNoticeDate)) {
            return false;
        }
        LocalDate this$conveyanceDate = this.getConveyanceDate();
        LocalDate other$conveyanceDate = other.getConveyanceDate();
        if (this$conveyanceDate == null ? other$conveyanceDate != null : !((Object)this$conveyanceDate).equals(other$conveyanceDate)) {
            return false;
        }
        LocalDate this$lndregDate = this.getLndregDate();
        LocalDate other$lndregDate = other.getLndregDate();
        if (this$lndregDate == null ? other$lndregDate != null : !((Object)this$lndregDate).equals(other$lndregDate)) {
            return false;
        }
        LocalDate this$lndregEntryDate = this.getLndregEntryDate();
        LocalDate other$lndregEntryDate = other.getLndregEntryDate();
        if (this$lndregEntryDate == null ? other$lndregEntryDate != null : !((Object)this$lndregEntryDate).equals(other$lndregEntryDate)) {
            return false;
        }
        String this$lndregMapNo = this.getLndregMapNo();
        String other$lndregMapNo = other.getLndregMapNo();
        if (this$lndregMapNo == null ? other$lndregMapNo != null : !this$lndregMapNo.equals(other$lndregMapNo)) {
            return false;
        }
        LandRegisterEntrySequenceNumber this$lndregNo = this.getLndregNo();
        LandRegisterEntrySequenceNumber other$lndregNo = other.getLndregNo();
        if (this$lndregNo == null ? other$lndregNo != null : !((Object)((Object)this$lndregNo)).equals((Object)other$lndregNo)) {
            return false;
        }
        LandRegisterPage this$lndregPg = this.getLndregPg();
        LandRegisterPage other$lndregPg = other.getLndregPg();
        if (this$lndregPg == null ? other$lndregPg != null : !((Object)((Object)this$lndregPg)).equals((Object)other$lndregPg)) {
            return false;
        }
        String this$lndregPlotNo = this.getLndregPlotNo();
        String other$lndregPlotNo = other.getLndregPlotNo();
        if (this$lndregPlotNo == null ? other$lndregPlotNo != null : !this$lndregPlotNo.equals(other$lndregPlotNo)) {
            return false;
        }
        LandRegisterVolume this$lndregVol = this.getLndregVol();
        LandRegisterVolume other$lndregVol = other.getLndregVol();
        if (this$lndregVol == null ? other$lndregVol != null : !((Object)((Object)this$lndregVol)).equals((Object)other$lndregVol)) {
            return false;
        }
        String this$municipality = this.getMunicipality();
        String other$municipality = other.getMunicipality();
        if (this$municipality == null ? other$municipality != null : !this$municipality.equals(other$municipality)) {
            return false;
        }
        TaxNumberOfTheNoticeOfAssessment this$taxNo = this.getTaxNo();
        TaxNumberOfTheNoticeOfAssessment other$taxNo = other.getTaxNo();
        if (this$taxNo == null ? other$taxNo != null : !((Object)((Object)this$taxNo)).equals((Object)other$taxNo)) {
            return false;
        }
        String this$taxOffice = this.getTaxOffice();
        String other$taxOffice = other.getTaxOffice();
        return !(this$taxOffice == null ? other$taxOffice != null : !this$taxOffice.equals(other$taxOffice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedAssetRealEstateAndSimilarRights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SurfaceArea $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)((Object)$area)).hashCode());
        AreaUnit $areaUom = this.getAreaUom();
        result = result * 59 + ($areaUom == null ? 43 : ((Object)((Object)$areaUom)).hashCode());
        BaseUnitOfMeasureInIsoCode $areaUomIso = this.getAreaUomIso();
        result = result * 59 + ($areaUomIso == null ? 43 : ((Object)((Object)$areaUomIso)).hashCode());
        LocalDate $assessmentNoticeDate = this.getAssessmentNoticeDate();
        result = result * 59 + ($assessmentNoticeDate == null ? 43 : ((Object)$assessmentNoticeDate).hashCode());
        LocalDate $conveyanceDate = this.getConveyanceDate();
        result = result * 59 + ($conveyanceDate == null ? 43 : ((Object)$conveyanceDate).hashCode());
        LocalDate $lndregDate = this.getLndregDate();
        result = result * 59 + ($lndregDate == null ? 43 : ((Object)$lndregDate).hashCode());
        LocalDate $lndregEntryDate = this.getLndregEntryDate();
        result = result * 59 + ($lndregEntryDate == null ? 43 : ((Object)$lndregEntryDate).hashCode());
        String $lndregMapNo = this.getLndregMapNo();
        result = result * 59 + ($lndregMapNo == null ? 43 : $lndregMapNo.hashCode());
        LandRegisterEntrySequenceNumber $lndregNo = this.getLndregNo();
        result = result * 59 + ($lndregNo == null ? 43 : ((Object)((Object)$lndregNo)).hashCode());
        LandRegisterPage $lndregPg = this.getLndregPg();
        result = result * 59 + ($lndregPg == null ? 43 : ((Object)((Object)$lndregPg)).hashCode());
        String $lndregPlotNo = this.getLndregPlotNo();
        result = result * 59 + ($lndregPlotNo == null ? 43 : $lndregPlotNo.hashCode());
        LandRegisterVolume $lndregVol = this.getLndregVol();
        result = result * 59 + ($lndregVol == null ? 43 : ((Object)((Object)$lndregVol)).hashCode());
        String $municipality = this.getMunicipality();
        result = result * 59 + ($municipality == null ? 43 : $municipality.hashCode());
        TaxNumberOfTheNoticeOfAssessment $taxNo = this.getTaxNo();
        result = result * 59 + ($taxNo == null ? 43 : ((Object)((Object)$taxNo)).hashCode());
        String $taxOffice = this.getTaxOffice();
        result = result * 59 + ($taxOffice == null ? 43 : $taxOffice.hashCode());
        return result;
    }

    public String toString() {
        return "FixedAssetRealEstateAndSimilarRights(area=" + (Object)((Object)this.getArea()) + ", areaUom=" + (Object)((Object)this.getAreaUom()) + ", areaUomIso=" + (Object)((Object)this.getAreaUomIso()) + ", assessmentNoticeDate=" + this.getAssessmentNoticeDate() + ", conveyanceDate=" + this.getConveyanceDate() + ", lndregDate=" + this.getLndregDate() + ", lndregEntryDate=" + this.getLndregEntryDate() + ", lndregMapNo=" + this.getLndregMapNo() + ", lndregNo=" + (Object)((Object)this.getLndregNo()) + ", lndregPg=" + (Object)((Object)this.getLndregPg()) + ", lndregPlotNo=" + this.getLndregPlotNo() + ", lndregVol=" + (Object)((Object)this.getLndregVol()) + ", municipality=" + this.getMunicipality() + ", taxNo=" + (Object)((Object)this.getTaxNo()) + ", taxOffice=" + this.getTaxOffice() + ")";
    }

    public static class FixedAssetRealEstateAndSimilarRightsBuilder {
        private SurfaceArea area;
        private AreaUnit areaUom;
        private BaseUnitOfMeasureInIsoCode areaUomIso;
        private LocalDate assessmentNoticeDate;
        private LocalDate conveyanceDate;
        private LocalDate lndregDate;
        private LocalDate lndregEntryDate;
        private String lndregMapNo;
        private LandRegisterEntrySequenceNumber lndregNo;
        private LandRegisterPage lndregPg;
        private String lndregPlotNo;
        private LandRegisterVolume lndregVol;
        private String municipality;
        private TaxNumberOfTheNoticeOfAssessment taxNo;
        private String taxOffice;

        FixedAssetRealEstateAndSimilarRightsBuilder() {
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder area(SurfaceArea area) {
            this.area = area;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder areaUom(AreaUnit areaUom) {
            this.areaUom = areaUom;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder areaUomIso(BaseUnitOfMeasureInIsoCode areaUomIso) {
            this.areaUomIso = areaUomIso;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder assessmentNoticeDate(LocalDate assessmentNoticeDate) {
            this.assessmentNoticeDate = assessmentNoticeDate;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder conveyanceDate(LocalDate conveyanceDate) {
            this.conveyanceDate = conveyanceDate;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregDate(LocalDate lndregDate) {
            this.lndregDate = lndregDate;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregEntryDate(LocalDate lndregEntryDate) {
            this.lndregEntryDate = lndregEntryDate;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregMapNo(String lndregMapNo) {
            this.lndregMapNo = lndregMapNo;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregNo(LandRegisterEntrySequenceNumber lndregNo) {
            this.lndregNo = lndregNo;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregPg(LandRegisterPage lndregPg) {
            this.lndregPg = lndregPg;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregPlotNo(String lndregPlotNo) {
            this.lndregPlotNo = lndregPlotNo;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder lndregVol(LandRegisterVolume lndregVol) {
            this.lndregVol = lndregVol;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder municipality(String municipality) {
            this.municipality = municipality;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder taxNo(TaxNumberOfTheNoticeOfAssessment taxNo) {
            this.taxNo = taxNo;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRightsBuilder taxOffice(String taxOffice) {
            this.taxOffice = taxOffice;
            return this;
        }

        public FixedAssetRealEstateAndSimilarRights build() {
            return new FixedAssetRealEstateAndSimilarRights(this.area, this.areaUom, this.areaUomIso, this.assessmentNoticeDate, this.conveyanceDate, this.lndregDate, this.lndregEntryDate, this.lndregMapNo, this.lndregNo, this.lndregPg, this.lndregPlotNo, this.lndregVol, this.municipality, this.taxNo, this.taxOffice);
        }

        public String toString() {
            return "FixedAssetRealEstateAndSimilarRights.FixedAssetRealEstateAndSimilarRightsBuilder(area=" + (Object)((Object)this.area) + ", areaUom=" + (Object)((Object)this.areaUom) + ", areaUomIso=" + (Object)((Object)this.areaUomIso) + ", assessmentNoticeDate=" + this.assessmentNoticeDate + ", conveyanceDate=" + this.conveyanceDate + ", lndregDate=" + this.lndregDate + ", lndregEntryDate=" + this.lndregEntryDate + ", lndregMapNo=" + this.lndregMapNo + ", lndregNo=" + (Object)((Object)this.lndregNo) + ", lndregPg=" + (Object)((Object)this.lndregPg) + ", lndregPlotNo=" + this.lndregPlotNo + ", lndregVol=" + (Object)((Object)this.lndregVol) + ", municipality=" + this.municipality + ", taxNo=" + (Object)((Object)this.taxNo) + ", taxOffice=" + this.taxOffice + ")";
        }
    }
}

