/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.result;

import java.math.BigDecimal;
import java.math.BigInteger;

import javax.annotation.Nonnull;

import com.google.gson.JsonPrimitive;

import lombok.Data;

/**
 * {@code ResultPrimitive} implementation based on a {@code JsonPrimitive}.
 */
@Data
public class GsonResultPrimitive implements ResultPrimitive
{
    protected final JsonPrimitive jsonPrimitive;

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isResultPrimitive()
    {
        return true;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isResultCollection()
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isResultObject()
    {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResultPrimitive getAsPrimitive()
    {
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResultCollection getAsCollection()
        throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException("Cannot get a primitive as collection.");
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResultObject getAsObject()
        throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException("Cannot get a primitive as object.");
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean asBoolean()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsBoolean();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public byte asByte()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsByte();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public char asCharacter()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsCharacter();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public String asString()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsString();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int asInteger()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsInt();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public short asShort()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsShort();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public long asLong()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsLong();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public float asFloat()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsFloat();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public double asDouble()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsDouble();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public BigInteger asBigInteger()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsBigInteger();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public BigDecimal asBigDecimal()
        throws UnsupportedOperationException
    {
        try {
            return jsonPrimitive.getAsBigDecimal();
        }
        catch( final Exception e ) {
            throw new UnsupportedOperationException(e);
        }
    }
}
