/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.result;

import java.math.BigDecimal;
import java.math.BigInteger;

import javax.annotation.Nonnull;

/**
 * Class representing an unstructured result primitive resulting from a call to an external service (e.g. after invoking
 * a BAPI or a remote-enabled function module).
 * <p>
 * Access the content of this result element using the respective method, such as {@link #asString()} to obtain a String
 * object.
 */
public interface ResultPrimitive extends ResultElement
{
    // TODO support retrieving primitive as Object
    // <T> T as( final Class<T> objectType )
    // throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    boolean asBoolean()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    byte asByte()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    char asCharacter()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    String asString()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    int asInteger()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    short asShort()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    long asLong()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    float asFloat()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Override
    double asDouble()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    BigInteger asBigInteger()
        throws UnsupportedOperationException;

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    BigDecimal asBigDecimal()
        throws UnsupportedOperationException;
}
