/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.sap.cloud.sdk.cloudplatform.concurrency.ScpNeoTenantCallable;
import com.sap.cloud.sdk.cloudplatform.concurrency.ScpNeoUserSessionCallable;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.ScpNeoUser;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpNeoTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class ScpNeoHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    private static final Logger logger = CloudLoggerFactory.getLogger(ScpNeoHystrixConcurrencyStrategy.class);

    private ScpNeoTenant getCurrentTenant() throws TenantNotAvailableException, TenantAccessException {
        Tenant tenant = TenantAccessor.getCurrentTenant();
        if (!(tenant instanceof ScpNeoTenant)) {
            throw new ShouldNotHappenException("The current " + Tenant.class.getSimpleName() + " is not an instance of " + ScpNeoTenant.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:tenant-scp-neo.");
        }
        return (ScpNeoTenant)tenant;
    }

    private ScpNeoUser getCurrentUser() throws UserNotAuthenticatedException, UserAccessException {
        User user = UserAccessor.getCurrentUser();
        if (!(user instanceof ScpNeoUser)) {
            throw new ShouldNotHappenException("The current " + User.class.getSimpleName() + " is not an instance of " + ScpNeoUser.class.getSimpleName() + ". Please make sure to specify a dependency to com.sap.cloud.s4hana.cloudplatform:security-scp-neo.");
        }
        return (ScpNeoUser)user;
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        ScpNeoTenantCallable tenantCallable;
        ScpNeoUserSessionCallable userSessionCallable;
        try {
            userSessionCallable = new ScpNeoUserSessionCallable((HttpServletRequest)RequestContextAccessor.getCurrentRequest().orElse(null), this.getCurrentUser(), callable);
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully wrapped callable in " + userSessionCallable + ".");
            }
        }
        catch (UserAccessException | UserNotAuthenticatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("User not available. Skip wrapping of callable in " + ScpNeoUserSessionCallable.class.getSimpleName() + ".", e);
            }
            userSessionCallable = callable;
        }
        try {
            tenantCallable = new ScpNeoTenantCallable(this.getCurrentTenant(), (Callable)userSessionCallable);
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully wrapped callable in " + tenantCallable + ".");
            }
        }
        catch (TenantAccessException | TenantNotAvailableException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Tenant not available. Skip wrapping of callable in " + ScpNeoTenantCallable.class.getSimpleName() + ".", e);
            }
            tenantCallable = userSessionCallable;
        }
        return tenantCallable;
    }
}

