/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.google.common.cache.Cache;
import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.frameworks.hystrix.Command;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CachingCommand<T>
extends Command<T> {
    private final boolean isCacheEnabled;

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group) {
        this(group, true);
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, boolean isCacheEnabled) {
        super(group);
        this.isCacheEnabled = isCacheEnabled;
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, @Nonnull HystrixThreadPoolKey threadPool) {
        this(group, threadPool, true);
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, @Nonnull HystrixThreadPoolKey threadPool, boolean isCacheEnabled) {
        super(group, threadPool);
        this.isCacheEnabled = isCacheEnabled;
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, int executionIsolationThreadTimeoutInMilliseconds) {
        this(group, executionIsolationThreadTimeoutInMilliseconds, true);
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, int executionIsolationThreadTimeoutInMilliseconds, boolean isCacheEnabled) {
        super(group, executionIsolationThreadTimeoutInMilliseconds);
        this.isCacheEnabled = isCacheEnabled;
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, @Nonnull HystrixThreadPoolKey threadPool, int executionIsolationThreadTimeoutInMilliseconds) {
        this(group, threadPool, executionIsolationThreadTimeoutInMilliseconds, true);
    }

    protected CachingCommand(@Nonnull HystrixCommandGroupKey group, @Nonnull HystrixThreadPoolKey threadPool, int executionIsolationThreadTimeoutInMilliseconds, boolean isCacheEnabled) {
        super(group, threadPool, executionIsolationThreadTimeoutInMilliseconds);
        this.isCacheEnabled = isCacheEnabled;
    }

    protected CachingCommand(@Nonnull HystrixCommand.Setter setter) {
        this(setter, true);
    }

    protected CachingCommand(@Nonnull HystrixCommand.Setter setter, boolean isCacheEnabled) {
        super(setter);
        this.isCacheEnabled = isCacheEnabled;
    }

    protected boolean useCache() {
        return this.isCacheEnabled && this.getCommandCacheKey() != null && ConfigurationManager.getConfigInstance().getBoolean("hystrix.command.default.requestCache.enabled", true);
    }

    @Nonnull
    protected abstract Cache<CacheKey, T> getCache();

    @Deprecated
    @Nullable
    protected final String getCacheKey() {
        return null;
    }

    @Nullable
    protected CacheKey getCommandCacheKey() throws TenantAccessException, UserAccessException {
        return CacheKey.ofTenantAndUserIsolation().append(new Object[]{((Object)((Object)this)).getClass().getName()});
    }

    @Nonnull
    protected final T run() throws Exception {
        if (this.useCache() && this.getCommandCacheKey() != null) {
            return (T)this.getCache().get((Object)this.getCommandCacheKey(), this::runCacheable);
        }
        return this.runCacheable();
    }

    @Nonnull
    protected abstract T runCacheable() throws Exception;
}

