/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;

public class HystrixDelegatingRequestContext
implements RequestContext {
    @Nonnull
    private final RequestContext delegate;
    @Nullable
    private final HystrixRequestContext hystrixRequestContext;

    public HystrixDelegatingRequestContext(RequestContext delegate) {
        this.delegate = delegate;
        this.hystrixRequestContext = !HystrixRequestContext.isCurrentThreadInitialized() ? HystrixRequestContext.initializeContext() : null;
    }

    public void shutdownHystrixRequestContext() {
        if (this.hystrixRequestContext != null) {
            this.hystrixRequestContext.shutdown();
        }
    }

    @Nonnull
    public Optional<HttpServletRequest> getRequest() {
        return this.delegate.getRequest();
    }

    public long getRequestThreadId() {
        return this.delegate.getRequestThreadId();
    }

    @Nonnull
    public Optional<Property<?>> getProperty(@Nonnull String name) throws RequestContextPropertyException {
        return this.delegate.getProperty(name);
    }

    public void setPropertyIfAbsent(@Nonnull String name, @Nonnull Property<?> value) throws RequestContextPropertyException {
        this.delegate.setPropertyIfAbsent(name, value);
    }

    @Nonnull
    public Optional<Property<?>> removeProperty(@Nonnull String name) throws RequestContextPropertyException {
        return this.delegate.removeProperty(name);
    }
}

