/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.hystrix;

import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableDefault;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixDelegatingRequestContext;
import java.util.Optional;
import javax.annotation.Nonnull;

public class HystrixRequestContextFacade
extends AbstractRequestContextFacade {
    private static final HystrixRequestVariableDefault<HystrixDelegatingRequestContext> currentRequestContext = new HystrixRequestVariableDefault();

    @Nonnull
    public Optional<RequestContext> getCurrentRequestContext() {
        if (!HystrixRequestContext.isCurrentThreadInitialized()) {
            return Optional.empty();
        }
        return Optional.ofNullable(currentRequestContext.get());
    }

    public void setCurrentContext(RequestContext requestContext) {
        currentRequestContext.set((Object)new HystrixDelegatingRequestContext(requestContext));
    }

    public void removeCurrentContext() {
        ((HystrixDelegatingRequestContext)currentRequestContext.get()).shutdownHystrixRequestContext();
        currentRequestContext.remove();
    }
}

