/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.common.base.CaseFormat;
import javax.annotation.Nonnull;

class AbapToSoapNameConverter {
    private static final int MAX_LENGTH_FUNCTION_NAME = 30;

    AbapToSoapNameConverter() {
    }

    String abapFunctionNameToSoapMessageName(@Nonnull String functionName) {
        if (functionName.startsWith("BAPI_")) {
            functionName = functionName.substring(4);
        }
        return this.abapNameToSoapName(functionName);
    }

    String abapParameterNameToSoapParameterName(@Nonnull String abapName) {
        return this.abapNameToSoapName(abapName);
    }

    String soapParameterNameToAbapParameterName(String soapName) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, soapName);
    }

    private String abapNameToSoapName(@Nonnull String abapName) {
        String soapName;
        int indexOfLastUnderscore = abapName.lastIndexOf("_");
        if (indexOfLastUnderscore == -1) {
            soapName = this.transformUpperUnderScoreToUpperCamel(abapName);
        } else {
            String abapNameRightOfLastUnderscore = abapName.substring(indexOfLastUnderscore + 1);
            if (this.isStringOfTypeNumber(abapNameRightOfLastUnderscore)) {
                String abapNameLeftOfLastUnderscore = abapName.substring(0, indexOfLastUnderscore);
                soapName = this.transformUpperUnderScoreToUpperCamel(abapNameLeftOfLastUnderscore) + "_" + abapNameRightOfLastUnderscore;
            } else {
                soapName = this.transformUpperUnderScoreToUpperCamel(abapName);
            }
        }
        return soapName;
    }

    private String transformUpperUnderScoreToUpperCamel(@Nonnull String stringInUpperUnderscore) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, stringInUpperUnderscore);
    }

    private boolean isStringOfTypeNumber(@Nonnull String s) {
        return s.matches("\\d+");
    }

    String abapFunctionNameToSoapServiceName(@Nonnull String functionName) {
        String soapServiceName = functionName;
        if (functionName.length() >= 30) {
            StringBuilder builder = new StringBuilder(functionName);
            builder.deleteCharAt(28);
            soapServiceName = builder.toString();
        }
        soapServiceName = soapServiceName.replaceAll("/", "7");
        return "7" + soapServiceName;
    }
}

