/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.JCoTransaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapTransaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

abstract class AbstractTransactionFactory<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractTransactionFactory.class);

    @Nonnull
    protected abstract SoapTransaction<QueryT, QueryResultT> createSoapTransaction();

    @Nonnull
    protected abstract JCoTransaction<QueryT, QueryResultT> createJCoTransaction(@Nonnull String var1) throws RemoteFunctionException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    Transaction<QueryT, QueryResultT> createTransaction(@Nonnull ErpConfigContext configContext) throws QuerySerializationException, DestinationNotFoundException, DestinationAccessException, RemoteFunctionException {
        String destinationName = configContext.getDestinationName();
        DestinationType destinationType = DestinationAccessor.getDestinationType((String)destinationName);
        switch (destinationType) {
            case HTTP: {
                String destinationNameRfc = configContext.getDestinationNameRfc();
                try {
                    if (DestinationType.RFC == DestinationAccessor.getDestinationType((String)destinationNameRfc)) {
                        return this.createJCoTransaction(destinationNameRfc);
                    }
                    if (!logger.isDebugEnabled()) return this.createSoapTransaction();
                    logger.debug("Destination '" + destinationNameRfc + "' is not of type '" + DestinationType.RFC + "'. Invoking remote functions via RFC will not be supported.");
                    return this.createSoapTransaction();
                }
                catch (DestinationAccessException | DestinationNotFoundException e) {
                    if (!logger.isDebugEnabled()) return this.createSoapTransaction();
                    logger.debug("Failed to get destination '" + destinationNameRfc + "'. Invoking remote functions via RFC will not be supported.", e);
                }
                return this.createSoapTransaction();
            }
            case RFC: {
                return this.createJCoTransaction(destinationName);
            }
        }
        throw new QuerySerializationException("Failed to create " + QueryExecutor.class.getSimpleName() + ": " + DestinationType.class.getSimpleName() + " '" + destinationType + "' is not supported.");
    }
}

