/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiTransactionFactory;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.CommitStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Fields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryErrorHandler;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RemoteFunctionQueryExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class BapiQuery
extends AbstractRemoteFunctionQuery<BapiQuery, BapiQueryResult> {
    private static final Logger logger = CloudLoggerFactory.getLogger(BapiQuery.class);

    @Nonnull
    public BapiQueryResult execute(@Nonnull ErpConfigContext configContext) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return new RemoteFunctionQueryExecutor<BapiQuery, BapiQueryResult>(new BapiTransactionFactory()).execute(configContext, this);
    }

    @Override
    @Nonnull
    protected BapiQuery instance() {
        return this;
    }

    public BapiQuery(String functionName) throws IllegalArgumentException {
        super(functionName, CommitStrategy.COMMIT_SYNC, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    public BapiQuery(String functionName, boolean commit) throws IllegalArgumentException {
        super(functionName, commit ? CommitStrategy.COMMIT_SYNC : CommitStrategy.NO_COMMIT, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    public BapiQuery(String functionName, @Nonnull CommitStrategy commitStrategy) throws IllegalArgumentException {
        super(functionName, commitStrategy, Thread.currentThread().getStackTrace()[2].toString());
        this.assertFunctionIsBapi(functionName);
    }

    private void assertFunctionIsBapi(String functionName) throws IllegalArgumentException {
        if (!functionName.toLowerCase(Locale.ENGLISH).startsWith("bapi")) {
            throw new IllegalArgumentException("The given function '" + functionName + "' is not a valid BAPI. For calling remote-enabled functions, use " + RfcQuery.class.getSimpleName() + " instead.");
        }
    }

    @Nonnull
    public BapiQuery withTypeConverters(Iterable<ErpTypeConverter<?>> typeConverters) {
        return (BapiQuery)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public BapiQuery withTypeConverters(ErpTypeConverter<?> ... typeConverters) {
        return (BapiQuery)super.withTypeConverters(typeConverters);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType) {
        return (BapiQuery)super.withExporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> BapiQuery withExporting(String name, String dataType, T value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public <T> BapiQuery withExporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (BapiQuery)super.withExporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Boolean value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Byte value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Character value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, String value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Short value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Integer value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Long value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Float value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Double value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, BigInteger value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, BigDecimal value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Locale value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, Year value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, LocalDate value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withExporting(String name, String dataType, LocalTime value) {
        return (BapiQuery)super.withExporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<BapiQuery> withExportingFields(String name, String dataType) {
        return super.withExportingFields(name, dataType);
    }

    @Nonnull
    public BapiQuery withExportingFields(String name, String dataType, Fields fields) {
        return (BapiQuery)super.withExportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<BapiQuery> withExportingTable(String name, String dataType) {
        return super.withExportingTable(name, dataType);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType) {
        return (BapiQuery)super.withImporting(name, dataType);
    }

    @Nonnull
    public <T extends ErpType<T>> BapiQuery withImporting(String name, String dataType, T value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public <T> BapiQuery withImporting(String name, String dataType, T value, ErpTypeConverter<T> typeConverter) {
        return (BapiQuery)super.withImporting(name, dataType, value, typeConverter);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Boolean value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Byte value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Character value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, String value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Short value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Integer value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Long value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Float value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Double value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, BigInteger value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, BigDecimal value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Locale value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, Year value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, LocalDate value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Nonnull
    public BapiQuery withImporting(String name, String dataType, LocalTime value) {
        return (BapiQuery)super.withImporting(name, dataType, value);
    }

    @Override
    @Nonnull
    public ParameterFields<BapiQuery> withImportingFields(String name, String dataType) {
        return super.withImportingFields(name, dataType);
    }

    @Nonnull
    public BapiQuery withImportingFields(String name, String dataType, Fields fields) {
        return (BapiQuery)super.withImportingFields(name, dataType, fields);
    }

    @Override
    @Nonnull
    public Table<BapiQuery> withImportingTable(String name, String dataType) {
        return super.withImportingTable(name, dataType);
    }

    @Nonnull
    public BapiQuery withImportingAsReturn(String dataType) {
        return (BapiQuery)super.withImportingAsReturn(dataType);
    }

    @Nonnull
    public BapiQuery withImportingAsReturn(String name, String dataType) {
        return (BapiQuery)super.withImportingAsReturn(name, dataType);
    }

    @Override
    @Nonnull
    public Table<BapiQuery> withTable(String name, String dataType) {
        return super.withTable(name, dataType);
    }

    @Nonnull
    public BapiQuery withTableAsReturn(String dataType) {
        return (BapiQuery)super.withTableAsReturn(dataType);
    }

    @Nonnull
    public BapiQuery withTableAsReturn(String name, String dataType) {
        return (BapiQuery)super.withTableAsReturn(name, dataType);
    }

    @Nonnull
    public BapiQuery withErrorHandler(@Nonnull RemoteFunctionQueryErrorHandler remoteFunctionQueryErrorHandler) {
        return (BapiQuery)super.withErrorHandler(remoteFunctionQueryErrorHandler);
    }

    @Nonnull
    public BapiQuery ignoringErrors() {
        return (BapiQuery)super.ignoringErrors();
    }

    @Nonnull
    public BapiQuery propagatingErrorsAsExceptions() {
        return (BapiQuery)super.propagatingErrorsAsExceptions();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BapiQuery)) {
            return false;
        }
        BapiQuery other = (BapiQuery)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BapiQuery;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "BapiQuery(super=" + super.toString() + ")";
    }
}

