/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpTypeSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.QueryBody;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.RfcQuery;
import com.sap.cloud.sdk.s4hana.serialization.ErpTypeConverter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

class RemoteFunctionQueryBody
extends QueryBody {
    private static final String TYPE_ID = "bapi";
    @Expose
    @SerializedName(value="BAPI_NAME")
    @JsonProperty(value="BAPI_NAME")
    private final String functionName;
    @Expose
    @SerializedName(value="COMMIT")
    @JsonProperty(value="COMMIT")
    private final boolean commit;
    @Expose
    @SerializedName(value="BAPI_PARAMETERS")
    @JsonProperty(value="BAPI_PARAMETERS")
    private final ArrayList<Parameter> parameters = new ArrayList();
    @Expose
    @SerializedName(value="EXCEPTIONS")
    @JsonProperty(value="EXCEPTIONS")
    @Nullable
    private ArrayList<RaisedException> exceptions;
    private final ErpTypeSerializer erpTypeSerializer = new ErpTypeSerializer();

    <QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>> RemoteFunctionQueryBody(QueryT query) {
        super(TYPE_ID, query.getRequestId());
        this.functionName = query.getFunctionName();
        this.commit = query.isPerformingTransactionalCommit();
        for (Map.Entry<String, com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter<?>> entry : query.getParametersByName().entrySet()) {
            this.addParameter(entry.getValue());
        }
        if (query instanceof RfcQuery) {
            this.setExceptions((RfcQuery)query);
        }
    }

    private <T> void addParameter(com.sap.cloud.sdk.s4hana.connectivity.rfc.Parameter<T> param) {
        ArrayList<Value> valueList;
        ArrayList<com.sap.cloud.sdk.s4hana.connectivity.rfc.Value<?>> paramValueList = param.getValueList();
        if (paramValueList != null) {
            valueList = new ArrayList<Value>();
            for (com.sap.cloud.sdk.s4hana.connectivity.rfc.Value<?> value : paramValueList) {
                valueList.add(new Value(value.getRowId(), value.getName(), value.getDataType(), this.toErpValue(value)));
            }
        } else {
            valueList = null;
        }
        this.parameters.add(new Parameter(param.getName(), param.getParameterType().getIdentifier(), param.getDataType(), this.toErpValue(param.getValue(), param.getTypeConverter()), valueList));
    }

    @Nullable
    private <T> String toErpValue(@Nullable T value, @Nullable ErpTypeConverter<T> typeConverter) {
        if (typeConverter != null) {
            return (String)typeConverter.toDomain(value).orNull();
        }
        return (String)this.erpTypeSerializer.toErp(value).orNull();
    }

    @Nullable
    private <T> String toErpValue(@Nullable com.sap.cloud.sdk.s4hana.connectivity.rfc.Value<T> value) {
        if (value == null) {
            return null;
        }
        T val = value.getValue();
        if (value.getTypeConverter() != null) {
            return (String)value.getTypeConverter().toDomain(val).orNull();
        }
        return (String)this.erpTypeSerializer.toErp(val).orNull();
    }

    private void setExceptions(RfcQuery query) {
        if (!query.getExceptionNames().isEmpty()) {
            this.exceptions = new ArrayList();
            long id = 1L;
            for (String exceptionName : query.getExceptionNames()) {
                this.exceptions.add(new RaisedException(id++, exceptionName));
            }
        } else {
            this.exceptions = null;
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    @Nullable
    public ArrayList<RaisedException> getExceptions() {
        return this.exceptions;
    }

    public ErpTypeSerializer getErpTypeSerializer() {
        return this.erpTypeSerializer;
    }

    public String toString() {
        return "RemoteFunctionQueryBody(functionName=" + this.getFunctionName() + ", commit=" + this.isCommit() + ", parameters=" + this.getParameters() + ", exceptions=" + this.getExceptions() + ", erpTypeSerializer=" + this.getErpTypeSerializer() + ")";
    }

    public static class RaisedException {
        @Expose
        @SerializedName(value="VALUE")
        @JsonProperty(value="VALUE")
        private final long id;
        @Expose
        @SerializedName(value="NAME")
        @JsonProperty(value="NAME")
        private final String name;

        public RaisedException(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "RemoteFunctionQueryBody.RaisedException(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }

    static class Parameter {
        @Expose
        @SerializedName(value="NAME")
        @JsonProperty(value="NAME")
        private final String name;
        @Expose
        @SerializedName(value="PARAM_TYPE")
        @JsonProperty(value="PARAM_TYPE")
        private final int parameterType;
        @Expose
        @SerializedName(value="DATA_TYPE")
        @JsonProperty(value="DATA_TYPE")
        private final String dataType;
        @Nullable
        @Expose
        @SerializedName(value="VALUE")
        @JsonProperty(value="VALUE")
        private final String value;
        @Nullable
        @Expose
        @SerializedName(value="VALUE_LIST")
        @JsonProperty(value="VALUE_LIST")
        private final ArrayList<Value> valueList;

        public Parameter(String name, int parameterType, String dataType, @Nullable String value, @Nullable ArrayList<Value> valueList) {
            this.name = name;
            this.parameterType = parameterType;
            this.dataType = dataType;
            this.value = value;
            this.valueList = valueList;
        }

        public String getName() {
            return this.name;
        }

        public int getParameterType() {
            return this.parameterType;
        }

        public String getDataType() {
            return this.dataType;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        @Nullable
        public ArrayList<Value> getValueList() {
            return this.valueList;
        }

        public String toString() {
            return "RemoteFunctionQueryBody.Parameter(name=" + this.getName() + ", parameterType=" + this.getParameterType() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ", valueList=" + this.getValueList() + ")";
        }
    }

    static class Value {
        @Expose
        @SerializedName(value="ROW_ID")
        @JsonProperty(value="ROW_ID")
        private final int rowId;
        @Expose
        @SerializedName(value="NAME")
        @JsonProperty(value="NAME")
        private final String name;
        @Expose
        @SerializedName(value="DATA_TYPE")
        @JsonProperty(value="DATA_TYPE")
        private final String dataType;
        @Expose
        @SerializedName(value="VALUE")
        @JsonProperty(value="VALUE")
        private final String value;

        public Value(int rowId, String name, String dataType, String value) {
            this.rowId = rowId;
            this.name = name;
            this.dataType = dataType;
            this.value = value;
        }

        public int getRowId() {
            return this.rowId;
        }

        public String getName() {
            return this.name;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "RemoteFunctionQueryBody.Value(rowId=" + this.getRowId() + ", name=" + this.getName() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ")";
        }
    }
}

