/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultElement;
import java.lang.reflect.Type;
import org.slf4j.Logger;

class ResultElementJsonDeserializer
implements JsonDeserializer<ResultElement> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ResultElementJsonDeserializer.class);
    protected final GsonResultElementFactory resultElementFactory;

    public ResultElement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return this.resultElementFactory.create(json);
        }
        catch (IllegalArgumentException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to convert " + JsonElement.class.getSimpleName() + " " + json + " to instance of " + ResultElement.class.getSimpleName() + ".", (Throwable)e);
            }
            return null;
        }
    }

    public ResultElementJsonDeserializer(GsonResultElementFactory resultElementFactory) {
        this.resultElementFactory = resultElementFactory;
    }
}

