/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.rfc;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.HttpRequestExecutor;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.QuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AccessDeniedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.AbstractRemoteFunctionQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.QueryNotifier;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.SoapSerializedQueryBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Transaction;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionCommitFailedException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.exception.RemoteFunctionException;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public class SoapTransaction<QueryT extends AbstractRemoteFunctionQuery<QueryT, QueryResultT>, QueryResultT extends AbstractRemoteFunctionQueryResult<QueryT, QueryResultT>>
implements Transaction<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(SoapTransaction.class);
    private final QuerySerializer<QueryT, QueryResultT> querySerializer;
    private final HttpRequestExecutor<QueryT, QueryResultT> queryExecutorLogic;
    private final HttpRequestExecutor<BapiQuery, BapiQueryResult> bapiQueryExecutorLogic;

    @Override
    public void before(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) {
        QueryNotifier.notifyQueryListeners(query, configContext.getDestinationName(), logger);
    }

    @Override
    @Nonnull
    public QueryResultT execute(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QueryExecutionException {
        try {
            return (QueryResultT)((AbstractRemoteFunctionQueryResult)this.queryExecutorLogic.execute(configContext, query, this.querySerializer));
        }
        catch (QueryExecutionException e) {
            QueryExecutionException alternativeException = this.throwExceptionsBasedOnSoapResponsePayload(e.getMessage());
            throw alternativeException != null ? alternativeException : new RemoteFunctionException(e);
        }
    }

    private QueryExecutionException throwExceptionsBasedOnSoapResponsePayload(String responsePayload) {
        if (responsePayload != null && responsePayload.contains("<faultcode>soap")) {
            String prefix = "500 Internal Server Error. ";
            if (responsePayload.contains("<faultcode>soap-env:Server</faultcode>")) {
                String message = "500 Internal Server Error. The ERP user lacks authorization to call the SOAP service (Authorization Object S_SERVICE). " + responsePayload;
                return new AccessDeniedException(message);
            }
            if (responsePayload.contains("<faultcode>soap-env:Client</faultcode>")) {
                String exceptionName = "";
                Pattern pattern = Pattern.compile("<Name>(.+?)</Name>");
                Matcher matcher = pattern.matcher(responsePayload);
                if (matcher.find()) {
                    exceptionName = matcher.group(1);
                }
                String exceptionText = "";
                pattern = Pattern.compile("<Text>(.+?)</Text>");
                matcher = pattern.matcher(responsePayload);
                if (matcher.find()) {
                    exceptionText = matcher.group(1);
                }
                StringBuilder messageStringBuilder = new StringBuilder("500 Internal Server Error.  Exception occurred during execution of SOAP service.");
                if (!exceptionName.isEmpty()) {
                    messageStringBuilder.append(" Exception Name: ").append(exceptionName).append(".");
                }
                if (!exceptionText.isEmpty()) {
                    messageStringBuilder.append(" Exception Text: ").append(exceptionText).append(".");
                }
                return new QueryExecutionException(messageStringBuilder.toString());
            }
        }
        return null;
    }

    @Override
    public void commit(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QuerySerializationException, QueryExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Committing BAPI transaction for query: " + query + ".");
        }
        ErpBoolean waitValue = ErpBoolean.of((Boolean)((AbstractRemoteFunctionQuery)((Object)query)).getCommitStrategy().isWaitingForCommitToFinish());
        String requestBody = String.format("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn=\"urn:sap-com:document:sap:soap:functions:mc-style\"><soapenv:Header/><soapenv:Body><urn:TransactionCommit><Wait>%s</Wait></urn:TransactionCommit></soapenv:Body></soapenv:Envelope>", waitValue);
        BapiQuery commitQuery = new BapiQuery("BAPI_TRANSACTION_COMMIT", false);
        SerializedQuery<AbstractRemoteFunctionQuery> serializedQuery = new SoapSerializedQueryBuilder((AbstractRemoteFunctionQuery)commitQuery.withSameCustomHttpHeadersAs((Query)query), requestBody).build();
        String commitResultBody = this.bapiQueryExecutorLogic.execute(configContext, serializedQuery);
        if (commitResultBody.contains("150")) {
            throw new RemoteFunctionCommitFailedException("Failed to commit BAPI transaction due to an unknown error on ERP side. Please investigate the respective ABAP logs.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully committed BAPI transaction for query: " + query + ".");
        }
    }

    @Override
    public void rollback(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query) throws QuerySerializationException, QueryExecutionException {
        if (logger.isDebugEnabled()) {
            logger.debug("Rolling back BAPI transaction for query: " + query + ".");
        }
        SerializedQuery<AbstractRemoteFunctionQuery> serializedQuery = new SoapSerializedQueryBuilder((AbstractRemoteFunctionQuery)new BapiQuery("BAPI_TRANSACTION_ROLLBACK", false).withSameCustomHttpHeadersAs((Query)query), "<x:Envelope xmlns:x=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:urn1=\"urn:sap-com:document:sap:soap:functions:mc-style\"><x:Header/><x:Body><urn1:TransactionRollback/></x:Body></x:Envelope>").build();
        this.bapiQueryExecutorLogic.execute(configContext, serializedQuery);
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully rolled back BAPI transaction for query: " + query + ".");
        }
    }

    @Override
    public void after() {
    }

    public SoapTransaction(QuerySerializer<QueryT, QueryResultT> querySerializer, HttpRequestExecutor<QueryT, QueryResultT> queryExecutorLogic, HttpRequestExecutor<BapiQuery, BapiQueryResult> bapiQueryExecutorLogic) {
        this.querySerializer = querySerializer;
        this.queryExecutorLogic = queryExecutorLogic;
        this.bapiQueryExecutorLogic = bapiQueryExecutorLogic;
    }
}

