/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogUtils;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import com.sap.cloud.sdk.cloudplatform.auditlog.exception.AuditLogAccessException;
import com.sap.xs.audit.api.AuditLogMessage;
import com.sap.xs.audit.api.TransactionalAuditLogMessage;
import com.sap.xs.audit.api.exception.AuditLogException;
import com.sap.xs.audit.api.exception.AuditLogNotAvailableException;
import com.sap.xs.audit.api.exception.AuditLogWriteException;
import com.sap.xs.audit.api.v2.AuditLogMessageFactory;
import com.sap.xs.audit.api.v2.AuditedObject;
import com.sap.xs.audit.api.v2.ConfigurationChangeAuditMessage;
import com.sap.xs.audit.api.v2.DataAccessAuditMessage;
import com.sap.xs.audit.api.v2.DataModificationAuditMessage;
import com.sap.xs.audit.api.v2.SecurityEventAuditMessage;
import com.sap.xs.audit.client.impl.v2.AuditLogMessageFactoryImpl;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfAuditLog
implements AuditLog {
    private static final Logger log = LoggerFactory.getLogger(ScpCfAuditLog.class);
    private static final String ACTION_BEGINNING = "[BEGINNING] ";
    private static final String ACTION_COMPLETED = "[COMPLETED] ";
    private static final String ACTION_FAILED = "[FAILED] ";
    private final AuditLogMessageFactory auditLogMessageFactory;

    private static AuditLogMessageFactory getAuditLogMessageFactory() throws AuditLogAccessException {
        try {
            return new AuditLogMessageFactoryImpl();
        }
        catch (AuditLogException e) {
            throw new AuditLogAccessException("Failed to instantiate AuditLogMessageFactoryImpl.", (Throwable)e);
        }
    }

    ScpCfAuditLog() throws AuditLogAccessException {
        this(ScpCfAuditLog.getAuditLogMessageFactory());
    }

    ScpCfAuditLog(@Nonnull AuditLogMessageFactory auditLogMessageFactory) {
        this.auditLogMessageFactory = auditLogMessageFactory;
    }

    public void logSecurityEventBeginning(@Nonnull AccessRequester initiator, String message) {
        this.logSecurityEvent(true, initiator, message, null);
    }

    public void logSecurityEvent(@Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        this.logSecurityEvent(false, initiator, message, throwable);
    }

    private void logSecurityEvent(boolean isBeginning, @Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        SecurityEventAuditMessage auditLogEntry = this.auditLogMessageFactory.createSecurityEventAuditMessage();
        this.fillCommonAttributes((AuditLogMessage)auditLogEntry, initiator);
        auditLogEntry.setIp((String)initiator.getIpAddress().getOrNull());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable == null ? (isBeginning ? ACTION_BEGINNING : ACTION_COMPLETED) : ACTION_FAILED);
        if (!Strings.isNullOrEmpty((String)message)) {
            stringBuilder.append(message);
        }
        if (throwable != null) {
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(throwable.getMessage());
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(Throwables.getStackTraceAsString((Throwable)throwable));
            stringBuilder.append(System.lineSeparator());
        }
        auditLogEntry.setData(stringBuilder.toString());
        this.logNonTransactional((AuditLogMessage)auditLogEntry);
    }

    public void logConfigChangeBeginning(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logConfigChange(true, initiator, object, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected), null);
    }

    public void logConfigChange(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logConfigChange(false, initiator, object, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected), error);
    }

    private void logConfigChange(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        ConfigurationChangeAuditMessage auditLogEntry = this.auditLogMessageFactory.createConfigurationChangeAuditMessage();
        this.fillCommonAttributes((AuditLogMessage)auditLogEntry, initiator);
        auditLogEntry.setObject(this.convertAuditedObject(object));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addValue(attribute.getIdentifier(), String.valueOf(attribute.getOldValue()), String.valueOf(attribute.getNewValue()));
            }
        }
        this.logTransactional((TransactionalAuditLogMessage)auditLogEntry, isBeginning, error);
    }

    public void logDataReadAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataRead(initiator, object, subject, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected));
    }

    public void logDataRead(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataRead(initiator, object, subject, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected));
    }

    private void logDataRead(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected) {
        DataAccessAuditMessage auditLogEntry = this.auditLogMessageFactory.createDataAccessAuditMessage();
        this.fillCommonAttributes((AuditLogMessage)auditLogEntry, initiator);
        auditLogEntry.setChannel((String)initiator.getChannel().getOrNull());
        auditLogEntry.setObject(this.convertAuditedObject(object));
        auditLogEntry.setDataSubject(this.convertAuditedSubject(subject));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addAttribute(attribute.getIdentifier(), attribute.isOperationSuccessful());
            }
        }
        this.logNonTransactional((AuditLogMessage)auditLogEntry);
    }

    public void logDataWriteAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataWrite(true, initiator, object, subject, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected), null);
    }

    public void logDataWrite(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        this.logDataWrite(false, initiator, object, subject, AuditLogUtils.attributesAsList((AccessedAttribute)attributeAffected, (AccessedAttribute[])attributesAffected), error);
    }

    private void logDataWrite(boolean isBeginning, @Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable Throwable error) {
        DataModificationAuditMessage auditLogEntry = this.auditLogMessageFactory.createDataModificationAuditMessage();
        this.fillCommonAttributes((AuditLogMessage)auditLogEntry, initiator);
        auditLogEntry.setObject(this.convertAuditedObject(object));
        auditLogEntry.setDataSubject(this.convertAuditedSubject(subject));
        if (attributesAffected != null) {
            for (AccessedAttribute attribute : attributesAffected) {
                auditLogEntry.addAttribute(attribute.getIdentifier(), String.valueOf(attribute.getOldValue()), String.valueOf(attribute.getNewValue()));
            }
        }
        this.logTransactional((TransactionalAuditLogMessage)auditLogEntry, isBeginning, error);
    }

    private void fillCommonAttributes(@Nonnull AuditLogMessage auditLogEntry, @Nonnull AccessRequester initiator) {
        auditLogEntry.setUser((String)initiator.getPrincipalId().getOrNull());
        auditLogEntry.setTenant((String)initiator.getTenantId().getOrNull());
    }

    private void logNonTransactional(@Nonnull AuditLogMessage auditLogEntry) {
        try {
            auditLogEntry.log();
        }
        catch (AuditLogNotAvailableException | AuditLogWriteException e) {
            log.error("Unable to write audit log entry. Entry contents: [" + auditLogEntry + "].", e);
        }
    }

    private void logTransactional(@Nonnull TransactionalAuditLogMessage auditLogEntry, boolean isBeginning, @Nullable Throwable error) {
        try {
            if (isBeginning) {
                auditLogEntry.logPrepare();
            } else if (error == null) {
                auditLogEntry.logSuccess();
            } else {
                auditLogEntry.logFailure();
            }
        }
        catch (AuditLogNotAvailableException | AuditLogWriteException e) {
            log.error("Unable to write audit log entry. Entry contents: [" + auditLogEntry + "].", e);
        }
    }

    private AuditedObject convertAuditedObject(@Nonnull AuditedDataObject sdkObject) {
        AuditedObject converted = this.auditLogMessageFactory.createAuditedObject();
        converted.setType(sdkObject.getType());
        for (Map.Entry identifier : sdkObject.getAllIdentifiers().entrySet()) {
            converted.addIdentifier((String)identifier.getKey(), (String)identifier.getValue());
        }
        return converted;
    }

    private com.sap.xs.audit.api.v2.AuditedDataSubject convertAuditedSubject(@Nonnull AuditedDataSubject sdkSubject) {
        com.sap.xs.audit.api.v2.AuditedDataSubject converted = this.auditLogMessageFactory.createAuditedDataSubject();
        converted.setType(sdkSubject.getType());
        converted.setRole(sdkSubject.getRole());
        for (Map.Entry identifier : sdkSubject.getAllIdentifiers().entrySet()) {
            converted.addIdentifier((String)identifier.getKey(), (String)identifier.getValue());
        }
        return converted;
    }
}

