/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.auditlog;

import javax.annotation.Nonnull;

import io.vavr.control.Try;

/**
 * Audit log facade used with CloudFoundry.
 *
 * <strong>Warning:</strong> This module will be discontinued, along with its classes and method.
 */
public class ScpCfAuditLogFacade implements AuditLogFacade
{
    /**
     * {@inheritDoc}
     *
     * @deprecated This module will be discontinued, along with its classes and method.
     */
    @Deprecated
    public void assertRuntimeDependenciesExist()
        throws IllegalStateException
    {
        try {
            Class.forName("com.sap.xs.audit.client.impl.v2.AuditLogMessageFactoryImpl");
        }
        catch( final ClassNotFoundException e ) {
            throw new IllegalStateException(
                "Failed to instantiate "
                    + ScpCfAuditLog.class.getSimpleName()
                    + ". Please make sure to add the latest version of the following dependencies to your project: "
                    + "'com.sap.xs.auditlog:audit-java-client-api', "
                    + "'com.sap.xs.auditlog:audit-java-client-impl',"
                    + "'com.sap.xs.java:xs-env'. "
                    + "Note that these dependencies may not be available in Maven Central. "
                    + "In this case, please install the latest version of the "
                    + "'Standard Java Client Libraries for XS Advanced'. "
                    + "Visit 'https://support.sap.com/' and "
                    + "search for software downloads with name 'XS_JAVA'.",
                e);
        }
    }

    @Nonnull
    @Override
    @Deprecated
    public Try<AuditLog> tryGetAuditLog()
    {
        return Try.of(() -> {
            assertRuntimeDependenciesExist();
            return new ScpCfAuditLog();
        });
    }
}
