/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.auditlog.exception;

import lombok.NoArgsConstructor;

/**
 * Runtime exception indicating that there was an issue while accessing the audit log.
 */
@NoArgsConstructor
public class AuditLogAccessException extends RuntimeException
{
    private static final long serialVersionUID = -8834305231178116407L;

    /**
     * Initializes the exception by delegating the message to the super constructor.
     *
     * @param message
     *            The exception message.
     */
    public AuditLogAccessException( final String message )
    {
        super(message);
    }

    /**
     * Initializes the exception by delegating the causing exception to the super constructor.
     *
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public AuditLogAccessException( final Throwable cause )
    {
        super(cause);
    }

    /**
     * Initializes the exception by delegating the message and the causing exception to the super constructor.
     *
     * @param message
     *            The exception message.
     * @param cause
     *            The exception that caused the exception to be created.
     */
    public AuditLogAccessException( final String message, final Throwable cause )
    {
        super(message, cause);
    }
}
