/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.auditlog;

import javax.annotation.Nonnull;

import io.vavr.control.Try;

/**
 * Facade interface encapsulating the creation of a concrete {@link AuditLog} implementation.
 */
public interface AuditLogFacade
{
    /**
     * Returns a {@link Try} of the {@link AuditLog}.
     * 
     * @return A {@link Try} of the {@link AuditLog}.
     */
    @Nonnull
    Try<AuditLog> tryGetAuditLog();
}
