/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogFacade;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import com.sap.cloud.sdk.cloudplatform.auditlog.exception.AuditLogAccessException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AuditLogger {
    @Nonnull
    private static Try<AuditLogFacade> auditLogFacade = FacadeLocator.getFacade(AuditLogFacade.class);

    @Nullable
    public static AuditLogFacade getAuditLogFacade() {
        return (AuditLogFacade)auditLogFacade.getOrNull();
    }

    @Nonnull
    public static Try<AuditLogFacade> tryGetAuditLogFacade() {
        return auditLogFacade;
    }

    public static void setAuditLogFacade(@Nonnull AuditLogFacade auditLogFacade) {
        AuditLogger.auditLogFacade = Try.success((Object)auditLogFacade);
    }

    @Nonnull
    public static AuditLog getAuditLog() throws AuditLogAccessException {
        return (AuditLog)AuditLogger.tryGetAuditLog().getOrElseThrow(failure -> {
            if (failure instanceof AuditLogAccessException) {
                throw (AuditLogAccessException)failure;
            }
            throw new AuditLogAccessException("Failed to get audit log.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<AuditLog> tryGetAuditLog() {
        return auditLogFacade.flatMap(AuditLogFacade::tryGetAuditLog);
    }

    public static void logSecurityEventBeginning(@Nonnull AccessRequester initiator, @Nullable String message) throws AuditLogAccessException {
        AuditLogger.getAuditLog().logSecurityEventBeginning(initiator, message);
    }

    public static void logSecurityEventBeginning(@Nullable String message) {
        AuditLogger.logSecurityEventBeginning(AccessRequester.ofCurrentRequest(), message);
    }

    public static void logSecurityEvent(@Nonnull AccessRequester initiator, @Nullable String message, @Nullable Throwable throwable) {
        AuditLogger.getAuditLog().logSecurityEvent(initiator, message, throwable);
    }

    public static void logSecurityEvent(@Nullable String message, @Nullable Throwable throwable) {
        AuditLogger.logSecurityEvent(AccessRequester.ofCurrentRequest(), message, throwable);
    }

    public static void logConfigChangeBeginning(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logConfigChangeBeginning(initiator, object, attributeAffected, attributesAffected);
    }

    public static void logConfigChangeBeginning(@Nonnull AuditedDataObject object, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logConfigChangeBeginning(AccessRequester.ofCurrentRequest(), object, attributeAffected, attributesAffected);
    }

    public static void logConfigChange(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logConfigChange(initiator, object, error, attributeAffected, attributesAffected);
    }

    public static void logConfigChange(@Nonnull AuditedDataObject object, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logConfigChange(AccessRequester.ofCurrentRequest(), object, error, attributeAffected, attributesAffected);
    }

    public static void logDataReadAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataReadAttempt(initiator, object, subject, attributeAffected, attributesAffected);
    }

    public static void logDataReadAttempt(@Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataReadAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributeAffected, attributesAffected);
    }

    public static void logDataRead(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataRead(initiator, object, subject, error, attributeAffected, attributesAffected);
    }

    public static void logDataRead(@Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataRead(AccessRequester.ofCurrentRequest(), object, subject, error, attributeAffected, attributesAffected);
    }

    public static void logDataWriteAttempt(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataWriteAttempt(initiator, object, subject, attributeAffected, attributesAffected);
    }

    public static void logDataWriteAttempt(@Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataWriteAttempt(AccessRequester.ofCurrentRequest(), object, subject, attributeAffected, attributesAffected);
    }

    public static void logDataWrite(@Nonnull AccessRequester initiator, @Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.getAuditLog().logDataWrite(initiator, object, subject, error, attributeAffected, attributesAffected);
    }

    public static void logDataWrite(@Nonnull AuditedDataObject object, @Nonnull AuditedDataSubject subject, @Nullable Throwable error, @Nonnull AccessedAttribute attributeAffected, AccessedAttribute ... attributesAffected) {
        AuditLogger.logDataWrite(AccessRequester.ofCurrentRequest(), object, subject, error, attributeAffected, attributesAffected);
    }
}

