/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestAccessorFilter;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import io.vavr.control.Option;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;

public class AccessRequester {
    public static final AccessRequester UNKNOWN = new AccessRequester(null, null, null, null);
    public static final String UNAUTHENTICATED_USER = "noauth";
    @Nullable
    private final String tenantId;
    @Nullable
    private final String principalId;
    @Nullable
    private final String ipAddress;
    @Nullable
    private final String channel;

    @Nonnull
    public Option<String> getPrincipalId() {
        return Option.of((Object)this.principalId);
    }

    @Nonnull
    public Option<String> getTenantId() {
        return Option.of((Object)this.tenantId);
    }

    @Nonnull
    public Option<String> getIpAddress() {
        return Option.of((Object)this.ipAddress);
    }

    @Nonnull
    public Option<String> getChannel() {
        return Option.of((Object)this.channel);
    }

    public AccessRequester(@Nonnull HttpServletRequest request) {
        this.principalId = AccessRequester.getCurrentPrincipalId();
        this.tenantId = null;
        this.ipAddress = request.getRemoteAddr();
        this.channel = request.getScheme();
    }

    public AccessRequester(@Nonnull HttpServletRequest request, @Nonnull Tenant tenant) {
        this.principalId = AccessRequester.getCurrentPrincipalId();
        this.tenantId = tenant.getTenantId();
        this.ipAddress = request.getRemoteAddr();
        this.channel = request.getScheme();
    }

    @Nonnull
    public static AccessRequester of(@Nullable HttpServletRequest request) {
        if (request == null) {
            return UNKNOWN;
        }
        return new AccessRequester(request);
    }

    @Nonnull
    public static AccessRequester of(@Nullable HttpServletRequest request, @Nullable Tenant tenant) {
        if (request != null) {
            if (tenant != null) {
                return new AccessRequester(request, tenant);
            }
            return new AccessRequester(request);
        }
        return UNKNOWN;
    }

    @Nonnull
    public static AccessRequester ofCurrentRequest() {
        Try threadContextTry = ThreadContextAccessor.tryGetCurrentContext();
        String scheme = (String)threadContextTry.flatMap(c -> c.getPropertyValue(RequestAccessorFilter.PROPERTY_SERVLET_SCHEME)).getOrNull();
        String remoteAddress = (String)threadContextTry.flatMap(c -> c.getPropertyValue(RequestAccessorFilter.PROPERTY_SERVLET_REMOTE_ADDRESS)).getOrNull();
        String tenantId = (String)TenantAccessor.tryGetCurrentTenant().map(Tenant::getTenantId).getOrNull();
        return new AccessRequester(tenantId, AccessRequester.getCurrentPrincipalId(), remoteAddress, scheme);
    }

    @Nonnull
    private static String getCurrentPrincipalId() {
        return (String)PrincipalAccessor.tryGetCurrentPrincipal().map(Principal::getPrincipalId).getOrElse((Object)UNAUTHENTICATED_USER);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessRequester)) {
            return false;
        }
        AccessRequester other = (AccessRequester)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Option<String> this$tenantId = this.getTenantId();
        Option<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Option<String> this$principalId = this.getPrincipalId();
        Option<String> other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        Option<String> this$ipAddress = this.getIpAddress();
        Option<String> other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        Option<String> this$channel = this.getChannel();
        Option<String> other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AccessRequester;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Option<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Option<String> $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        Option<String> $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        Option<String> $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "AccessRequester(tenantId=" + this.getTenantId() + ", principalId=" + this.getPrincipalId() + ", ipAddress=" + this.getIpAddress() + ", channel=" + this.getChannel() + ")";
    }

    @Generated
    public AccessRequester(@Nullable String tenantId, @Nullable String principalId, @Nullable String ipAddress, @Nullable String channel) {
        this.tenantId = tenantId;
        this.principalId = principalId;
        this.ipAddress = ipAddress;
        this.channel = channel;
    }
}

