/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class CacheKey
implements GenericCacheKey<CacheKey, Object> {
    @Nullable
    private final String tenantId;
    @Nullable
    private final String principalId;
    private final List<Object> components = new ArrayList<Object>();

    @Override
    @Nonnull
    public Option<String> getTenantId() {
        return Option.of((Object)this.tenantId);
    }

    @Override
    @Nonnull
    public Option<String> getPrincipalId() {
        return Option.of((Object)this.principalId);
    }

    @Override
    @Nonnull
    public CacheKey append(@Nonnull Iterable<Object> objects) throws IllegalArgumentException {
        for (Object object : objects) {
            if (object == null) {
                throw new IllegalArgumentException("Object must not be null.");
            }
            this.components.add(object);
        }
        return this;
    }

    @Nonnull
    public CacheKey append(Object ... objects) {
        return this.append(Arrays.asList(objects));
    }

    @Nonnull
    public static CacheKey of(@Nullable Tenant tenant, @Nullable Principal principal) {
        return new CacheKey(tenant != null ? tenant.getTenantId() : null, principal != null ? principal.getPrincipalId() : null);
    }

    @Nonnull
    public static CacheKey ofNoIsolation() {
        return new CacheKey(null, null);
    }

    @Nonnull
    public static CacheKey ofTenantIsolation() throws TenantAccessException {
        return CacheKey.of(TenantAccessor.getCurrentTenant(), null);
    }

    @Nonnull
    public static CacheKey ofTenantOptionalIsolation() {
        return CacheKey.of((Tenant)TenantAccessor.tryGetCurrentTenant().getOrNull(), null);
    }

    @Nonnull
    public static CacheKey ofTenantAndPrincipalIsolation() throws TenantAccessException, PrincipalAccessException {
        return CacheKey.of(TenantAccessor.getCurrentTenant(), PrincipalAccessor.getCurrentPrincipal());
    }

    @Nonnull
    public static CacheKey ofTenantAndPrincipalOptionalIsolation() {
        return CacheKey.of((Tenant)TenantAccessor.tryGetCurrentTenant().getOrNull(), (Principal)PrincipalAccessor.tryGetCurrentPrincipal().getOrNull());
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)o;
        Option<String> this$tenantId = this.getTenantId();
        Option<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Option<String> this$principalId = this.getPrincipalId();
        Option<String> other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        List<Object> this$components = this.getComponents();
        List<Object> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Option<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Option<String> $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        List<Object> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "CacheKey(tenantId=" + this.getTenantId() + ", principalId=" + this.getPrincipalId() + ", components=" + this.getComponents() + ")";
    }

    @Generated
    private CacheKey(@Nullable String tenantId, @Nullable String principalId) {
        this.tenantId = tenantId;
        this.principalId = principalId;
    }

    @Override
    @Generated
    public List<Object> getComponents() {
        return this.components;
    }
}

