/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.PlatformSslContextProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.KeyStoreReader;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Try;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.ssl.SSLContextBuilder;

abstract class AbstractX509SslContextProvider
implements PlatformSslContextProvider {
    private static final String DEFAULT_ALIAS = "instance-identity";
    private static final char[] DEFAULT_PASSWORD = "changeit".toCharArray();

    AbstractX509SslContextProvider() {
    }

    @Nonnull
    Try<SSLContext> tryGetContext(@Nonnull String cert, @Nonnull String key) {
        return this.tryGetContext(new StringReader(cert), new StringReader(key));
    }

    @Nonnull
    Try<SSLContext> tryGetContext(@Nonnull Reader certReader, @Nonnull Reader keyReader) {
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        return Try.of((CheckedFunction0 & Serializable)() -> KeyStoreReader.createKeyStore((String)DEFAULT_ALIAS, (char[])DEFAULT_PASSWORD, (Reader)certReader, (Reader)keyReader)).mapTry((CheckedFunction1 & Serializable)k -> sslContextBuilder.loadKeyMaterial(k, DEFAULT_PASSWORD)).mapTry(SSLContextBuilder::build);
    }
}

