/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Cache;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5CacheBuilder;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Factory;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5FactoryBuilder;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.hc.client5.http.classic.HttpClient;

@Beta
public final class ApacheHttpClient5Accessor {
    @Nonnull
    private static ApacheHttpClient5Cache httpClientCache = ApacheHttpClient5Accessor.newDefaultCache();
    @Nonnull
    private static ApacheHttpClient5Factory httpClientFactory = ApacheHttpClient5Accessor.newDefaultFactory();

    public static void setHttpClientFactory(@Nullable ApacheHttpClient5Factory httpClientFactory) {
        ApacheHttpClient5Accessor.httpClientFactory = httpClientFactory == null ? ApacheHttpClient5Accessor.newDefaultFactory() : httpClientFactory;
    }

    public static void setHttpClientCache(@Nullable ApacheHttpClient5Cache httpClientCache) {
        ApacheHttpClient5Accessor.httpClientCache = httpClientCache == null ? ApacheHttpClient5Accessor.newDefaultCache() : httpClientCache;
    }

    @Nonnull
    private static ApacheHttpClient5Cache newDefaultCache() {
        return new ApacheHttpClient5CacheBuilder().build();
    }

    @Nonnull
    private static ApacheHttpClient5Factory newDefaultFactory() {
        return new ApacheHttpClient5FactoryBuilder().build();
    }

    @Nonnull
    public static HttpClient getHttpClient() throws HttpClientInstantiationException {
        return (HttpClient)ApacheHttpClient5Accessor.tryGetHttpClient().getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                throw (DestinationAccessException)failure;
            }
            if (failure instanceof HttpClientInstantiationException) {
                throw (HttpClientInstantiationException)failure;
            }
            throw new HttpClientInstantiationException("Failed to get HttpClient.", failure);
        });
    }

    @Nonnull
    public static Try<HttpClient> tryGetHttpClient() {
        return httpClientCache.tryGetHttpClient(httpClientFactory);
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull HttpDestinationProperties destination) throws DestinationAccessException, HttpClientInstantiationException {
        return ApacheHttpClient5Accessor.getHttpClient((Destination)destination);
    }

    @Nonnull
    public static HttpClient getHttpClient(@Nonnull Destination destination) throws DestinationAccessException, HttpClientInstantiationException {
        return (HttpClient)ApacheHttpClient5Accessor.tryGetHttpClient(destination).getOrElseThrow(failure -> {
            if (failure instanceof DestinationAccessException) {
                throw (DestinationAccessException)failure;
            }
            if (failure instanceof HttpClientInstantiationException) {
                throw (HttpClientInstantiationException)failure;
            }
            throw new HttpClientInstantiationException("Failed to get HttpClient for destination.", failure);
        });
    }

    @Nonnull
    public static Try<HttpClient> tryGetHttpClient(@Nonnull Destination destination) {
        if (!destination.isHttp()) {
            return Try.failure((Throwable)new DestinationAccessException("The given destination is not an HTTP destination."));
        }
        return httpClientCache.tryGetHttpClient((HttpDestinationProperties)destination.asHttp(), httpClientFactory);
    }

    @Generated
    private ApacheHttpClient5Accessor() {
    }

    @Nonnull
    @Generated
    public static ApacheHttpClient5Cache getHttpClientCache() {
        return httpClientCache;
    }

    @Nonnull
    @Generated
    public static ApacheHttpClient5Factory getHttpClientFactory() {
        return httpClientFactory;
    }
}

