/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Factory;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultApacheHttpClient5Factory;
import java.time.Duration;
import javax.annotation.Nonnull;

@Beta
public class ApacheHttpClient5FactoryBuilder {
    @Nonnull
    private Duration timeout = DefaultApacheHttpClient5Factory.DEFAULT_TIMEOUT;
    private int maxConnectionsTotal = 200;
    private int maxConnectionsPerRoute = 100;

    @Nonnull
    public ApacheHttpClient5FactoryBuilder timeoutInMilliseconds(int timeoutInMilliseconds) {
        return this.timeout(Duration.ofMillis(timeoutInMilliseconds));
    }

    @Nonnull
    public ApacheHttpClient5FactoryBuilder timeout(@Nonnull Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nonnull
    public ApacheHttpClient5FactoryBuilder maxConnectionsTotal(int maxConnectionsTotal) {
        this.maxConnectionsTotal = maxConnectionsTotal;
        return this;
    }

    @Nonnull
    public ApacheHttpClient5FactoryBuilder maxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    @Nonnull
    public ApacheHttpClient5Factory build() {
        return new DefaultApacheHttpClient5Factory(this.timeout, this.maxConnectionsTotal, this.maxConnectionsPerRoute, null);
    }
}

