/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Joiner;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.QueryParamGetter;
import com.sap.cloud.sdk.cloudplatform.connectivity.UriPathMerger;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClient5Wrapper
extends CloseableHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient5Wrapper.class);
    private final CloseableHttpClient httpClient;
    private final HttpDestinationProperties destination;

    public void close() throws IOException {
        this.httpClient.close();
    }

    public void close(CloseMode closeMode) {
        this.httpClient.close(closeMode);
    }

    ApacheHttpClient5Wrapper(CloseableHttpClient httpClient, HttpDestinationProperties destination) {
        this.httpClient = httpClient;
        if (destination.getProxyType().contains((Object)ProxyType.ON_PREMISE) && destination.getProxyConfiguration().isEmpty()) {
            throw new DestinationAccessException("Unable to create an HttpClient from the provided destination. The destination is supposed to target an on-premise system but lacks the correct proxy configuration. Please check the application logs for further details.");
        }
        this.destination = destination;
    }

    protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
        return this.httpClient.execute(target, this.wrapRequest(request), context);
    }

    ApacheHttpClient5Wrapper withDestination(HttpDestinationProperties destination) {
        if (!destination.equals(this.destination)) {
            throw new ShouldNotHappenException("This method must not be used outside of updating an instance of ApacheHttpClient5Wrapper for http clients served from the ApacheHttpClient5Cache.");
        }
        if (destination == this.destination) {
            return this;
        }
        return new ApacheHttpClient5Wrapper(this.httpClient, destination);
    }

    ClassicHttpRequest wrapRequest(ClassicHttpRequest request) {
        URI requestUri;
        UriPathMerger merger = new UriPathMerger();
        try {
            requestUri = merger.merge(this.destination.getUri(), request.getUri());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to merge destination URI with request URI.", e);
        }
        String queryString = Joiner.on((String)"&").join(QueryParamGetter.getQueryParameters(this.destination));
        requestUri = merger.merge(requestUri, URI.create("/?" + queryString));
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.copy((ClassicHttpRequest)request);
        requestBuilder.setUri(requestUri);
        for (Header header : this.destination.getHeaders(requestUri)) {
            requestBuilder.addHeader((org.apache.hc.core5.http.Header)new BasicHeader(header.getName(), (Object)header.getValue()));
            log.debug("Added HTTP header with key {} originating from a {} with target URI {} for new outbound HTTP request.", new Object[]{header.getName(), this.destination.getClass().getSimpleName(), this.destination.getUri()});
        }
        return requestBuilder.build();
    }

    @Generated
    HttpDestinationProperties getDestination() {
        return this.destination;
    }
}

