/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractX509SslContextProvider;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CfPlatformSslContextProvider
extends AbstractX509SslContextProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CfPlatformSslContextProvider.class);
    private static final String SECURITY_PROVIDER_CLASS_NAME = "org.cloudfoundry.security.CloudFoundryContainerProvider";
    private static final Long CACHE_DURATION_IN_MILLIS = Duration.ofMinutes(5L).toMillis();
    @Nonnull
    private static Function<String, String> environmentVariableReader = System::getenv;
    static final String CERT_ENVIRONMENT_VARIABLE = "CF_INSTANCE_CERT";
    static final String KEY_ENVIRONMENT_VARIABLE = "CF_INSTANCE_KEY";
    private final Cache cache = new Cache();
    private boolean securityProviderAvailable = Try.of((CheckedFunction0 & Serializable)() -> Class.forName(SECURITY_PROVIDER_CLASS_NAME)).isSuccess();

    CfPlatformSslContextProvider() {
    }

    @Nonnull
    public Try<SSLContext> tryGetContext() {
        Try result;
        Option<SSLContext> maybeCachedContext = this.cache.get();
        if (maybeCachedContext.isDefined()) {
            return maybeCachedContext.toTry();
        }
        if (this.securityProviderAvailable) {
            log.trace("Using security provider from buildpack to establish SSL context with platform provided identity.");
            result = Try.of(SSLContext::getDefault);
        } else {
            result = this.tryLoadInstanceIdentity();
        }
        result.onSuccess(this.cache::set);
        return result;
    }

    static void setEnvironmentVariableReader(@Nonnull Function<String, String> environmentVariableReader) {
        CfPlatformSslContextProvider.environmentVariableReader = environmentVariableReader;
    }

    private static Option<String> getEnvironmentVariable(String name) {
        return Option.of((Object)environmentVariableReader.apply(name));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    Try<SSLContext> tryLoadInstanceIdentity() {
        Option<String> maybeCertPath = CfPlatformSslContextProvider.getEnvironmentVariable(CERT_ENVIRONMENT_VARIABLE);
        Option<String> maybeKeyPath = CfPlatformSslContextProvider.getEnvironmentVariable(KEY_ENVIRONMENT_VARIABLE);
        if (maybeCertPath.isEmpty() || maybeKeyPath.isEmpty()) {
            log.warn("Unable to create SSL context from environment: Environment variables {} and/or {} are not defined.\nProceeding without platform provided identity certificate. mTLS connections to other systems may not be possible.", (Object)CERT_ENVIRONMENT_VARIABLE, (Object)KEY_ENVIRONMENT_VARIABLE);
            return Try.of(SSLContext::getDefault);
        }
        String preparedErrorMessage = "Failed to read the %s file declared in %s: File does not exist.";
        Try maybeCertFile = maybeCertPath.toTry().map(File::new).filter(File::exists, () -> new CloudPlatformException(String.format("Failed to read the %s file declared in %s: File does not exist.", "certificate", CERT_ENVIRONMENT_VARIABLE)));
        Try maybeKeyFile = maybeKeyPath.toTry().map(File::new).filter(File::exists, () -> new CloudPlatformException(String.format("Failed to read the %s file declared in %s: File does not exist.", "key", KEY_ENVIRONMENT_VARIABLE)));
        if (maybeCertFile.isFailure()) {
            return Try.failure((Throwable)maybeCertFile.getCause());
        }
        if (maybeKeyFile.isFailure()) {
            return Try.failure((Throwable)maybeKeyFile.getCause());
        }
        File certFile = (File)maybeCertFile.get();
        if (this.cache.getLastModified() != null && certFile.lastModified() == this.cache.getLastModified().longValue()) {
            log.trace("Certificate file is unchanged, using cached SSL context.");
            return Try.success((Object)this.cache.getLastCachedValue());
        }
        this.cache.setLastModified(certFile.lastModified());
        try (BufferedReader certReader = Files.newBufferedReader(certFile.toPath(), StandardCharsets.UTF_8);){
            Try<SSLContext> try_;
            block18: {
                BufferedReader keyReader = Files.newBufferedReader(((File)maybeKeyFile.get()).toPath(), StandardCharsets.UTF_8);
                try {
                    try_ = this.tryGetContext(certReader, keyReader);
                    if (keyReader == null) break block18;
                }
                catch (Throwable throwable) {
                    if (keyReader != null) {
                        try {
                            ((Reader)keyReader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)keyReader).close();
            }
            return try_;
        }
        catch (IOException e) {
            return Try.failure((Throwable)new CloudPlatformException("Should not happen: Instance identity certificate files were removed while reading.", (Throwable)e));
        }
    }

    void setCacheDuration(@Nonnull Duration duration) {
        this.cache.setCacheDuration(duration.toMillis());
    }

    @Generated
    Cache getCache() {
        return this.cache;
    }

    @Generated
    public void setSecurityProviderAvailable(boolean securityProviderAvailable) {
        this.securityProviderAvailable = securityProviderAvailable;
    }

    static final class Cache {
        private long cacheDuration = CACHE_DURATION_IN_MILLIS;
        private SSLContext context = null;
        private Long cachedAt = null;
        private Long lastModified = null;

        Cache() {
        }

        @Nonnull
        Option<SSLContext> get() {
            if (this.context != null && this.cacheDuration > 0L && this.cachedAt + this.cacheDuration >= System.currentTimeMillis()) {
                return Option.some((Object)this.context);
            }
            return Option.none();
        }

        synchronized void set(SSLContext context) {
            this.context = context;
            this.cachedAt = System.currentTimeMillis();
        }

        @Nullable
        SSLContext getLastCachedValue() {
            return this.context;
        }

        @Generated
        public void setCacheDuration(long cacheDuration) {
            this.cacheDuration = cacheDuration;
        }

        @Generated
        public Long getLastModified() {
            return this.lastModified;
        }

        @Generated
        public void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }
    }
}

